/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.plugin.java;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import net.md_5.specialsource.JarMapping;
import net.md_5.specialsource.JarRemapper;
import net.md_5.specialsource.RemapperProcessor;
import net.md_5.specialsource.provider.ClassLoaderProvider;
import net.md_5.specialsource.provider.InheritanceProvider;
import net.md_5.specialsource.repo.ClassRepo;
import net.md_5.specialsource.repo.RuntimeRepo;
import net.md_5.specialsource.transformer.MappingTransformer;
import net.md_5.specialsource.transformer.MavenShade;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang.Validate;
import org.bouncycastle.util.io.Streams;
import org.bukkit.craftbukkit.v1_6_R3.CraftServer;
import org.bukkit.plugin.AuthorNagException;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPluginLoader;

public class PluginClassLoader
extends URLClassLoader {
    private final JavaPluginLoader loader;
    private final ConcurrentMap<String, Class<?>> classes = new ConcurrentHashMap();
    final boolean extended = this.getClass() != PluginClassLoader.class;
    private JarRemapper remapper;
    private RemapperProcessor remapperProcessor;
    private boolean debug;
    private int remapFlags = -1;
    private static ConcurrentMap<Integer, JarMapping> jarMappings = new ConcurrentHashMap<Integer, JarMapping>();
    private static final int F_USE_GUAVA10 = 2;
    private static final int F_GLOBAL_INHERIT = 4;
    private static final int F_REMAP_OBCPRE = 8;
    private static final int F_REMAP_NMS146 = 16;
    private static final int F_REMAP_OBC146 = 32;
    private static final int F_REMAP_NMS147 = 64;
    private static final int F_REMAP_NMS150 = 128;
    private static final int F_REMAP_NMS151 = 256;
    private static final int F_REMAP_OBC147 = 512;
    private static final int F_REMAP_OBC150 = 1024;
    private static final int F_REMAP_NMS152 = 2048;
    private static final int F_REMAP_OBC151 = 4096;
    private static final int F_REMAP_OBC152 = 8192;
    private static final int F_REMAP_NMS161 = 16384;
    private static final int F_REMAP_NMS162 = 32768;
    private static final int F_REMAP_NMS164 = 65536;
    private static final int F_REMAP_OBC161 = 131072;
    private static final int F_REMAP_OBC162 = 262144;
    private static final int F_REMAP_OBC164 = 524288;
    private static final int F_REMAP_NMSPRE_MASK = -1048576;
    private static final String org_bukkit_craftbukkit = new String(new char[]{'o', 'r', 'g', '/', 'b', 'u', 'k', 'k', 'i', 't', '/', 'c', 'r', 'a', 'f', 't', 'b', 'u', 'k', 'k', 'i', 't'});

    @Deprecated
    public PluginClassLoader(JavaPluginLoader loader, URL[] urls, ClassLoader parent) {
        this(loader, urls, parent, null);
        if (loader.warn) {
            if (this.extended) {
                loader.server.getLogger().log(Level.WARNING, "PluginClassLoader not intended to be extended by " + this.getClass() + ", and may be final in a future version of Bukkit");
            } else {
                loader.server.getLogger().log(Level.WARNING, "Constructor \"public PluginClassLoader(JavaPluginLoader, URL[], ClassLoader)\" is Deprecated, and may be removed in a future version of Bukkit", new AuthorNagException(""));
            }
            loader.warn = false;
        }
    }

    PluginClassLoader(JavaPluginLoader loader, URL[] urls, ClassLoader parent, PluginDescriptionFile pluginDescriptionFile) {
        super(urls, parent);
        Validate.notNull((Object)loader, (String)"Loader cannot be null");
        this.loader = loader;
        String pluginName = pluginDescriptionFile.getName();
        MinecraftServer.F();
        boolean useCustomClassLoader = MinecraftServer.cauldronConfig.getBoolean("plugin-settings.default.custom-class-loader", true);
        MinecraftServer.F();
        this.debug = MinecraftServer.cauldronConfig.getBoolean("plugin-settings.default.debug", false);
        MinecraftServer.F();
        boolean useGuava10 = MinecraftServer.cauldronConfig.getBoolean("plugin-settings.default.use-guava10", true);
        MinecraftServer.F();
        boolean remapNMS164 = MinecraftServer.cauldronConfig.getBoolean("plugin-settings.default.remap-nms-v1_6_R3", true);
        MinecraftServer.F();
        boolean remapNMS162 = MinecraftServer.cauldronConfig.getBoolean("plugin-settings.default.remap-nms-v1_6_R2", true);
        MinecraftServer.F();
        boolean remapNMS161 = MinecraftServer.cauldronConfig.getBoolean("plugin-settings.default.remap-nms-v1_6_R1", true);
        MinecraftServer.F();
        boolean remapNMS152 = MinecraftServer.cauldronConfig.getBoolean("plugin-settings.default.remap-nms-v1_5_R3", true);
        MinecraftServer.F();
        boolean remapNMS151 = MinecraftServer.cauldronConfig.getBoolean("plugin-settings.default.remap-nms-v1_5_R2", true);
        MinecraftServer.F();
        boolean remapNMS150 = MinecraftServer.cauldronConfig.getBoolean("plugin-settings.default.remap-nms-v1_5_R1", true);
        MinecraftServer.F();
        boolean remapNMS147 = MinecraftServer.cauldronConfig.getBoolean("plugin-settings.default.remap-nms-v1_4_R1", true);
        MinecraftServer.F();
        boolean remapNMS146 = MinecraftServer.cauldronConfig.getBoolean("plugin-settings.default.remap-nms-v1_4_6", true);
        MinecraftServer.F();
        String remapNMSPre = MinecraftServer.cauldronConfig.getString("plugin-settings.default.remap-nms-pre", "false");
        MinecraftServer.F();
        boolean remapOBC164 = MinecraftServer.cauldronConfig.getBoolean("plugin-settings.default.remap-obc-v1_6_R3", false);
        MinecraftServer.F();
        boolean remapOBC162 = MinecraftServer.cauldronConfig.getBoolean("plugin-settings.default.remap-obc-v1_6_R2", false);
        MinecraftServer.F();
        boolean remapOBC161 = MinecraftServer.cauldronConfig.getBoolean("plugin-settings.default.remap-obc-v1_6_R1", false);
        MinecraftServer.F();
        boolean remapOBC152 = MinecraftServer.cauldronConfig.getBoolean("plugin-settings.default.remap-obc-v1_5_R3", true);
        MinecraftServer.F();
        boolean remapOBC151 = MinecraftServer.cauldronConfig.getBoolean("plugin-settings.default.remap-obc-v1_5_R2", true);
        MinecraftServer.F();
        boolean remapOBC150 = MinecraftServer.cauldronConfig.getBoolean("plugin-settings.default.remap-obc-v1_5_R1", true);
        MinecraftServer.F();
        boolean remapOBC147 = MinecraftServer.cauldronConfig.getBoolean("plugin-settings.default.remap-obc-v1_4_R1", false);
        MinecraftServer.F();
        boolean remapOBC146 = MinecraftServer.cauldronConfig.getBoolean("plugin-settings.default.remap-obc-v1_4_6", false);
        MinecraftServer.F();
        boolean remapOBCPre = MinecraftServer.cauldronConfig.getBoolean("plugin-settings.default.remap-obc-pre", false);
        MinecraftServer.F();
        boolean globalInherit = MinecraftServer.cauldronConfig.getBoolean("plugin-settings.default.global-inheritance", true);
        MinecraftServer.F();
        boolean pluginInherit = MinecraftServer.cauldronConfig.getBoolean("plugin-settings.default.plugin-inheritance", true);
        MinecraftServer.F();
        boolean reflectFields = MinecraftServer.cauldronConfig.getBoolean("plugin-settings.default.remap-reflect-field", true);
        MinecraftServer.F();
        boolean reflectClass = MinecraftServer.cauldronConfig.getBoolean("plugin-settings.default.remap-reflect-class", true);
        MinecraftServer.F();
        boolean allowFuture = MinecraftServer.cauldronConfig.getBoolean("plugin-settings.default.remap-allow-future", false);
        MinecraftServer.F();
        useCustomClassLoader = MinecraftServer.cauldronConfig.getBoolean("plugin-settings." + pluginName + ".custom-class-loader", useCustomClassLoader, false);
        MinecraftServer.F();
        this.debug = MinecraftServer.cauldronConfig.getBoolean("plugin-settings." + pluginName + ".debug", this.debug, false);
        MinecraftServer.F();
        useGuava10 = MinecraftServer.cauldronConfig.getBoolean("plugin-settings." + pluginName + ".use-guava10", useGuava10, false);
        MinecraftServer.F();
        remapNMS164 = MinecraftServer.cauldronConfig.getBoolean("plugin-settings." + pluginName + ".remap-nms-v1_6_R3", remapNMS164, false);
        MinecraftServer.F();
        remapNMS162 = MinecraftServer.cauldronConfig.getBoolean("plugin-settings." + pluginName + ".remap-nms-v1_6_R2", remapNMS162, false);
        MinecraftServer.F();
        remapNMS161 = MinecraftServer.cauldronConfig.getBoolean("plugin-settings." + pluginName + ".remap-nms-v1_6_R1", remapNMS161, false);
        MinecraftServer.F();
        remapNMS152 = MinecraftServer.cauldronConfig.getBoolean("plugin-settings." + pluginName + ".remap-nms-v1_5_R3", remapNMS152, false);
        MinecraftServer.F();
        remapNMS151 = MinecraftServer.cauldronConfig.getBoolean("plugin-settings." + pluginName + ".remap-nms-v1_5_R2", remapNMS151, false);
        MinecraftServer.F();
        remapNMS150 = MinecraftServer.cauldronConfig.getBoolean("plugin-settings." + pluginName + ".remap-nms-v1_5_R1", remapNMS150, false);
        MinecraftServer.F();
        remapNMS147 = MinecraftServer.cauldronConfig.getBoolean("plugin-settings." + pluginName + ".remap-nms-v1_4_R1", remapNMS147, false);
        MinecraftServer.F();
        remapNMS146 = MinecraftServer.cauldronConfig.getBoolean("plugin-settings." + pluginName + ".remap-nms-v1_4_6", remapNMS146, false);
        MinecraftServer.F();
        remapNMSPre = MinecraftServer.cauldronConfig.getString("plugin-settings." + pluginName + ".remap-nms-pre", remapNMSPre, false);
        MinecraftServer.F();
        remapOBC164 = MinecraftServer.cauldronConfig.getBoolean("plugin-settings." + pluginName + ".remap-obc-v1_6_R3", remapOBC164, false);
        MinecraftServer.F();
        remapOBC162 = MinecraftServer.cauldronConfig.getBoolean("plugin-settings." + pluginName + ".remap-obc-v1_6_R2", remapOBC162, false);
        MinecraftServer.F();
        remapOBC161 = MinecraftServer.cauldronConfig.getBoolean("plugin-settings." + pluginName + ".remap-obc-v1_6_R1", remapOBC161, false);
        MinecraftServer.F();
        remapOBC152 = MinecraftServer.cauldronConfig.getBoolean("plugin-settings." + pluginName + ".remap-obc-v1_5_R3", remapOBC152, false);
        MinecraftServer.F();
        remapOBC151 = MinecraftServer.cauldronConfig.getBoolean("plugin-settings." + pluginName + ".remap-obc-v1_5_R2", remapOBC151, false);
        MinecraftServer.F();
        remapOBC150 = MinecraftServer.cauldronConfig.getBoolean("plugin-settings." + pluginName + ".remap-obc-v1_5_R1", remapOBC150, false);
        MinecraftServer.F();
        remapOBC147 = MinecraftServer.cauldronConfig.getBoolean("plugin-settings." + pluginName + ".remap-obc-v1_4_R1", remapOBC147, false);
        MinecraftServer.F();
        remapOBC146 = MinecraftServer.cauldronConfig.getBoolean("plugin-settings." + pluginName + ".remap-obc-v1_4_6", remapOBC146, false);
        MinecraftServer.F();
        remapOBCPre = MinecraftServer.cauldronConfig.getBoolean("plugin-settings." + pluginName + ".remap-obc-pre", remapOBCPre, false);
        MinecraftServer.F();
        globalInherit = MinecraftServer.cauldronConfig.getBoolean("plugin-settings." + pluginName + ".global-inheritance", globalInherit, false);
        MinecraftServer.F();
        pluginInherit = MinecraftServer.cauldronConfig.getBoolean("plugin-settings." + pluginName + ".plugin-inheritance", pluginInherit, false);
        MinecraftServer.F();
        reflectFields = MinecraftServer.cauldronConfig.getBoolean("plugin-settings." + pluginName + ".remap-reflect-field", reflectFields, false);
        MinecraftServer.F();
        reflectClass = MinecraftServer.cauldronConfig.getBoolean("plugin-settings." + pluginName + ".remap-reflect-class", reflectClass, false);
        MinecraftServer.F();
        allowFuture = MinecraftServer.cauldronConfig.getBoolean("plugin-settings." + pluginName + ".remap-allow-future", allowFuture, false);
        if (this.debug) {
            System.out.println("PluginClassLoader debugging enabled for " + pluginName);
        }
        if (!useCustomClassLoader) {
            this.remapper = null;
            return;
        }
        int flags = 0;
        if (useGuava10) {
            flags |= 2;
        }
        if (remapNMS164) {
            flags |= 0x10000;
        }
        if (remapNMS162) {
            flags |= 0x8000;
        }
        if (remapNMS161) {
            flags |= 0x4000;
        }
        if (remapNMS152) {
            flags |= 0x800;
        }
        if (remapNMS151) {
            flags |= 0x100;
        }
        if (remapNMS150) {
            flags |= 0x80;
        }
        if (remapNMS147) {
            flags |= 0x40;
        }
        if (remapNMS146) {
            flags |= 0x10;
        }
        if (!remapNMSPre.equals("false")) {
            if (remapNMSPre.equals("1.6.4")) {
                flags |= 0x16400000;
            } else if (remapNMSPre.equals("1.6.2")) {
                flags |= 0x16200000;
            } else if (remapNMSPre.equals("1.6.1")) {
                flags |= 0x16100000;
            } else if (remapNMSPre.equals("1.5.2")) {
                flags |= 0x15200000;
            } else if (remapNMSPre.equals("1.5.1")) {
                flags |= 0x15100000;
            } else if (remapNMSPre.equals("1.5.0")) {
                flags |= 0x15000000;
            } else if (remapNMSPre.equals("1.5")) {
                flags |= 0x15000000;
            } else if (remapNMSPre.equals("1.4.7")) {
                flags |= 0x14700000;
            } else if (remapNMSPre.equals("1.4.6")) {
                flags |= 0x14600000;
            } else if (remapNMSPre.equals("1.4.5")) {
                flags |= 0x14500000;
            } else if (remapNMSPre.equals("1.4.4")) {
                flags |= 0x14400000;
            } else if (remapNMSPre.equals("1.4.2")) {
                flags |= 0x14200000;
            } else if (remapNMSPre.equals("1.3.2")) {
                flags |= 0x13200000;
            } else if (remapNMSPre.equals("1.3.1")) {
                flags |= 0x13100000;
            } else if (remapNMSPre.equals("1.2.5")) {
                flags |= 0x12500000;
            } else {
                System.out.println("Unsupported nms-remap-pre version '" + remapNMSPre + "', disabling");
            }
        }
        if (remapOBC164) {
            flags |= 0x80000;
        }
        if (remapOBC162) {
            flags |= 0x40000;
        }
        if (remapOBC161) {
            flags |= 0x20000;
        }
        if (remapOBC152) {
            flags |= 0x2000;
        }
        if (remapOBC151) {
            flags |= 0x1000;
        }
        if (remapOBC150) {
            flags |= 0x400;
        }
        if (remapOBC147) {
            flags |= 0x200;
        }
        if (remapOBC146) {
            flags |= 0x20;
        }
        if (remapOBCPre) {
            flags |= 8;
        }
        if (globalInherit) {
            flags |= 4;
        }
        this.remapFlags = flags;
        JarMapping jarMapping = this.getJarMapping(flags);
        if ((flags & 4) != 0) {
            if (this.debug) {
                System.out.println("Enabling global inheritance remapping");
            }
            jarMapping.setInheritanceMap(loader.getGlobalInheritanceMap());
            jarMapping.setFallbackInheritanceProvider((InheritanceProvider)new ClassLoaderProvider((ClassLoader)this));
        }
        this.remapper = new JarRemapper(jarMapping);
        if (pluginInherit || reflectFields || reflectClass) {
            this.remapperProcessor = new RemapperProcessor(pluginInherit ? loader.getGlobalInheritanceMap() : null, (JarMapping)(reflectFields || reflectClass ? jarMapping : null));
            this.remapperProcessor.setRemapReflectField(reflectFields);
            this.remapperProcessor.setRemapReflectClass(reflectClass);
            this.remapperProcessor.debug = this.debug;
        } else {
            this.remapperProcessor = null;
        }
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        return this.extended ? this.findClass(name, true) : this.findClass0(name, true);
    }

    @Deprecated
    protected Class<?> findClass(String name, boolean checkGlobal) throws ClassNotFoundException {
        if (this.loader.warn) {
            this.loader.server.getLogger().log(Level.WARNING, "Method \"protected Class<?> findClass(String, boolean)\" is Deprecated, and may be removed in a future version of Bukkit", new AuthorNagException(""));
            this.loader.warn = false;
        }
        return this.findClass0(name, checkGlobal);
    }

    @Deprecated
    public Set<String> getClasses() {
        if (this.loader.warn) {
            this.loader.server.getLogger().log(Level.WARNING, "Method \"public Set<String> getClasses()\" is Deprecated, and may be removed in a future version of Bukkit", new AuthorNagException(""));
            this.loader.warn = false;
        }
        return this.getClasses0();
    }

    Set<String> getClasses0() {
        return this.classes.keySet();
    }

    public static String getNativeVersion() {
        String packageName = CraftServer.class.getPackage().getName();
        return packageName.substring(packageName.lastIndexOf(46) + 1);
    }

    private void loadNmsMappings(JarMapping jarMapping, String obfVersion) throws IOException {
        HashMap<String, String> relocations = new HashMap<String, String>();
        relocations.put("net.minecraft.server", "net.minecraft.server." + obfVersion);
        jarMapping.loadMappings(new BufferedReader(new InputStreamReader(this.loader.getClass().getClassLoader().getResourceAsStream("mappings/" + obfVersion + "/cb2numpkg.srg"))), (MappingTransformer)new MavenShade(relocations), null, false);
        jarMapping.methods.put("net/minecraft/server/" + obfVersion + "/PlayerConnection/getPlayer ()Lorg/bukkit/craftbukkit/" + PluginClassLoader.getNativeVersion() + "/entity/CraftPlayer;", "getPlayerB");
    }

    private JarMapping getJarMapping(int flags) {
        JarMapping jarMapping = (JarMapping)jarMappings.get(flags);
        if (jarMapping != null) {
            if (this.debug) {
                System.out.println("Mapping reused for " + Integer.toHexString(flags));
            }
            return jarMapping;
        }
        jarMapping = new JarMapping();
        try {
            if ((flags & 2) != 0) {
                jarMapping.packages.put("com/google/common", "guava10/com/google/common");
            }
            jarMapping.packages.put(org_bukkit_craftbukkit + "/libs/com/google/gson", "com/google/gson");
            if ((flags & 0x10000) != 0) {
                this.loadNmsMappings(jarMapping, "v1_6_R3");
            }
            if ((flags & 0x8000) != 0) {
                this.loadNmsMappings(jarMapping, "v1_6_R2");
            }
            if ((flags & 0x4000) != 0) {
                this.loadNmsMappings(jarMapping, "v1_6_R1");
            }
            if ((flags & 0x800) != 0) {
                this.loadNmsMappings(jarMapping, "v1_5_R3");
            }
            if ((flags & 0x100) != 0) {
                this.loadNmsMappings(jarMapping, "v1_5_R2");
            }
            if ((flags & 0x80) != 0) {
                this.loadNmsMappings(jarMapping, "v1_5_R1");
            }
            if ((flags & 0x40) != 0) {
                this.loadNmsMappings(jarMapping, "v1_4_R1");
            }
            if ((flags & 0x10) != 0) {
                this.loadNmsMappings(jarMapping, "v1_4_6");
            }
            if ((flags & 0x80000) != 0) {
                jarMapping.packages.put(org_bukkit_craftbukkit + "/v1_6_R3", org_bukkit_craftbukkit + "/" + PluginClassLoader.getNativeVersion());
            }
            if ((flags & 0x40000) != 0) {
                jarMapping.packages.put(org_bukkit_craftbukkit + "/v1_6_R2", org_bukkit_craftbukkit + "/" + PluginClassLoader.getNativeVersion());
            }
            if ((flags & 0x20000) != 0) {
                jarMapping.packages.put(org_bukkit_craftbukkit + "/v1_6_R1", org_bukkit_craftbukkit + "/" + PluginClassLoader.getNativeVersion());
            }
            if ((flags & 0x2000) != 0) {
                jarMapping.packages.put(org_bukkit_craftbukkit + "/v1_5_R3", org_bukkit_craftbukkit + "/" + PluginClassLoader.getNativeVersion());
            }
            if ((flags & 0x1000) != 0) {
                jarMapping.packages.put(org_bukkit_craftbukkit + "/v1_5_R2", org_bukkit_craftbukkit + "/" + PluginClassLoader.getNativeVersion());
            }
            if ((flags & 0x400) != 0) {
                jarMapping.packages.put(org_bukkit_craftbukkit + "/v1_5_R1", org_bukkit_craftbukkit + "/" + PluginClassLoader.getNativeVersion());
            }
            if ((flags & 0x200) != 0) {
                jarMapping.packages.put(org_bukkit_craftbukkit + "/v1_4_R1", org_bukkit_craftbukkit + "/" + PluginClassLoader.getNativeVersion());
            }
            if ((flags & 0x20) != 0) {
                jarMapping.packages.put(org_bukkit_craftbukkit + "/v1_4_6", org_bukkit_craftbukkit + "/" + PluginClassLoader.getNativeVersion());
            }
            if ((flags & 8) != 0) {
                jarMapping.packages.put(org_bukkit_craftbukkit + "/libs/org/objectweb/asm", "org/objectweb/asm");
                jarMapping.packages.put(org_bukkit_craftbukkit, org_bukkit_craftbukkit + "/" + PluginClassLoader.getNativeVersion());
            }
            if ((flags & 0xFFF00000) != 0) {
                String filename;
                switch (flags & 0xFFF00000) {
                    case 23330816: {
                        filename = "mappings/v1_6_R3/cb2numpkg.srg";
                        break;
                    }
                    case 23199744: {
                        filename = "mappings/v1_6_R2/cb2numpkg.srg";
                        break;
                    }
                    case 0x1610000: {
                        filename = "mappings/v1_6_R1/cb2numpkg.srg";
                        break;
                    }
                    case 0x1510000: {
                        filename = "mappings/v1_5_R2/cb2numpkg.srg";
                        break;
                    }
                    case 0x1500000: {
                        filename = "mappings/v1_5_R1/cb2numpkg.srg";
                        break;
                    }
                    case 21430272: {
                        filename = "mappings/v1_4_R1/cb2numpkg.srg";
                        break;
                    }
                    case 21364736: {
                        filename = "mappings/v1_4_6/cb2numpkg.srg";
                        break;
                    }
                    case 21299200: {
                        filename = "mappings/v1_4_5/cb2numpkg.srg";
                        break;
                    }
                    case 0x1440000: {
                        filename = "mappings/v1_4_4/cb2numpkg.srg";
                        break;
                    }
                    case 21102592: {
                        filename = "mappings/v1_4_2/cb2numpkg.srg";
                        break;
                    }
                    case 20054016: {
                        filename = "mappings/v1_3_2/cb2numpkg.srg";
                        break;
                    }
                    case 0x1310000: {
                        filename = "mappings/v1_3_1/cb2numpkg.srg";
                        break;
                    }
                    case 19202048: {
                        filename = "mappings/v1_2_5/cb2numpkg.srg";
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid unversioned mapping flags: " + Integer.toHexString(flags & 0xFFF00000) + " in " + Integer.toHexString(flags));
                    }
                }
                jarMapping.loadMappings(new BufferedReader(new InputStreamReader(this.loader.getClass().getClassLoader().getResourceAsStream(filename))), null, null, false);
            }
            System.out.println("Mapping loaded " + jarMapping.packages.size() + " packages, " + jarMapping.classes.size() + " classes, " + jarMapping.fields.size() + " fields, " + jarMapping.methods.size() + " methods, flags " + Integer.toHexString(flags));
            JarMapping currentJarMapping = jarMappings.putIfAbsent(flags, jarMapping);
            return currentJarMapping == null ? jarMapping : currentJarMapping;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Class<?> findClass0(String name, boolean checkGlobal) throws ClassNotFoundException {
        if (name.startsWith("net.minecraft.")) {
            JarMapping jarMapping = this.getJarMapping(this.remapFlags);
            String remappedClass = (String)jarMapping.classes.get(name.replaceAll("\\.", "\\/"));
            Class clazz = ((LaunchClassLoader)MinecraftServer.F().getClass().getClassLoader()).findClass(remappedClass);
            return clazz;
        }
        if (name.startsWith("org.bukkit.")) {
            if (this.debug) {
                System.out.println("Unexpected plugin findClass on OBC: name=" + name + ", checkGlobal=" + checkGlobal + "; returning not found");
            }
            throw new ClassNotFoundException(name);
        }
        String string = name.intern();
        synchronized (string) {
            Class<?> result = (Class<?>)this.classes.get(name);
            if (result == null) {
                Class<?> old;
                if (checkGlobal) {
                    Class<?> clazz = result = this.loader.extended ? this.loader.getClassByName(name) : this.loader.getClassByName0(name);
                }
                if (result == null && (result = this.remapper == null ? super.findClass(name) : this.remappedFindClass(name)) != null) {
                    if (this.loader.extended) {
                        this.loader.setClass(name, result);
                    } else {
                        this.loader.setClass0(name, result);
                    }
                }
                if (result != null && (old = this.classes.putIfAbsent(name, result)) != null && old != result) {
                    System.err.println("Defined class " + name + " twice as different classes, " + result + " and " + old);
                    result = old;
                }
            }
            return result;
        }
    }

    private Class<?> remappedFindClass(String name) throws ClassNotFoundException {
        Class<?> result;
        block9: {
            result = null;
            try {
                JarURLConnection jarURLConnection;
                URL jarURL;
                CodeSource codeSource;
                InputStream stream;
                String path = name.replace('.', '/').concat(".class");
                URL url = this.findResource(path);
                if (url == null || (stream = url.openStream()) == null) break block9;
                byte[] bytecode = null;
                if (this.remapperProcessor != null && (bytecode = this.remapperProcessor.process(stream)) == null) {
                    stream = url.openStream();
                }
                if (bytecode == null) {
                    bytecode = Streams.readAll((InputStream)stream);
                }
                byte[] remappedBytecode = this.remapper.remapClassFile(bytecode, (ClassRepo)RuntimeRepo.getInstance());
                if (this.debug) {
                    File file = new File("remapped-plugin-classes/" + name + ".class");
                    file.getParentFile().mkdirs();
                    try {
                        FileOutputStream fileOutputStream = new FileOutputStream(file);
                        fileOutputStream.write(remappedBytecode);
                        fileOutputStream.close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
                if ((result = this.defineClass(name, remappedBytecode, 0, remappedBytecode.length, codeSource = new CodeSource(jarURL = (jarURLConnection = (JarURLConnection)url.openConnection()).getJarFileURL(), new CodeSigner[0]))) != null) {
                    this.resolveClass(result);
                }
            }
            catch (Throwable t2) {
                if (this.debug) {
                    System.out.println("remappedFindClass(" + name + ") exception: " + t2);
                    t2.printStackTrace();
                }
                throw new ClassNotFoundException("Failed to remap class " + name, t2);
            }
        }
        return result;
    }
}

