/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.executors;

import com.comphenix.executors.AbstractListeningService;
import com.comphenix.executors.ListenableScheduledFuture;
import com.google.common.base.Preconditions;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class CallableTask<T>
extends AbstractListeningService.RunnableAbstractFuture<T> {
    protected final Callable<T> compute;

    public CallableTask(Callable<T> compute) {
        Preconditions.checkNotNull(compute, (Object)"compute cannot be NULL");
        this.compute = compute;
    }

    public ListenableScheduledFuture<T> getScheduledFuture(final long startTime, final long nextDelay) {
        return new ListenableScheduledFuture<T>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return CallableTask.this.cancel(mayInterruptIfRunning);
            }

            @Override
            public T get() throws InterruptedException, ExecutionException {
                return CallableTask.this.get();
            }

            @Override
            public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return CallableTask.this.get(timeout, unit);
            }

            @Override
            public boolean isCancelled() {
                return CallableTask.this.isCancelled();
            }

            @Override
            public boolean isDone() {
                return CallableTask.this.isDone();
            }

            public void addListener(Runnable listener, Executor executor) {
                CallableTask.this.addListener(listener, executor);
            }

            @Override
            public int compareTo(Delayed o) {
                return Long.compare(this.getDelay(TimeUnit.NANOSECONDS), o.getDelay(TimeUnit.NANOSECONDS));
            }

            @Override
            public long getDelay(TimeUnit unit) {
                long current = System.nanoTime();
                if (current < startTime || !this.isPeriodic()) {
                    return unit.convert(startTime - current, TimeUnit.NANOSECONDS);
                }
                return unit.convert((current - startTime) % nextDelay, TimeUnit.NANOSECONDS);
            }

            @Override
            public boolean isPeriodic() {
                return nextDelay > 0L;
            }

            @Override
            public void run() {
                CallableTask.this.compute();
            }
        };
    }

    protected void compute() {
        try {
            if (!this.isCancelled()) {
                this.set(this.compute.call());
            }
        }
        catch (Throwable e) {
            this.setException(e);
        }
    }

    @Override
    public void run() {
        this.compute();
    }
}

