/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.executors;

import com.comphenix.executors.BukkitFutures;
import com.google.common.collect.MapMaker;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.bukkit.event.Event;
import org.bukkit.event.EventException;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;

class PluginDisabledListener
implements Listener {
    private static ConcurrentMap<Plugin, PluginDisabledListener> listeners = new MapMaker().weakKeys().makeMap();
    private Set<Future<?>> futures = Collections.newSetFromMap(new WeakHashMap());
    private Set<ExecutorService> services = Collections.newSetFromMap(new WeakHashMap());
    private Object setLock = new Object();
    private final Plugin plugin;
    private boolean disabled;

    private PluginDisabledListener(Plugin plugin) {
        this.plugin = plugin;
    }

    public static PluginDisabledListener getListener(Plugin plugin) {
        PluginDisabledListener created;
        PluginDisabledListener result = (PluginDisabledListener)listeners.get(plugin);
        if (result == null && (result = listeners.putIfAbsent(plugin, created = new PluginDisabledListener(plugin))) == null) {
            BukkitFutures.registerEventExecutor(plugin, PluginDisableEvent.class, EventPriority.NORMAL, new EventExecutor(){

                public void execute(Listener listener, Event event) throws EventException {
                    if (event instanceof PluginDisableEvent) {
                        PluginDisabledListener.this.onPluginDisabled((PluginDisableEvent)event);
                    }
                }
            });
            result = created;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFuture(final ListenableFuture<?> future) {
        Object object = this.setLock;
        synchronized (object) {
            if (this.disabled) {
                this.processFuture((Future<?>)future);
            } else {
                this.futures.add((Future<?>)future);
            }
        }
        Futures.addCallback(future, (FutureCallback)new FutureCallback<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSuccess(Object value) {
                Object object = PluginDisabledListener.this.setLock;
                synchronized (object) {
                    PluginDisabledListener.this.futures.remove(future);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onFailure(Throwable ex) {
                Object object = PluginDisabledListener.this.setLock;
                synchronized (object) {
                    PluginDisabledListener.this.futures.remove(future);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addService(ExecutorService service) {
        Object object = this.setLock;
        synchronized (object) {
            if (this.disabled) {
                this.processService(service);
            } else {
                this.services.add(service);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPluginDisabled(PluginDisableEvent e) {
        if (e.getPlugin().equals(this.plugin)) {
            Object object = this.setLock;
            synchronized (object) {
                this.disabled = true;
                for (Future<?> future : this.futures) {
                    this.processFuture(future);
                }
                for (ExecutorService service : this.services) {
                    this.processService(service);
                }
            }
        }
    }

    private void processFuture(Future<?> future) {
        if (!future.isDone()) {
            future.cancel(true);
        }
    }

    private void processService(ExecutorService service) {
        service.shutdownNow();
    }
}

