/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.events;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.ListenerOptions;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.injector.GamePhase;
import com.comphenix.protocol.injector.packet.PacketRegistry;
import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public class ListeningWhitelist {
    public static final ListeningWhitelist EMPTY_WHITELIST = new ListeningWhitelist(ListenerPriority.LOW, new Integer[0]);
    private final ListenerPriority priority;
    private final GamePhase gamePhase;
    private final Set<ListenerOptions> options;
    private final Set<PacketType> types;
    private transient Set<Integer> intWhitelist;

    private ListeningWhitelist(Builder builder) {
        this.priority = builder.priority;
        this.types = builder.types;
        this.gamePhase = builder.gamePhase;
        this.options = builder.options;
    }

    @Deprecated
    public ListeningWhitelist(ListenerPriority priority, Set<Integer> whitelist) {
        this(priority, whitelist, GamePhase.PLAYING);
    }

    @Deprecated
    public ListeningWhitelist(ListenerPriority priority, Set<Integer> whitelist, GamePhase gamePhase) {
        this.priority = priority;
        this.types = PacketRegistry.toPacketTypes(ListeningWhitelist.safeSet(whitelist));
        this.gamePhase = gamePhase;
        this.options = EnumSet.noneOf(ListenerOptions.class);
    }

    @Deprecated
    public ListeningWhitelist(ListenerPriority priority, Integer ... whitelist) {
        this.priority = priority;
        this.types = PacketRegistry.toPacketTypes(Sets.newHashSet((Object[])whitelist));
        this.gamePhase = GamePhase.PLAYING;
        this.options = EnumSet.noneOf(ListenerOptions.class);
    }

    @Deprecated
    public ListeningWhitelist(ListenerPriority priority, Integer[] whitelist, GamePhase gamePhase) {
        this.priority = priority;
        this.types = PacketRegistry.toPacketTypes(Sets.newHashSet((Object[])whitelist));
        this.gamePhase = gamePhase;
        this.options = EnumSet.noneOf(ListenerOptions.class);
    }

    @Deprecated
    public ListeningWhitelist(ListenerPriority priority, Integer[] whitelist, GamePhase gamePhase, ListenerOptions ... options) {
        this.priority = priority;
        this.types = PacketRegistry.toPacketTypes(Sets.newHashSet((Object[])whitelist));
        this.gamePhase = gamePhase;
        this.options = ListeningWhitelist.safeEnumSet(Arrays.asList(options), ListenerOptions.class);
    }

    public boolean isEnabled() {
        return this.types != null && this.types.size() > 0;
    }

    public ListenerPriority getPriority() {
        return this.priority;
    }

    @Deprecated
    public Set<Integer> getWhitelist() {
        if (this.intWhitelist == null) {
            this.intWhitelist = PacketRegistry.toLegacy(this.types);
        }
        return this.intWhitelist;
    }

    public Set<PacketType> getTypes() {
        return this.types;
    }

    public GamePhase getGamePhase() {
        return this.gamePhase;
    }

    public Set<ListenerOptions> getOptions() {
        return Collections.unmodifiableSet(this.options);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.priority, this.types, this.gamePhase, this.options});
    }

    public static boolean containsAny(ListeningWhitelist whitelist, int ... idList) {
        if (whitelist != null) {
            for (int i = 0; i < idList.length; ++i) {
                if (!whitelist.getWhitelist().contains(idList[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isEmpty(ListeningWhitelist whitelist) {
        if (whitelist == EMPTY_WHITELIST) {
            return true;
        }
        if (whitelist == null) {
            return true;
        }
        return whitelist.getWhitelist().isEmpty();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ListeningWhitelist) {
            ListeningWhitelist other = (ListeningWhitelist)obj;
            return Objects.equal((Object)((Object)this.priority), (Object)((Object)other.priority)) && Objects.equal(this.types, other.types) && Objects.equal((Object)((Object)this.gamePhase), (Object)((Object)other.gamePhase)) && Objects.equal(this.options, other.options);
        }
        return false;
    }

    public String toString() {
        if (this == EMPTY_WHITELIST) {
            return "EMPTY_WHITELIST";
        }
        return Objects.toStringHelper((Object)this).add("priority", (Object)this.priority).add("packets", this.types).add("gamephase", (Object)this.gamePhase).add("options", this.options).toString();
    }

    public static Builder newBuilder() {
        return new Builder(null);
    }

    public static Builder newBuilder(ListeningWhitelist template) {
        return new Builder(template);
    }

    private static <T extends Enum<T>> EnumSet<T> safeEnumSet(Collection<T> options, Class<T> enumClass) {
        if (options != null && !options.isEmpty()) {
            return EnumSet.copyOf(options);
        }
        return EnumSet.noneOf(enumClass);
    }

    private static <T> Set<T> safeSet(Collection<T> set) {
        if (set != null) {
            return Sets.newHashSet(set);
        }
        return Collections.emptySet();
    }

    public static class Builder {
        private ListenerPriority priority;
        private Set<PacketType> types = Sets.newHashSet();
        private GamePhase gamePhase;
        private Set<ListenerOptions> options = Sets.newHashSet();

        private Builder(ListeningWhitelist template) {
            if (template != null) {
                this.priority(template.getPriority());
                this.gamePhase(template.getGamePhase());
                this.types(template.getTypes());
                this.options(template.getOptions());
            }
        }

        public Builder priority(ListenerPriority priority) {
            this.priority = priority;
            return this;
        }

        public Builder monitor() {
            return this.priority(ListenerPriority.MONITOR);
        }

        public Builder normal() {
            return this.priority(ListenerPriority.NORMAL);
        }

        public Builder lowest() {
            return this.priority(ListenerPriority.LOWEST);
        }

        public Builder low() {
            return this.priority(ListenerPriority.LOW);
        }

        public Builder highest() {
            return this.priority(ListenerPriority.HIGHEST);
        }

        public Builder high() {
            return this.priority(ListenerPriority.HIGH);
        }

        @Deprecated
        public Builder whitelist(Collection<Integer> whitelist) {
            this.types = PacketRegistry.toPacketTypes(ListeningWhitelist.safeSet(whitelist));
            return this;
        }

        public Builder types(PacketType ... types) {
            this.types = ListeningWhitelist.safeSet(Sets.newHashSet((Object[])types));
            return this;
        }

        public Builder types(Collection<PacketType> types) {
            this.types = ListeningWhitelist.safeSet(types);
            return this;
        }

        public Builder gamePhase(GamePhase gamePhase) {
            this.gamePhase = gamePhase;
            return this;
        }

        public Builder gamePhaseBoth() {
            return this.gamePhase(GamePhase.BOTH);
        }

        public Builder options(Set<ListenerOptions> options) {
            this.options = ListeningWhitelist.safeSet(options);
            return this;
        }

        public Builder options(Collection<ListenerOptions> options) {
            this.options = ListeningWhitelist.safeSet(options);
            return this;
        }

        public Builder options(ListenerOptions[] serverOptions) {
            this.options = ListeningWhitelist.safeSet(Sets.newHashSet((Object[])serverOptions));
            return this;
        }

        public Builder mergeOptions(ListenerOptions ... serverOptions) {
            return this.mergeOptions(Arrays.asList(serverOptions));
        }

        public Builder mergeOptions(Collection<ListenerOptions> serverOptions) {
            if (this.options == null) {
                return this.options(serverOptions);
            }
            this.options.addAll(serverOptions);
            return this;
        }

        public ListeningWhitelist build() {
            return new ListeningWhitelist(this);
        }
    }
}

