/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector;

import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.error.ErrorReporter;
import com.comphenix.protocol.events.NetworkMarker;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketOutputHandler;
import com.comphenix.protocol.events.PacketPostListener;
import com.comphenix.protocol.events.ScheduledPacket;
import java.util.List;
import java.util.PriorityQueue;

public class NetworkProcessor {
    private ErrorReporter reporter;

    public NetworkProcessor(ErrorReporter reporter) {
        this.reporter = reporter;
    }

    public byte[] processOutput(PacketEvent event, NetworkMarker marker, byte[] input) {
        PriorityQueue handlers = (PriorityQueue)marker.getOutputHandlers();
        byte[] output = input;
        while (!handlers.isEmpty()) {
            PacketOutputHandler handler = (PacketOutputHandler)handlers.poll();
            try {
                byte[] changed = handler.handle(event, output);
                if (changed != null) {
                    output = changed;
                    continue;
                }
                throw new IllegalStateException("Handler cannot return a NULL array.");
            }
            catch (OutOfMemoryError e) {
                throw e;
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Throwable e) {
                this.reporter.reportMinimal(handler.getPlugin(), "PacketOutputHandler.handle()", e);
            }
        }
        return output;
    }

    public void invokePostEvent(PacketEvent event, NetworkMarker marker) {
        if (marker == null) {
            return;
        }
        if (NetworkMarker.hasPostListeners(marker)) {
            for (PacketPostListener listener : marker.getPostListeners()) {
                try {
                    listener.onPostEvent(event);
                }
                catch (OutOfMemoryError e) {
                    throw e;
                }
                catch (ThreadDeath e) {
                    throw e;
                }
                catch (Throwable e) {
                    this.reporter.reportMinimal(listener.getPlugin(), "SentListener.run()", e);
                }
            }
        }
        this.sendScheduledPackets(marker);
    }

    private void sendScheduledPackets(NetworkMarker marker) {
        List<ScheduledPacket> scheduled = NetworkMarker.readScheduledPackets(marker);
        ProtocolManager manager = ProtocolLibrary.getProtocolManager();
        if (scheduled != null) {
            for (ScheduledPacket packet : scheduled) {
                packet.schedule(manager);
            }
        }
    }
}

