/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector.netty;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.Callable;
import net.minecraft.util.io.netty.channel.Channel;
import net.minecraft.util.io.netty.channel.ChannelFuture;
import net.minecraft.util.io.netty.channel.ChannelHandler;

class BootstrapList
implements List<Object> {
    private List<Object> delegate;
    private ChannelHandler handler;

    public BootstrapList(List<Object> delegate, ChannelHandler handler) {
        this.delegate = delegate;
        this.handler = handler;
        for (Object item : this) {
            this.processElement(item);
        }
    }

    @Override
    public synchronized boolean add(Object element) {
        this.processElement(element);
        return this.delegate.add(element);
    }

    @Override
    public synchronized boolean addAll(Collection<? extends Object> collection) {
        ArrayList copy = Lists.newArrayList(collection);
        for (Object element : copy) {
            this.processElement(element);
        }
        return this.delegate.addAll(copy);
    }

    @Override
    public synchronized Object set(int index, Object element) {
        Object old = this.delegate.set(index, element);
        if (old != element) {
            this.unprocessElement(old);
            this.processElement(element);
        }
        return old;
    }

    protected void processElement(Object element) {
        if (element instanceof ChannelFuture) {
            this.processBootstrap((ChannelFuture)element);
        }
    }

    protected void unprocessElement(Object element) {
        if (element instanceof ChannelFuture) {
            this.unprocessBootstrap((ChannelFuture)element);
        }
    }

    protected void processBootstrap(ChannelFuture future) {
        future.channel().pipeline().addFirst(new ChannelHandler[]{this.handler});
    }

    protected void unprocessBootstrap(ChannelFuture future) {
        final Channel channel = future.channel();
        channel.eventLoop().submit((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                channel.pipeline().remove(BootstrapList.this.handler);
                return null;
            }
        });
    }

    public synchronized void close() {
        for (Object element : this) {
            this.unprocessElement(element);
        }
    }

    @Override
    public synchronized int size() {
        return this.delegate.size();
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    public synchronized Iterator<Object> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public synchronized Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public synchronized <T> T[] toArray(T[] a) {
        return this.delegate.toArray(a);
    }

    @Override
    public synchronized boolean remove(Object o) {
        return this.delegate.remove(o);
    }

    @Override
    public synchronized boolean containsAll(Collection<?> c) {
        return this.delegate.containsAll(c);
    }

    @Override
    public synchronized boolean addAll(int index, Collection<? extends Object> c) {
        return this.delegate.addAll(index, c);
    }

    @Override
    public synchronized boolean removeAll(Collection<?> c) {
        return this.delegate.removeAll(c);
    }

    @Override
    public synchronized boolean retainAll(Collection<?> c) {
        return this.delegate.retainAll(c);
    }

    @Override
    public synchronized void clear() {
        this.delegate.clear();
    }

    @Override
    public synchronized Object get(int index) {
        return this.delegate.get(index);
    }

    @Override
    public synchronized void add(int index, Object element) {
        this.delegate.add(index, element);
    }

    @Override
    public synchronized Object remove(int index) {
        return this.delegate.remove(index);
    }

    @Override
    public synchronized int indexOf(Object o) {
        return this.delegate.indexOf(o);
    }

    @Override
    public synchronized int lastIndexOf(Object o) {
        return this.delegate.lastIndexOf(o);
    }

    @Override
    public synchronized ListIterator<Object> listIterator() {
        return this.delegate.listIterator();
    }

    @Override
    public synchronized ListIterator<Object> listIterator(int index) {
        return this.delegate.listIterator(index);
    }

    @Override
    public synchronized List<Object> subList(int fromIndex, int toIndex) {
        return this.delegate.subList(fromIndex, toIndex);
    }
}

