/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector.packet;

import com.comphenix.protocol.reflect.FieldUtils;
import java.lang.reflect.Field;

public class MapContainer {
    private Field modCountField;
    private int lastModCount;
    private Object source;
    private boolean changed;

    public MapContainer(Object source) {
        this.source = source;
        this.changed = true;
        this.modCountField = FieldUtils.getField(source.getClass(), "modCount", true);
    }

    public boolean hasChanged() {
        this.checkChanged();
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    protected void checkChanged() {
        if (!this.changed && this.getModificationCount() != this.lastModCount) {
            this.lastModCount = this.getModificationCount();
            this.changed = true;
        }
    }

    private int getModificationCount() {
        try {
            return this.modCountField != null ? this.modCountField.getInt(this.source) : this.lastModCount + 1;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to retrieve modCount.", e);
        }
    }
}

