/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers;

import com.comphenix.protocol.injector.BukkitUnwrapper;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.ConstructorAccessor;
import com.comphenix.protocol.reflect.accessors.FieldAccessor;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.AbstractWrapper;
import com.comphenix.protocol.wrappers.GuavaWrappers;
import com.comphenix.protocol.wrappers.WrappedSignedProperty;
import com.comphenix.protocol.wrappers.collection.ConvertedMultimap;
import com.google.common.base.Objects;
import com.google.common.collect.Multimap;
import java.util.UUID;
import net.minecraft.util.com.mojang.authlib.GameProfile;
import net.minecraft.util.com.mojang.authlib.properties.Property;
import org.apache.commons.lang.StringUtils;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class WrappedGameProfile
extends AbstractWrapper {
    private static final ConstructorAccessor CREATE_STRING_STRING = Accessors.getConstructorAccessorOrNull(GameProfile.class, String.class, String.class);
    private static final FieldAccessor GET_UUID_STRING = Accessors.getFieldAcccessorOrNull(GameProfile.class, "id", String.class);
    private static FieldAccessor PLAYER_PROFILE;
    private static FieldAccessor OFFLINE_PROFILE;
    private Multimap<String, WrappedSignedProperty> propertyMap;
    private volatile UUID parsedUUID;

    private WrappedGameProfile(Object profile) {
        super(GameProfile.class);
        this.setHandle(profile);
    }

    public static WrappedGameProfile fromPlayer(Player player) {
        FieldAccessor accessor = PLAYER_PROFILE;
        Object nmsPlayer = BukkitUnwrapper.getInstance().unwrapItem(player);
        if (accessor == null) {
            PLAYER_PROFILE = accessor = Accessors.getFieldAccessor(MinecraftReflection.getEntityHumanClass(), GameProfile.class, true);
        }
        return WrappedGameProfile.fromHandle(PLAYER_PROFILE.get(nmsPlayer));
    }

    public static WrappedGameProfile fromOfflinePlayer(OfflinePlayer player) {
        FieldAccessor accessor = OFFLINE_PROFILE;
        if (accessor == null) {
            OFFLINE_PROFILE = accessor = Accessors.getFieldAccessor(player.getClass(), GameProfile.class, true);
        }
        return WrappedGameProfile.fromHandle(OFFLINE_PROFILE.get(player));
    }

    public WrappedGameProfile(String id, String name) {
        super(GameProfile.class);
        if (CREATE_STRING_STRING != null) {
            this.setHandle(CREATE_STRING_STRING.invoke(id, name));
        } else {
            try {
                this.setHandle(new GameProfile(WrappedGameProfile.parseUUID(id), name));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Cannot construct profile [" + id + ", " + name + "]", e);
            }
        }
    }

    public WrappedGameProfile(UUID uuid, String name) {
        super(GameProfile.class);
        if (CREATE_STRING_STRING != null) {
            this.setHandle(CREATE_STRING_STRING.invoke(uuid != null ? uuid.toString() : null, name));
        } else {
            this.setHandle(new GameProfile(uuid, name));
        }
    }

    public static WrappedGameProfile fromHandle(Object handle) {
        if (handle == null) {
            return null;
        }
        return new WrappedGameProfile(handle);
    }

    private static UUID parseUUID(String id) {
        int missing;
        if (id == null) {
            return null;
        }
        if (StringUtils.isBlank((String)id)) {
            id = "0";
        }
        if ((missing = 4 - StringUtils.countMatches((String)id, (String)"-")) > 0) {
            if (id.length() < 12) {
                id = id + StringUtils.repeat((String)"-0", (int)missing);
            } else if (id.length() >= 32) {
                StringBuilder builder = new StringBuilder(id);
                for (int position = 8; missing > 0 && position < builder.length(); position += 5, --missing) {
                    builder.insert(position, "-");
                }
                id = builder.toString();
            } else {
                throw new IllegalArgumentException("Invalid partial UUID: " + id);
            }
        }
        return UUID.fromString(id);
    }

    public UUID getUUID() {
        UUID uuid = this.parsedUUID;
        if (uuid == null) {
            try {
                uuid = GET_UUID_STRING != null ? WrappedGameProfile.parseUUID(this.getId()) : this.getProfile().getId();
                this.parsedUUID = uuid;
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException("Cannot parse ID " + this.getId() + " as an UUID in player profile " + this.getName());
            }
        }
        return uuid;
    }

    public String getId() {
        if (GET_UUID_STRING != null) {
            return (String)GET_UUID_STRING.get(this.handle);
        }
        GameProfile profile = this.getProfile();
        return profile.getId() != null ? profile.getId().toString() : null;
    }

    public String getName() {
        return this.getProfile().getName();
    }

    public Multimap<String, WrappedSignedProperty> getProperties() {
        ConvertedMultimap<String, Property, WrappedSignedProperty> result = this.propertyMap;
        if (result == null) {
            this.propertyMap = result = new ConvertedMultimap<String, Property, WrappedSignedProperty>(GuavaWrappers.getBukkitMultimap(this.getProfile().getProperties())){

                @Override
                protected Property toInner(WrappedSignedProperty outer) {
                    return (Property)outer.handle;
                }

                @Override
                protected Object toInnerObject(Object outer) {
                    if (outer instanceof WrappedSignedProperty) {
                        return this.toInner((WrappedSignedProperty)outer);
                    }
                    return outer;
                }

                @Override
                protected WrappedSignedProperty toOuter(Property inner) {
                    return WrappedSignedProperty.fromHandle(inner);
                }
            };
        }
        return result;
    }

    private GameProfile getProfile() {
        return (GameProfile)this.handle;
    }

    public WrappedGameProfile withName(String name) {
        return new WrappedGameProfile(this.getId(), name);
    }

    public WrappedGameProfile withId(String id) {
        return new WrappedGameProfile(id, this.getName());
    }

    public boolean isComplete() {
        return this.getProfile().isComplete();
    }

    public String toString() {
        return String.valueOf(this.getProfile());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getId(), this.getName()});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof WrappedGameProfile) {
            WrappedGameProfile other = (WrappedGameProfile)obj;
            return Objects.equal((Object)this.getProfile(), (Object)other.getProfile());
        }
        return false;
    }
}

