/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers.nbt;

import com.comphenix.protocol.wrappers.collection.ConvertedMap;
import com.comphenix.protocol.wrappers.nbt.MemoryElement;
import com.comphenix.protocol.wrappers.nbt.NbtBase;
import com.comphenix.protocol.wrappers.nbt.NbtCompound;
import com.comphenix.protocol.wrappers.nbt.NbtFactory;
import com.comphenix.protocol.wrappers.nbt.NbtList;
import com.comphenix.protocol.wrappers.nbt.NbtType;
import com.comphenix.protocol.wrappers.nbt.NbtVisitor;
import com.comphenix.protocol.wrappers.nbt.NbtWrapper;
import com.comphenix.protocol.wrappers.nbt.WrappedElement;
import com.comphenix.protocol.wrappers.nbt.WrappedList;
import com.comphenix.protocol.wrappers.nbt.io.NbtBinarySerializer;
import java.io.DataOutput;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class WrappedCompound
implements NbtWrapper<Map<String, NbtBase<?>>>,
Iterable<NbtBase<?>>,
NbtCompound {
    private WrappedElement<Map<String, Object>> container;
    private ConvertedMap<String, Object, NbtBase<?>> savedMap;

    public static WrappedCompound fromName(String name) {
        return (WrappedCompound)NbtFactory.ofWrapper(NbtType.TAG_COMPOUND, name);
    }

    public static NbtCompound fromList(String name, Collection<? extends NbtBase<?>> list) {
        WrappedCompound copy = WrappedCompound.fromName(name);
        for (NbtBase<?> base : list) {
            copy.getValue().put(base.getName(), base);
        }
        return copy;
    }

    public WrappedCompound(Object handle) {
        this.container = new WrappedElement(handle);
    }

    public WrappedCompound(Object handle, String name) {
        this.container = new WrappedElement(handle, name);
    }

    @Override
    public boolean accept(NbtVisitor visitor) {
        block1: {
            if (!visitor.visitEnter(this)) break block1;
            for (NbtBase<?> node : this) {
                if (!node.accept(visitor)) break;
            }
        }
        return visitor.visitLeave(this);
    }

    @Override
    public Object getHandle() {
        return this.container.getHandle();
    }

    @Override
    public NbtType getType() {
        return NbtType.TAG_COMPOUND;
    }

    @Override
    public String getName() {
        return this.container.getName();
    }

    @Override
    public void setName(String name) {
        this.container.setName(name);
    }

    @Override
    public boolean containsKey(String key) {
        return this.getValue().containsKey(key);
    }

    @Override
    public Set<String> getKeys() {
        return this.getValue().keySet();
    }

    @Override
    public Map<String, NbtBase<?>> getValue() {
        if (this.savedMap == null) {
            this.savedMap = new ConvertedMap<String, Object, NbtBase<?>>(this.container.getValue()){

                @Override
                protected Object toInner(NbtBase<?> outer) {
                    if (outer == null) {
                        return null;
                    }
                    return NbtFactory.fromBase(outer).getHandle();
                }

                @Override
                protected NbtBase<?> toOuter(Object inner) {
                    if (inner == null) {
                        return null;
                    }
                    return NbtFactory.fromNMS(inner);
                }

                @Override
                protected NbtBase<?> toOuter(String key, Object inner) {
                    if (inner == null) {
                        return null;
                    }
                    return NbtFactory.fromNMS(inner, key);
                }

                @Override
                public String toString() {
                    return WrappedCompound.this.toString();
                }
            };
        }
        return this.savedMap;
    }

    @Override
    public void setValue(Map<String, NbtBase<?>> newValue) {
        for (Map.Entry<String, NbtBase<?>> entry : newValue.entrySet()) {
            NbtBase<?> value = entry.getValue();
            if (value instanceof NbtBase) {
                this.put(entry.getValue());
                continue;
            }
            this.putObject(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public <T> NbtBase<T> getValue(String key) {
        return (NbtBase)this.getValue().get(key);
    }

    @Override
    public NbtBase<?> getValueOrDefault(String key, NbtType type) {
        NbtBase nbt = this.getValue(key);
        if (nbt == null) {
            nbt = NbtFactory.ofWrapper(type, key);
            this.put(nbt);
        } else if (nbt.getType() != type) {
            throw new IllegalArgumentException("Cannot get tag " + nbt + ": Not a " + (Object)((Object)type));
        }
        return nbt;
    }

    private <T> NbtBase<T> getValueExact(String key) {
        NbtBase<T> value = this.getValue(key);
        if (value != null) {
            return value;
        }
        throw new IllegalArgumentException("Cannot find key " + key);
    }

    @Override
    public NbtBase<Map<String, NbtBase<?>>> deepClone() {
        return this.container.deepClone();
    }

    @Override
    public <T> NbtCompound put(NbtBase<T> entry) {
        if (entry == null) {
            throw new IllegalArgumentException("Entry cannot be NULL.");
        }
        this.getValue().put(entry.getName(), entry);
        return this;
    }

    @Override
    public String getString(String key) {
        return (String)this.getValueExact(key).getValue();
    }

    @Override
    public String getStringOrDefault(String key) {
        return (String)this.getValueOrDefault(key, NbtType.TAG_STRING).getValue();
    }

    @Override
    public NbtCompound put(String key, String value) {
        this.getValue().put(key, NbtFactory.of(key, value));
        return this;
    }

    @Override
    public NbtCompound putObject(String key, Object value) {
        if (value == null) {
            this.remove(key);
        } else if (value instanceof NbtBase) {
            this.put(key, (NbtBase)value);
        } else {
            MemoryElement<Object> base = new MemoryElement<Object>(key, value);
            this.put(base);
        }
        return this;
    }

    @Override
    public Object getObject(String key) {
        NbtBase base = this.getValue(key);
        if (base != null && base.getType() != NbtType.TAG_LIST && base.getType() != NbtType.TAG_COMPOUND) {
            return base.getValue();
        }
        return base;
    }

    @Override
    public byte getByte(String key) {
        return (Byte)this.getValueExact(key).getValue();
    }

    @Override
    public byte getByteOrDefault(String key) {
        return (Byte)this.getValueOrDefault(key, NbtType.TAG_BYTE).getValue();
    }

    @Override
    public NbtCompound put(String key, byte value) {
        this.getValue().put(key, NbtFactory.of(key, value));
        return this;
    }

    @Override
    public Short getShort(String key) {
        return (Short)this.getValueExact(key).getValue();
    }

    @Override
    public short getShortOrDefault(String key) {
        return (Short)this.getValueOrDefault(key, NbtType.TAG_SHORT).getValue();
    }

    @Override
    public NbtCompound put(String key, short value) {
        this.getValue().put(key, NbtFactory.of(key, value));
        return this;
    }

    @Override
    public int getInteger(String key) {
        return (Integer)this.getValueExact(key).getValue();
    }

    @Override
    public int getIntegerOrDefault(String key) {
        return (Integer)this.getValueOrDefault(key, NbtType.TAG_INT).getValue();
    }

    @Override
    public NbtCompound put(String key, int value) {
        this.getValue().put(key, NbtFactory.of(key, value));
        return this;
    }

    @Override
    public long getLong(String key) {
        return (Long)this.getValueExact(key).getValue();
    }

    @Override
    public long getLongOrDefault(String key) {
        return (Long)this.getValueOrDefault(key, NbtType.TAG_LONG).getValue();
    }

    @Override
    public NbtCompound put(String key, long value) {
        this.getValue().put(key, NbtFactory.of(key, value));
        return this;
    }

    @Override
    public float getFloat(String key) {
        return ((Float)this.getValueExact(key).getValue()).floatValue();
    }

    @Override
    public float getFloatOrDefault(String key) {
        return ((Float)this.getValueOrDefault(key, NbtType.TAG_FLOAT).getValue()).floatValue();
    }

    @Override
    public NbtCompound put(String key, float value) {
        this.getValue().put(key, NbtFactory.of(key, value));
        return this;
    }

    @Override
    public double getDouble(String key) {
        return (Double)this.getValueExact(key).getValue();
    }

    @Override
    public double getDoubleOrDefault(String key) {
        return (Double)this.getValueOrDefault(key, NbtType.TAG_DOUBLE).getValue();
    }

    @Override
    public NbtCompound put(String key, double value) {
        this.getValue().put(key, NbtFactory.of(key, value));
        return this;
    }

    @Override
    public byte[] getByteArray(String key) {
        return (byte[])this.getValueExact(key).getValue();
    }

    @Override
    public NbtCompound put(String key, byte[] value) {
        this.getValue().put(key, NbtFactory.of(key, value));
        return this;
    }

    @Override
    public int[] getIntegerArray(String key) {
        return (int[])this.getValueExact(key).getValue();
    }

    @Override
    public NbtCompound put(String key, int[] value) {
        this.getValue().put(key, NbtFactory.of(key, value));
        return this;
    }

    @Override
    public NbtCompound getCompound(String key) {
        return (NbtCompound)this.getValueExact(key);
    }

    @Override
    public NbtCompound getCompoundOrDefault(String key) {
        return (NbtCompound)this.getValueOrDefault(key, NbtType.TAG_COMPOUND);
    }

    @Override
    public NbtCompound put(NbtCompound compound) {
        this.getValue().put(compound.getName(), compound);
        return this;
    }

    @Override
    public <T> NbtList<T> getList(String key) {
        return (NbtList)this.getValueExact(key);
    }

    @Override
    public <T> NbtList<T> getListOrDefault(String key) {
        return (NbtList)this.getValueOrDefault(key, NbtType.TAG_LIST);
    }

    @Override
    public <T> NbtCompound put(NbtList<T> list) {
        this.getValue().put(list.getName(), list);
        return this;
    }

    @Override
    public NbtCompound put(String key, NbtBase<?> entry) {
        if (entry == null) {
            throw new IllegalArgumentException("Entry cannot be NULL.");
        }
        NbtBase<?> clone = entry.deepClone();
        clone.setName(key);
        return this.put(clone);
    }

    @Override
    public <T> NbtCompound put(String key, Collection<? extends NbtBase<T>> list) {
        return this.put(WrappedList.fromList(key, list));
    }

    @Override
    public <T> NbtBase<?> remove(String key) {
        return (NbtBase)this.getValue().remove(key);
    }

    @Override
    public void write(DataOutput destination) {
        NbtBinarySerializer.DEFAULT.serialize(this.container, destination);
    }

    public boolean equals(Object obj) {
        if (obj instanceof WrappedCompound) {
            WrappedCompound other = (WrappedCompound)obj;
            return this.container.equals(other.container);
        }
        return false;
    }

    public int hashCode() {
        return this.container.hashCode();
    }

    @Override
    public Iterator<NbtBase<?>> iterator() {
        return this.getValue().values().iterator();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append("\"name\": \"" + this.getName() + "\"");
        for (NbtBase<?> element : this) {
            builder.append(", ");
            if (element.getType() == NbtType.TAG_STRING) {
                builder.append("\"" + element.getName() + "\": \"" + element.getValue() + "\"");
                continue;
            }
            builder.append("\"" + element.getName() + "\": " + element.getValue());
        }
        builder.append("}");
        return builder.toString();
    }
}

