package loginseqfix;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;
import java.util.WeakHashMap;

import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.ConnectionSide;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.injector.GamePhase;

public class LoginSeqFix extends JavaPlugin {

	private static final int CUSTOM_PAYLOAD_PACKET_ID = 250;

	private final Map<Player, Boolean> sentFMLModRequest = Collections.synchronizedMap(new WeakHashMap<Player, Boolean>());

	@SuppressWarnings("deprecation")
	@Override
	public void onEnable() {
		ProtocolLibrary.getProtocolManager().addPacketListener(
			new PacketAdapter(this, ConnectionSide.CLIENT_SIDE, GamePhase.LOGIN, CUSTOM_PAYLOAD_PACKET_ID) {
				@Override
				public void onPacketReceiving(PacketEvent event) {
					if (!isFmlPacket(event.getPacket())) {
						return;
					}
					byte[] data = event.getPacket().getByteArrays().read(0);
					if (data.length > 0) {
						if (data[0] != 1) {
							event.setCancelled(true);
							return;
						}
						if (!sentFMLModRequest.containsKey(event.getPlayer())) {
							event.setCancelled(true);
							return;
						}
					}
				}
			}
		);

		ProtocolLibrary.getProtocolManager().addPacketListener(
			new PacketAdapter(this, ConnectionSide.SERVER_SIDE, GamePhase.LOGIN, CUSTOM_PAYLOAD_PACKET_ID) {
				@Override
				public void onPacketSending(PacketEvent event) {
					if (!isFmlPacket(event.getPacket())) {
						return;
					}
					byte[] data = event.getPacket().getByteArrays().read(0);
					if (data.length > 0 && data[0] == 0) {
						sentFMLModRequest.put(event.getPlayer(), Boolean.TRUE);
					}
				}
			}
		);

		Bukkit.getScheduler().scheduleAsyncRepeatingTask(this, new Runnable() {
			@Override
			public void run() {
				Iterator<Entry<Player, Boolean>> iterator = sentFMLModRequest.entrySet().iterator();
				while (iterator.hasNext()) {
					Player player = iterator.next().getKey();
					if (!player.isOnline()) {
						iterator.remove();
					}
				}
			}
		}, 100, 100);
	}

	static boolean isFmlPacket(PacketContainer container) {
		return container.getStrings().read(0).equals("FML");
	}

}
