/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.vec;

import codechicken.core.vec.Matrix4;
import codechicken.core.vec.Transformation;
import codechicken.core.vec.Vector3;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;

public class TransformationList
extends Transformation {
    private ArrayList transformations = new ArrayList();
    private Matrix4 mat;

    public TransformationList(Transformation ... transforms) {
        Transformation[] transformationArray = transforms;
        int n = transforms.length;
        int n2 = 0;
        while (n2 < n) {
            Transformation t = transformationArray[n2];
            this.with(t);
            ++n2;
        }
    }

    public Matrix4 compile() {
        if (this.mat == null) {
            this.mat = new Matrix4();
            int i = this.transformations.size() - 1;
            while (i >= 0) {
                ((Transformation)this.transformations.get(i)).apply(this.mat);
                --i;
            }
        }
        return this.mat;
    }

    public Matrix4 reverseCompile() {
        Matrix4 mat = new Matrix4();
        for (Transformation t : this.transformations) {
            t.apply(mat);
        }
        return mat;
    }

    @Override
    public void apply(Vector3 vec) {
        if (this.mat != null) {
            this.mat.apply(vec);
        } else {
            for (Transformation t : this.transformations) {
                t.apply(vec);
            }
        }
    }

    @Override
    public void applyN(Vector3 normal) {
        if (this.mat != null) {
            this.mat.applyN(normal);
        } else {
            for (Transformation t : this.transformations) {
                t.applyN(normal);
            }
        }
    }

    @Override
    public void apply(Matrix4 mat) {
        mat.multiply(this.compile());
    }

    @Override
    public TransformationList with(Transformation t) {
        this.mat = null;
        this.transformations.add(t);
        return this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void glApply() {
        int i = this.transformations.size() - 1;
        while (i >= 0) {
            ((Transformation)this.transformations.get(i)).glApply();
            --i;
        }
    }

    @Override
    public Transformation inverse() {
        TransformationList rev = new TransformationList(new Transformation[0]);
        int i = this.transformations.size() - 1;
        while (i >= 0) {
            rev.with(((Transformation)this.transformations.get(i)).inverse());
            --i;
        }
        return rev;
    }

    public String toString() {
        String s = "";
        for (Transformation t : this.transformations) {
            s = String.valueOf(s) + "\n" + t.toString();
        }
        return s.trim();
    }
}

