/*
 * Decompiled with CFR 0.152.
 */
package invtweaks;

import invtweaks.InvTweaks;
import invtweaks.InvTweaksConfig;
import invtweaks.InvTweaksConst;
import invtweaks.InvTweaksGuiModNotWorking;
import invtweaks.InvTweaksGuiSettingsAbstract;
import invtweaks.InvTweaksGuiSettingsAdvanced;
import invtweaks.InvTweaksGuiShortcutsHelp;
import invtweaks.InvTweaksGuiTooltipButton;
import invtweaks.InvTweaksLocalization;
import java.awt.Desktop;
import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.logging.Logger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import org.lwjgl.input.Keyboard;
import org.lwjgl.util.Point;

public class InvTweaksGuiSettings
extends InvTweaksGuiSettingsAbstract {
    private static final Logger log = InvTweaks.log;
    private static final int ID_MIDDLE_CLICK = 1;
    private static final int ID_BEFORE_BREAK = 2;
    private static final int ID_SHORTCUTS = 3;
    private static final int ID_SHORTCUTS_HELP = 4;
    private static final int ID_AUTO_REFILL = 5;
    private static final int ID_MORE_OPTIONS = 6;
    private static final int ID_SORTING_KEY = 7;
    private static final int ID_BUG_SORTING = 8;
    private static final int ID_EDITRULES = 100;
    private static final int ID_EDITTREE = 101;
    private static final int ID_HELP = 102;
    private static String labelMiddleClick;
    private static String labelShortcuts;
    private static String labelAutoRefill;
    private static String labelAutoRefillBeforeBreak;
    private static String labelMoreOptions;
    private static String labelBugSorting;
    private InvTweaksGuiTooltipButton sortMappingButton;
    private boolean sortMappingEdition = false;

    public InvTweaksGuiSettings(Minecraft minecraft, GuiScreen guiScreen, InvTweaksConfig invTweaksConfig) {
        super(minecraft, guiScreen, invTweaksConfig);
        labelMiddleClick = InvTweaksLocalization.get("invtweaks.settings.middleclick");
        labelShortcuts = InvTweaksLocalization.get("invtweaks.settings.shortcuts");
        labelAutoRefill = InvTweaksLocalization.get("invtweaks.settings.autorefill");
        labelAutoRefillBeforeBreak = InvTweaksLocalization.get("invtweaks.settings.beforebreak");
        labelMoreOptions = InvTweaksLocalization.get("invtweaks.settings.moreoptions");
        labelBugSorting = InvTweaksLocalization.get("invtweaks.help.bugsorting");
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        List<Object> list = this.obf.getControlList(this);
        Point point = new Point();
        int n = 0;
        this.moveToButtonCoords(1, point);
        list.add(new GuiButton(100, point.getX() + 55, this.obf.getWindowHeight(this) / 6 + 96, InvTweaksLocalization.get("invtweaks.settings.rulesfile")));
        list.add(new GuiButton(101, point.getX() + 55, this.obf.getWindowHeight(this) / 6 + 120, InvTweaksLocalization.get("invtweaks.settings.treefile")));
        list.add(new GuiButton(102, point.getX() + 55, this.obf.getWindowHeight(this) / 6 + 144, InvTweaksLocalization.get("invtweaks.settings.onlinehelp")));
        this.moveToButtonCoords(n++, point);
        list.add((Object)new InvTweaksGuiTooltipButton(4, point.getX() + 130, point.getY(), 20, 20, "?", "Shortcuts help"));
        String string = this.config.getProperty("enableShortcuts");
        InvTweaksGuiTooltipButton invTweaksGuiTooltipButton = new InvTweaksGuiTooltipButton(3, point.getX(), point.getY(), 130, 20, this.computeBooleanButtonLabel("enableShortcuts", labelShortcuts), InvTweaksLocalization.get("invtweaks.settings.shortcuts.tooltip"));
        list.add((Object)invTweaksGuiTooltipButton);
        if (string.equals("convenientInventoryCompatibility")) {
            this.obf.setEnabled(invTweaksGuiTooltipButton, false);
            invTweaksGuiTooltipButton.setTooltip(invTweaksGuiTooltipButton.getTooltip() + "\n(" + InvTweaksLocalization.get("invtweaks.settings.disableci.tooltip") + ")");
        }
        this.moveToButtonCoords(n++, point);
        this.sortMappingButton = new InvTweaksGuiTooltipButton(7, point.getX(), point.getY(), InvTweaksLocalization.get("invtweaks.settings.key") + " " + this.config.getProperty("keySortInventory"));
        list.add((Object)this.sortMappingButton);
        this.moveToButtonCoords(n++, point);
        InvTweaksGuiTooltipButton invTweaksGuiTooltipButton2 = new InvTweaksGuiTooltipButton(2, point.getX(), point.getY(), this.computeBooleanButtonLabel("autoRefillBeforeBreak", labelAutoRefillBeforeBreak), InvTweaksLocalization.get("invtweaks.settings.beforebreak.tooltip"));
        list.add((Object)invTweaksGuiTooltipButton2);
        this.moveToButtonCoords(n++, point);
        InvTweaksGuiTooltipButton invTweaksGuiTooltipButton3 = new InvTweaksGuiTooltipButton(5, point.getX(), point.getY(), this.computeBooleanButtonLabel("enableAutoRefill", labelAutoRefill), InvTweaksLocalization.get("invtweaks.settings.autorefill.tooltip"));
        list.add((Object)invTweaksGuiTooltipButton3);
        this.moveToButtonCoords(n++, point);
        list.add((Object)new InvTweaksGuiTooltipButton(6, point.getX(), point.getY(), labelMoreOptions, InvTweaksLocalization.get("invtweaks.settings.moreoptions.tooltip")));
        list.add((Object)new InvTweaksGuiTooltipButton(8, 5, this.field_73881_g - 20, 100, 20, labelBugSorting, null, false));
        String string2 = this.config.getProperty("enableMiddleClick");
        this.moveToButtonCoords(n++, point);
        InvTweaksGuiTooltipButton invTweaksGuiTooltipButton4 = new InvTweaksGuiTooltipButton(1, point.getX(), point.getY(), this.computeBooleanButtonLabel("enableMiddleClick", labelMiddleClick), InvTweaksLocalization.get("invtweaks.settings.middleclick.tooltip"));
        list.add((Object)invTweaksGuiTooltipButton4);
        if (string2.equals("convenientInventoryCompatibility")) {
            this.obf.setEnabled(invTweaksGuiTooltipButton4, false);
            invTweaksGuiTooltipButton4.setTooltip(invTweaksGuiTooltipButton4.getTooltip() + "\n(" + InvTweaksLocalization.get("invtweaks.settings.disableci.tooltip"));
        }
        if (!Desktop.isDesktopSupported()) {
            for (Object object : list) {
                GuiButton guiButton;
                if (!this.obf.isGuiButton(object) || this.obf.getId(guiButton = this.obf.asGuiButton(object)) < 100 || this.obf.getId(guiButton) > 102) continue;
                this.obf.setEnabled(guiButton, false);
            }
        }
        this.obf.setControlList(this, list);
    }

    @Override
    protected void func_73875_a(GuiButton guiButton) {
        super.func_73875_a(guiButton);
        switch (this.obf.getId(guiButton)) {
            case 7: {
                this.sortMappingButton.field_73744_e = InvTweaksLocalization.get("invtweaks.settings.key") + " > ??? <";
                this.sortMappingEdition = true;
                break;
            }
            case 1: {
                this.toggleBooleanButton(guiButton, "enableMiddleClick", labelMiddleClick);
                break;
            }
            case 5: {
                this.toggleBooleanButton(guiButton, "enableAutoRefill", labelAutoRefill);
                break;
            }
            case 2: {
                this.toggleBooleanButton(guiButton, "autoRefillBeforeBreak", labelAutoRefillBeforeBreak);
                break;
            }
            case 3: {
                this.toggleBooleanButton(guiButton, "enableShortcuts", labelShortcuts);
                break;
            }
            case 4: {
                this.obf.displayGuiScreen(new InvTweaksGuiShortcutsHelp(this.field_73882_e, this, this.config));
                break;
            }
            case 6: {
                this.obf.displayGuiScreen(new InvTweaksGuiSettingsAdvanced(this.field_73882_e, this.parentScreen, this.config));
                break;
            }
            case 8: {
                this.obf.displayGuiScreen(new InvTweaksGuiModNotWorking(this.field_73882_e, this.parentScreen, this.config));
                break;
            }
            case 100: {
                try {
                    Desktop.getDesktop().open(new File(InvTweaksConst.CONFIG_RULES_FILE));
                }
                catch (Exception exception) {
                    InvTweaks.logInGameErrorStatic("invtweaks.settings.rulesfile.error", exception);
                }
                break;
            }
            case 101: {
                try {
                    Desktop.getDesktop().open(new File(InvTweaksConst.CONFIG_TREE_FILE));
                }
                catch (Exception exception) {
                    InvTweaks.logInGameErrorStatic("invtweaks.settings.treefile.error", exception);
                }
                break;
            }
            case 102: {
                try {
                    Desktop.getDesktop().browse(new URL("http://modding.kalam-alami.net/invtweaks").toURI());
                    break;
                }
                catch (Exception exception) {
                    InvTweaks.logInGameErrorStatic("invtweaks.settings.onlinehelp.error", exception);
                }
            }
        }
    }

    @Override
    protected void func_73869_a(char c, int n) {
        if (this.sortMappingEdition) {
            String string = Keyboard.getKeyName((int)n);
            this.config.setProperty("keySortInventory", string);
            this.sortMappingButton.field_73744_e = InvTweaksLocalization.get("invtweaks.settings.key") + " " + string;
        }
        super.func_73869_a(c, n);
    }
}

