/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.mojang;

import com.craftingdead.mojang.RunnableUUIDFetcher;
import com.google.gson.Gson;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class MojangAPI {
    public static final String UUID_URL = "https://api.mojang.com/profiles/minecraft";
    public static final String PROFILE_URL = "https://sessionserver.mojang.com/session/minecraft/profile/";
    public static final JsonParser JSON_PARSER = new JsonParser();
    public static final Gson GSON = new Gson();
    private static ExecutorService executorService = Executors.newCachedThreadPool();
    private static Map<String, UUID> uuidCache = new HashMap<String, UUID>();
    private static ArrayList<String> pendingUsernames = new ArrayList();
    private static int tickThreadSpawning = 0;

    public static void downloadPendingUUIDs() {
        if (pendingUsernames.size() > 0 && ++tickThreadSpawning >= 20) {
            executorService.execute(new RunnableUUIDFetcher(pendingUsernames, uuidCache));
            pendingUsernames.clear();
            tickThreadSpawning = 0;
        }
        if (tickThreadSpawning >= 100) {
            tickThreadSpawning = 0;
        }
    }

    public static UUID getUUID(String string, boolean bl) {
        if (uuidCache.containsKey(string)) {
            return uuidCache.get(string);
        }
        if (bl) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            new RunnableUUIDFetcher(arrayList, uuidCache).run();
            return uuidCache.get(string);
        }
        if (!pendingUsernames.contains(string)) {
            pendingUsernames.add(string);
        }
        return null;
    }

    public static InputStream postJson(URL uRL, byte[] byArray) throws IOException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setRequestProperty("Content-Type", "application/json");
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setDoOutput(true);
        try (OutputStream outputStream = httpURLConnection.getOutputStream();){
            outputStream.write(byArray);
            outputStream.flush();
        }
        return httpURLConnection.getInputStream();
    }

    public static String fixImageUrl(String string) {
        UUID uUID;
        String string2;
        String[] stringArray;
        String[] stringArray2;
        String string3 = string;
        if (string.startsWith("http://skins.minecraft.net/MinecraftSkins/")) {
            try {
                stringArray2 = string.split("/");
                stringArray = stringArray2[stringArray2.length - 1].split("\\.");
                string2 = stringArray[0];
                uUID = MojangAPI.getUUID(string2, true);
                if (uUID == null) {
                    return string3;
                }
                string3 = PlayerResource.SKIN_URL.getUrl(uUID);
                string3 = string3.isEmpty() ? string : string3;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                string3 = string;
            }
        }
        if (string.startsWith("http://skins.minecraft.net/MinecraftCloaks/")) {
            try {
                stringArray2 = string.split("/");
                stringArray = stringArray2[stringArray2.length - 1].split("\\.");
                string2 = stringArray[0];
                uUID = MojangAPI.getUUID(string2, false);
                if (uUID == null) {
                    return string3;
                }
                string3 = PlayerResource.CAPE_URL.getUrl(uUID);
                string3 = string3.isEmpty() ? string : string3;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                string3 = string;
            }
        }
        return string3;
    }

    public static UUID parseUUID(String string) {
        return UUID.fromString(string.substring(0, 8) + "-" + string.substring(8, 12) + "-" + string.substring(12, 16) + "-" + string.substring(16, 20) + "-" + string.substring(20, 32));
    }

    public static enum PlayerResource {
        SKIN_URL("https://crafatar.com/skins/%s.png"),
        CAPE_URL("https://crafatar.com/capes/%s.png"),
        AVATAR_URL("https://crafatar.com/avatars/%s.png");

        private String url;

        private PlayerResource(String string2) {
            this.url = string2;
        }

        public String getUrl(UUID uUID) {
            return String.format(this.url, uUID);
        }
    }
}

