/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.mojang;

import com.craftingdead.mojang.MojangAPI;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class RunnableUUIDFetcher
implements Runnable {
    private List<String> pendingUsernames;
    private Map<String, UUID> uuidCache;

    public RunnableUUIDFetcher(List<String> list, Map<String, UUID> map) {
        this.pendingUsernames = new ArrayList<String>(list);
        this.uuidCache = map;
    }

    @Override
    public void run() {
        try {
            String string = MojangAPI.GSON.toJson(this.pendingUsernames);
            JsonArray jsonArray = (JsonArray)MojangAPI.JSON_PARSER.parse((Reader)new InputStreamReader(MojangAPI.postJson(new URL("https://api.mojang.com/profiles/minecraft"), string.getBytes())));
            for (Object e2 : jsonArray) {
                try {
                    JsonObject jsonObject = (JsonObject)e2;
                    String string2 = jsonObject.get("id").getAsString();
                    String string3 = jsonObject.get("name").getAsString();
                    this.uuidCache.put(string3, MojangAPI.parseUUID(string2));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

