/*
 * Decompiled with CFR 0.152.
 */
package argo.saj;

import argo.saj.InvalidSyntaxException;
import argo.saj.JsonListener;
import argo.staj.InvalidSyntaxRuntimeException;
import argo.staj.JsonStreamElement;
import argo.staj.StajParser;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public final class SajParser {
    public void parse(String json, JsonListener jsonListener) throws IOException, InvalidSyntaxException {
        this.parse(jsonListener, new StajParser(new StringReader(json)));
    }

    public void parse(Reader in, JsonListener jsonListener) throws IOException, InvalidSyntaxException {
        this.parse(jsonListener, new StajParser(in));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void parse(JsonListener jsonListener, StajParser stajParser) throws InvalidSyntaxException {
        try {
            JsonStreamElement jsonStreamElement;
            block17: while (stajParser.hasNext()) {
                jsonStreamElement = stajParser.next();
                switch (jsonStreamElement.jsonStreamElementType()) {
                    case START_DOCUMENT: {
                        jsonListener.startDocument();
                        continue block17;
                    }
                    case END_DOCUMENT: {
                        jsonListener.endDocument();
                        continue block17;
                    }
                    case START_ARRAY: {
                        jsonListener.startArray();
                        continue block17;
                    }
                    case END_ARRAY: {
                        jsonListener.endArray();
                        continue block17;
                    }
                    case START_OBJECT: {
                        jsonListener.startObject();
                        continue block17;
                    }
                    case END_OBJECT: {
                        jsonListener.endObject();
                        continue block17;
                    }
                    case START_FIELD: {
                        jsonListener.startField(jsonStreamElement.text());
                        continue block17;
                    }
                    case END_FIELD: {
                        jsonListener.endField();
                        continue block17;
                    }
                    case NULL: {
                        jsonListener.nullValue();
                        continue block17;
                    }
                    case TRUE: {
                        jsonListener.trueValue();
                        continue block17;
                    }
                    case FALSE: {
                        jsonListener.falseValue();
                        continue block17;
                    }
                    case STRING: {
                        jsonListener.stringValue(jsonStreamElement.text());
                        continue block17;
                    }
                    case NUMBER: {
                        jsonListener.numberValue(jsonStreamElement.text());
                        continue block17;
                    }
                }
            }
            return;
            throw new IllegalStateException("Got a JsonStreamElement of unexpected type: " + jsonStreamElement);
        }
        catch (InvalidSyntaxRuntimeException e) {
            throw e.asInvalidSyntaxException();
        }
    }
}

