/*
 * Decompiled with CFR 0.152.
 */
package com.f3rullo14.cdc.common;

import com.f3rullo14.cdc.CDCure;
import com.f3rullo14.cdc.common.BlockLocation;
import com.f3rullo14.cdc.common.CommonTickHandler;
import com.f3rullo14.cdc.common.CommonUtils;
import com.f3rullo14.cdc.common.entity.EntitySupplyDrop;
import com.f3rullo14.fds.FCFile;
import com.f3rullo14.fds.FDSCompound;
import com.f3rullo14.fds.IFDSManager;
import java.util.ArrayList;
import java.util.Random;

public class SupplyDropManager
implements IFDSManager {
    public ArrayList supplyDropSpawns = new ArrayList();
    public int timeBetweenDrops = 1;
    private int dropTick = 0;
    private int dropTickInit = 0;
    public BlockLocation currentDropLocation = null;
    public int timeTillDrop = 1;
    private FCFile config = new FCFile("Supply Drop Config", CDCure.folderLocation + "/configs/supplydrops.properties");
    public boolean allowSupplyDrops = this.config.getBoolean("enabled", false, "Allow supply drops? You must set spawn points");

    public SupplyDropManager() {
        this.timeBetweenDrops = this.config.getInteger("time.between.drops", 20, "Time in minutes when supply drops spawn");
        this.timeTillDrop = this.config.getInteger("time.between.init", 1, "The time in minutes till a drop actually spawns once picked");
    }

    public BlockLocation getRandomLocation() {
        Random rand = new Random();
        return this.supplyDropSpawns.size() > 0 ? (BlockLocation)this.supplyDropSpawns.get(rand.nextInt(this.supplyDropSpawns.size())) : null;
    }

    public void onDropInit(aab world) {
        if (this.currentDropLocation == null) {
            this.currentDropLocation = this.getRandomLocation();
            if (this.currentDropLocation != null) {
                int x2 = this.currentDropLocation.px;
                int z2 = this.currentDropLocation.pz;
                CommonUtils.broadcastMessage((Object)((Object)a.e) + "[Crafting Dead]: " + (Object)((Object)a.g) + "Supply Drop at X:" + x2 + " Z:" + z2 + " in " + this.getTimeFromTick(this.timeTillDrop * 1200));
            }
        }
    }

    public void onSpawnSupplyDrop(aab world) {
        if (this.currentDropLocation != null) {
            int x2 = this.currentDropLocation.px;
            int z2 = this.currentDropLocation.pz;
            CommonUtils.broadcastMessage((Object)((Object)a.e) + "[Crafting Dead]: " + (Object)((Object)a.g) + "Supply Drop incoming at X:" + x2 + " Z:" + z2);
            this.removeAllExistingDrops(world);
            this.spawnSupplyDrop(world, this.currentDropLocation);
        }
    }

    private void removeAllExistingDrops(aab world) {
        ArrayList list = (ArrayList)world.e;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (!(list.get(i2) instanceof EntitySupplyDrop)) continue;
            ((mp)list.get(i2)).w();
        }
    }

    public void onServerUpdate(aab world) {
        if (this.allowSupplyDrops && !world.I) {
            if (this.currentDropLocation == null) {
                ++this.dropTick;
                if (this.dropTick > (int)((float)this.timeBetweenDrops * 1200.0f)) {
                    this.onDropInit(world);
                    this.dropTick = 0;
                }
            } else {
                ++this.dropTickInit;
                if (this.dropTickInit > (int)((float)this.timeTillDrop * 1200.0f)) {
                    this.onSpawnSupplyDrop(world);
                    this.dropTickInit = 0;
                    this.currentDropLocation = null;
                }
                if (this.dropTickInit == this.timeTillDrop * 1200 / 2 && this.currentDropLocation != null) {
                    int x2 = this.currentDropLocation.px;
                    int z2 = this.currentDropLocation.pz;
                    CommonUtils.broadcastMessage((Object)((Object)a.e) + "[Crafting Dead]: " + (Object)((Object)a.g) + "Supply Drop at X:" + x2 + " Z:" + z2 + " in " + this.getTimeFromTick(this.timeTillDrop * 1200 / 2));
                }
            }
        }
    }

    @Override
    public void initLoading(FDSCompound fds) {
        int var1 = 0;
        ArrayList<BlockLocation> list = new ArrayList<BlockLocation>();
        if (fds.hasTag("sdSize")) {
            var1 = fds.getInteger("sdSize");
        }
        if (var1 > 0) {
            for (int i2 = 0; i2 < var1; ++i2) {
                int posx = fds.getInteger("sdPosX" + i2);
                int posy = fds.getInteger("sdPosY" + i2);
                int posz = fds.getInteger("sdPosZ" + i2);
                BlockLocation rspawn = new BlockLocation(posx, posy, posz);
                list.add(rspawn);
            }
        }
        this.supplyDropSpawns = list;
    }

    @Override
    public void initSaving(FDSCompound fds) {
        if (this.supplyDropSpawns.size() > 0) {
            fds.setInteger("sdSize", this.supplyDropSpawns.size());
            int var1 = this.supplyDropSpawns.size();
            for (int i2 = 0; i2 < var1; ++i2) {
                BlockLocation rspawn = (BlockLocation)this.supplyDropSpawns.get(i2);
                fds.setInteger("sdPosX" + i2, rspawn.px);
                fds.setInteger("sdPosY" + i2, rspawn.py);
                fds.setInteger("sdPosZ" + i2, rspawn.pz);
            }
        }
    }

    public void addSupplyDropLocation(BlockLocation par1) {
        this.supplyDropSpawns.add(par1);
    }

    public void spawnSupplyDrop(aab world, BlockLocation par1) {
        if (!world.I) {
            EntitySupplyDrop entitySupplyDrop = new EntitySupplyDrop(world);
            entitySupplyDrop.addRandomContent();
            entitySupplyDrop.addRandomContent();
            entitySupplyDrop.b(par1.px, par1.py + 70, par1.pz);
            world.d(entitySupplyDrop);
            CommonTickHandler.getCommonTickHandler().getCraftingDeadEvents().onSupplyDropSpawned(entitySupplyDrop);
        }
    }

    public String getTimeFromTick(int var1) {
        int minutes = 0;
        int seconds = 0;
        while (var1 > 0) {
            if (var1 >= 1200) {
                var1 -= 1200;
                ++minutes;
                continue;
            }
            if (var1 >= 20) {
                var1 -= 20;
                ++seconds;
                continue;
            }
            var1 = 0;
        }
        return minutes + "m " + seconds + "s";
    }
}

