/*
 * Decompiled with CFR 0.152.
 */
package com.f3rullo14.fds;

import com.f3rullo14.cdc.CDCure;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;

public class FDSCompound {
    private File fileSaved;
    private ArrayList ssd = new ArrayList();
    private String stringSplit = "&&";

    public FDSCompound(String par1Path) {
        this.fileSaved = new File(par1Path);
    }

    public FDSCompound(File par1File) {
        this.fileSaved = par1File;
    }

    public void initLoading() {
        File f1 = new File(this.fileSaved.getAbsolutePath());
        if (f1.exists()) {
            if (FMLCommonHandler.instance().getSide() == Side.SERVER) {
                CDCure.logServer("FDSCompound: Loading...");
            }
            this.ssd.clear();
            this.ssd = this.readFileToArray(f1);
        } else {
            CDCure.log("FDSCompound: No file to load! Save Data first!");
        }
    }

    public void preInitSaving() {
        this.ssd.clear();
    }

    public void initSaving() {
        String path = this.fileSaved.getAbsolutePath();
        File f1 = new File(path);
        File f2 = new File(this.fileSaved.getParentFile().getPath());
        try {
            File f3;
            if (!f2.exists()) {
                f2.mkdirs();
            }
            if (f1.exists()) {
                f1.delete();
            }
            if (!(f3 = new File(path)).exists()) {
                f3.createNewFile();
            }
            FileWriter fstream = new FileWriter(path, true);
            BufferedWriter out = new BufferedWriter(fstream);
            if (this.ssd.size() > 0) {
                for (int i2 = 0; i2 < this.ssd.size(); ++i2) {
                    out.write((String)this.ssd.get(i2));
                    if (i2 == this.ssd.size() - 1) continue;
                    out.newLine();
                }
            }
            out.close();
        }
        catch (MalformedURLException e2) {
            e2.printStackTrace();
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
    }

    public boolean hasTag(String par1) {
        if (this.ssd.size() > 0) {
            for (int i2 = 0; i2 < this.ssd.size(); ++i2) {
                String var1 = (String)this.ssd.get(i2);
                String[] split = var1.split("&&");
                if (!split[0].equals(par1)) continue;
                return true;
            }
        }
        return false;
    }

    public int getInteger(String par1) {
        if (this.ssd.size() > 0) {
            for (int i2 = 0; i2 < this.ssd.size(); ++i2) {
                String var1 = (String)this.ssd.get(i2);
                String[] split = var1.split("&&");
                if (split.length != 2 || !par1.equals(split[0])) continue;
                return Integer.parseInt(split[1]);
            }
        }
        return 0;
    }

    public void setInteger(String par1, int par2) {
        this.addToArray(par1, "" + par2);
    }

    public boolean getBoolean(String par1) {
        if (this.ssd.size() > 0) {
            for (int i2 = 0; i2 < this.ssd.size(); ++i2) {
                String var1 = (String)this.ssd.get(i2);
                String[] split = var1.split(this.stringSplit);
                if (split.length != 2 || !par1.equals(split[0])) continue;
                return split[1].equals("true");
            }
        }
        return false;
    }

    public void setBoolean(String par1, boolean par2) {
        this.addToArray(par1, "" + par2);
    }

    public String getString(String par1) {
        if (this.ssd.size() > 0) {
            for (int i2 = 0; i2 < this.ssd.size(); ++i2) {
                String var1 = (String)this.ssd.get(i2);
                String[] split = var1.split(this.stringSplit);
                if (split.length != 2 || !par1.equals(split[0])) continue;
                return split[1];
            }
        }
        return "";
    }

    public void setString(String par1, String par2) {
        this.addToArray(par1, par2);
    }

    private void addToArray(String par1, String par2) {
        this.ssd.add(par1 + this.stringSplit + par2);
    }

    private ArrayList readFileToArray(File file) {
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String line;
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            StringBuffer stringBuffer = new StringBuffer();
            while ((line = bufferedReader.readLine()) != null) {
                stringBuffer.append(line);
                stringBuffer.append("\n");
                lines.add(line);
            }
            fileReader.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return lines;
    }
}

