/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.client;

import com.google.common.collect.Lists;
import com.google.common.collect.MapDifference;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.registry.ItemData;
import java.util.List;
import java.util.Map;

public class GuiIdMismatchScreen
extends awk {
    private List<String> missingIds = Lists.newArrayList();
    private List<String> mismatchedIds = Lists.newArrayList();
    private boolean allowContinue;

    public GuiIdMismatchScreen(MapDifference<Integer, ItemData> idDifferences, boolean allowContinue) {
        super(null, "ID mismatch", "Should I continue?", 1);
        this.a = this;
        for (Map.Entry entry : idDifferences.entriesOnlyOnLeft().entrySet()) {
            this.missingIds.add(String.format("ID %d from Mod %s is missing", ((ItemData)entry.getValue()).getItemId(), ((ItemData)entry.getValue()).getModId(), ((ItemData)entry.getValue()).getItemType()));
        }
        for (Map.Entry entry : idDifferences.entriesDiffering().entrySet()) {
            ItemData world = (ItemData)((MapDifference.ValueDifference)entry.getValue()).leftValue();
            ItemData game = (ItemData)((MapDifference.ValueDifference)entry.getValue()).rightValue();
            this.mismatchedIds.add(String.format("ID %d is mismatched between world and game", world.getItemId()));
        }
        this.allowContinue = allowContinue;
    }

    @Override
    public void a(boolean choice, int par2) {
        FMLClientHandler.instance().callbackIdDifferenceResponse(choice);
    }

    @Override
    public void a(int par1, int par2, float par3) {
        this.e();
        if (!this.allowContinue && this.k.size() == 2) {
            this.k.remove(0);
        }
        int offset = Math.max(85 - (this.missingIds.size() + this.mismatchedIds.size()) * 10, 30);
        this.a(this.m, "Forge Mod Loader has found ID mismatches", this.h / 2, 10, 0xFFFFFF);
        this.a(this.m, "Complete details are in the log file", this.h / 2, 20, 0xFFFFFF);
        int maxLines = 20;
        for (String s2 : this.missingIds) {
            this.a(this.m, s2, this.h / 2, offset, 0xEEEEEE);
            if (--maxLines >= 0 && (offset += 10) < this.i - 30) continue;
            break;
        }
        if (maxLines > 0 && offset < this.i - 30) {
            for (String s2 : this.mismatchedIds) {
                this.a(this.m, s2, this.h / 2, offset, 0xEEEEEE);
                if (--maxLines >= 0 && (offset += 10) < this.i - 30) continue;
                break;
            }
        }
        if (this.allowContinue) {
            this.a(this.m, "Do you wish to continue loading?", this.h / 2, this.i - 30, 0xFFFFFF);
        } else {
            this.a(this.m, "You cannot connect to this server", this.h / 2, this.i - 30, 0xFFFFFF);
        }
        for (int var4 = 0; var4 < this.k.size(); ++var4) {
            awg var5 = (awg)this.k.get(var4);
            var5.d = this.i - 20;
            if (!this.allowContinue) {
                var5.c = this.h / 2 - 75;
                var5.e = bp.a().a("gui.done");
            }
            var5.a(this.g, par1, par2);
        }
    }
}

