/*
 * Decompiled with CFR 0.152.
 */
package com.f3rullo14.cdc.common;

import com.f3rullo14.cdc.CDCure;
import com.f3rullo14.cdc.common.ServerInfo;
import com.f3rullo14.fds.FCFile;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;

public class ServerLoader {
    private String GLOBAL_URL = "https://www.dropbox.com/s/rkto9p7xkjkkadn/CD_GLOBALBAN.txt?dl=1";
    public static ServerInfo serverInfo;
    public static ArrayList bannedList;
    private FCFile serverConfig;

    public ServerLoader() {
        serverInfo = new ServerInfo();
        this.serverConfig = new FCFile("Server Config", CDCure.folderLocation + "/craftingdead_server.properties");
    }

    public void onInit(String loc) {
        this.loadPropetiesFromConfig();
        CDCure.logServer("Loaded Properties File!");
        this.downloadAndReadBans();
    }

    public void loadPropetiesFromConfig() {
        ServerInfo.PACKET_REFRESH = this.serverConfig.getInteger("packet.refresh.rate", 4, "How often client data is refreshed with server data");
        ServerInfo.LOCK_ARMOR = this.serverConfig.getBoolean("armor.lock", true, "Make armor impossible to take off and etc. Default true");
        ServerInfo.COMMON_LOOT_PERCENTAGE = this.serverConfig.getInteger("loot.common.chance", 50, "Loot percentage spawn rate: #/100");
        ServerInfo.RARE_LOOT_PERCENTAGE = this.serverConfig.getInteger("loot.rare.chance", 40);
        ServerInfo.VERYRARE_LOOT_PERCENTAGE = this.serverConfig.getInteger("loot.veryrare.chance", 20);
        ServerInfo.EXTREME_LOOT_PERCENTAGE = this.serverConfig.getInteger("loot.extreme.chance", 10);
        ServerInfo.MILITARY_LOOT_PERCENTAGE = this.serverConfig.getInteger("loot.military.chance", 5);
        ServerInfo.MEDICAL_LOOT_PERCENTAGE = this.serverConfig.getInteger("loot.medical.chance", 25);
        ServerInfo.CD_SERVERNAME = this.serverConfig.getString("server.name", "Crafting Dead Server", "Name of the server");
        ServerInfo.CD_MOTD = this.serverConfig.getString("server.motd", "Welcome all!", "MOTD of the server (CD Server Lists)");
    }

    public static ServerInfo getServerInfo() {
        return serverInfo;
    }

    public void downloadAndReadBans() {
        try {
            this.downloadFile(CDCure.folderLocation + "/banned-players.cdc", this.GLOBAL_URL);
            ArrayList list = this.readFileToArray(CDCure.folderLocation + "/banned-players.cdc");
            for (int i2 = 0; i2 < list.size(); ++i2) {
                String banUser = ((String)list.get(i2)).trim();
                bannedList.add(banUser);
            }
        }
        catch (MalformedURLException e2) {
            e2.printStackTrace();
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadFile(String filename, String urlString) throws MalformedURLException, IOException {
        File checkForOld = new File(filename);
        if (checkForOld.exists()) {
            checkForOld.delete();
        }
        BufferedInputStream in = null;
        FileOutputStream fout = null;
        try {
            int count;
            in = new BufferedInputStream(new URL(urlString).openStream());
            fout = new FileOutputStream(filename);
            byte[] data = new byte[1024];
            while ((count = in.read(data, 0, 1024)) != -1) {
                fout.write(data, 0, count);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (fout != null) {
                fout.close();
            }
        }
    }

    public ArrayList readFileToArray(String filename) {
        File file = new File(filename);
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String line;
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            StringBuffer stringBuffer = new StringBuffer();
            while ((line = bufferedReader.readLine()) != null) {
                stringBuffer.append(line);
                stringBuffer.append("\n");
                lines.add(line);
            }
            fileReader.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return lines;
    }

    static {
        bannedList = new ArrayList();
    }
}

