/*
 * Decompiled with CFR 0.152.
 */
package com.f3rullo14.cdc.common.entity;

import com.f3rullo14.cdc.CDCure;
import com.f3rullo14.cdc.common.CommonTickHandler;
import com.f3rullo14.cdc.common.entity.EntityBullet;
import com.f3rullo14.cdc.common.entity.EntityCorpse;
import com.f3rullo14.cdc.common.entity.EntityGrenade;
import com.f3rullo14.cdc.common.entity.EntityGroundItem;
import com.f3rullo14.cdc.common.entity.EntityNPCPlayerLogger;
import com.f3rullo14.cdc.common.entity.EntitySupplyDrop;
import com.f3rullo14.cdc.common.entity.vehicle.EntityBike;
import com.f3rullo14.cdc.common.entity.zombie.EntityCDZombie;
import com.f3rullo14.cdc.common.world.WorldManager;
import com.f3rullo14.fds.FCFile;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.server.MinecraftServer;

public class EntityManager {
    public static String[] zombieType1Textures = new String[]{"ZombieEntity1", "ZombieEntity2", "ZombieEntity3", "ZombieEntity4", "ZombieEntity5", "ZombieEntity6", "ZombieEntity7", "ZombieEntity8", "ZombieEntity9", "ZombieEntity10", "ZombieEntity11", "ZombieEntity12", "ZombieEntity13", "ZombieEntity14", "ZombieEntity15", "ZombieEntity16", "ZombieEntity17", "ZombieEntity18", "ZombieEntity19", "ZombieEntity20"};
    private FCFile configZombies = new FCFile("Zombie Config", CDCure.folderLocation + "/configs/zombies.properties");
    public int ZOMBIE_VIEW_DIST = 40;
    public boolean ZOMBIE_DROPS = true;
    private boolean spawnZombies = true;
    public static final double PLAYER_RENDER_DISTANCE = 3.0;

    public EntityManager() {
        this.loadEnities();
    }

    public void loadEnities() {
        if (FMLCommonHandler.instance().getSide() == Side.SERVER) {
            this.ZOMBIE_VIEW_DIST = this.configZombies.getInteger("zombie.view.distance", 40, "Each Zombies view distance");
            this.ZOMBIE_DROPS = this.configZombies.getBoolean("zombie.drops", true, "Should zombies drop items?");
            this.spawnZombies = this.configZombies.getBoolean("zombie.spawn", true, "Should spawn zombies? Default true");
            int var1 = this.configZombies.getInteger("zombie.spawn.rate", 2, "How often zombies spawn, SP = 4-5");
            int var2 = this.configZombies.getInteger("zombie.spawn.count", 2, "How many zombies spawn, SP = 2");
            this.addZombie(EntityCDZombie.class, "CDZFast", 70, var1, var2, var2);
        } else {
            this.addZombie(EntityCDZombie.class, "CDZFast", 70, 3, 1, 2);
        }
        EntityRegistry.registerGlobalEntityID(EntityNPCPlayerLogger.class, "npcpl", 76);
        LanguageRegistry.instance().addStringLocalization("entity.npcpl.name", "NPC Player Logger");
        EntityRegistry.registerModEntity(EntityGroundItem.class, "grounditem", 71, CDCure.instance, 32, 20, true);
        EntityRegistry.registerModEntity(EntityCorpse.class, "corpse", 72, CDCure.instance, 32, 20, true);
        EntityRegistry.registerModEntity(EntityBullet.class, "bullet", 73, CDCure.instance, 48, 20, true);
        EntityRegistry.registerModEntity(EntitySupplyDrop.class, "supplydrop", 74, CDCure.instance, 64, 20, true);
        EntityRegistry.registerModEntity(EntityGrenade.class, "grenade", 75, CDCure.instance, 20, 20, true);
        EntityRegistry.registerModEntity(EntityBike.class, "vehiclebike", 77, CDCure.instance, 64, 20, true);
    }

    public void addZombie(Class entity, String entityname, int id2, int rate, int min, int max) {
        EntityRegistry.registerGlobalEntityID(entity, entityname, id2, 0xFF0000, 0);
        if (FMLCommonHandler.instance().getSide() == Side.SERVER) {
            if (this.spawnZombies) {
                EntityRegistry.addSpawn(entity, rate, min, max, nn.a, WorldManager.cdBiomes);
            } else {
                CDCure.logServer("Turning ZOMBIE spawns off for : " + entityname);
            }
        } else {
            EntityRegistry.addSpawn(entity, rate, min, max, nn.a, WorldManager.cdBiomes);
        }
        LanguageRegistry.instance().addStringLocalization("entity." + entityname + ".name", "Zombie");
    }

    public static void removeAllCorpse() {
        CDCure.log("Removing Corpses!");
        int bodyCount = 0;
        MinecraftServer mcserver = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (mcserver.b.length > 0) {
            for (int i2 = 0; i2 < mcserver.b.length; ++i2) {
                for (int j2 = 0; j2 < mcserver.b[i2].e.size(); ++j2) {
                    mp entity = (mp)mcserver.b[i2].e.get(j2);
                    if (!(entity instanceof EntityCorpse)) continue;
                    entity.w();
                    ++bodyCount;
                }
            }
        }
        CDCure.log(bodyCount + " Corpses removed!");
    }

    public static void removeAllCustomCDEntityItems() {
        CDCure.log("Removing Custom Entity Items!");
        int bodyCount = 0;
        MinecraftServer mcserver = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (mcserver.b.length > 0) {
            for (int i2 = 0; i2 < mcserver.b.length; ++i2) {
                for (int j2 = 0; j2 < mcserver.b[i2].e.size(); ++j2) {
                    mp entity = (mp)mcserver.b[i2].e.get(j2);
                    if (!(entity instanceof EntityGroundItem)) continue;
                    entity.w();
                    ++bodyCount;
                }
            }
        }
        CDCure.log(bodyCount + " CD Entity Items removed!");
    }

    public static void removeAllEntityItems() {
        CDCure.log("Removing Entity Items!");
        int bodyCount = 0;
        MinecraftServer mcserver = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (mcserver.b.length > 0) {
            for (int i2 = 0; i2 < mcserver.b.length; ++i2) {
                for (int j2 = 0; j2 < mcserver.b[i2].e.size(); ++j2) {
                    mp entity = (mp)mcserver.b[i2].e.get(j2);
                    if (!(entity instanceof rh)) continue;
                    entity.w();
                    ++bodyCount;
                }
            }
        }
        CDCure.log(bodyCount + " Entity Items removed!");
    }

    public void spawnSupplyDrop(mp entity) {
        aab world = entity.q;
        if (!world.I) {
            EntitySupplyDrop entitySupplyDrop = new EntitySupplyDrop(world);
            entitySupplyDrop.addRandomContent();
            entitySupplyDrop.addRandomContent();
            entitySupplyDrop.b(entity.u, entity.v + 70.0, entity.w);
            world.d(entitySupplyDrop);
            CommonTickHandler.getCommonTickHandler().getCraftingDeadEvents().onSupplyDropSpawned(entitySupplyDrop);
        }
    }
}

