/*
 * Decompiled with CFR 0.152.
 */
package com.f3rullo14.cdc.common.player;

import com.f3rullo14.cdc.CDCure;
import com.f3rullo14.cdc.common.blocks.BlockManager;
import com.f3rullo14.cdc.common.items.ItemManager;
import com.f3rullo14.cdc.common.player.EnumSurvivorBase;
import com.f3rullo14.cdc.common.player.PlayerData;
import com.f3rullo14.cdc.common.player.PlayerDataHandler;
import com.f3rullo14.cdc.common.player.SurvivorBase;
import com.f3rullo14.fds.FCFile;
import com.f3rullo14.fds.FDSCompound;
import com.f3rullo14.fds.IFDSManager;
import cpw.mods.fml.common.FMLCommonHandler;
import java.util.ArrayList;
import net.minecraft.server.MinecraftServer;

public class SurvivorBaseManager
implements IFDSManager {
    private ArrayList baseList = new ArrayList();
    private ArrayList buildingBlocks = new ArrayList();
    private FCFile baseConfig = new FCFile("Player Bases Config", CDCure.folderLocation + "/configs/bases.properties");
    private int anitBaseRadius = this.baseConfig.getInteger("base.restriction.radius", 50, "In Blocks");
    private int flatAreaCkeck = this.baseConfig.getInteger("base.remove.flatArea.radius", 4, "In Blocks, radius checking for base when removed by player.");
    private int createBaseCoolDown;
    private int maxPlayerOfflineTime = this.baseConfig.getInteger("base.remove.playerHoursOffline", 24, "In Hours, time before a base is removed.");
    private int tick1 = 0;

    public SurvivorBaseManager(CDCure cure) {
        this.createBaseCoolDown = this.baseConfig.getInteger("base.create.coolDownSeconds", 180, "In Seconds");
        this.buildingBlocks.add(apa.N.cz);
        this.buildingBlocks.add(apa.B.cz);
        this.buildingBlocks.add(apa.x.cz);
        this.buildingBlocks.add(apa.aC.cz);
        this.buildingBlocks.add(apa.aI.cz);
        this.buildingBlocks.add(apa.ay.cz);
        this.buildingBlocks.add(apa.A.cz);
        this.buildingBlocks.add(apa.aJ.cz);
        this.buildingBlocks.add(89);
    }

    public void onServerUpdate(MinecraftServer server) {
        if (this.tick1++ >= 72000) {
            if (this.baseList.size() > 0) {
                for (int i2 = 0; i2 < this.baseList.size(); ++i2) {
                    if (this.isOwnerOnline((SurvivorBase)this.baseList.get(i2))) continue;
                    ++((SurvivorBase)this.baseList.get((int)i2)).timeOffline;
                    if (((SurvivorBase)this.baseList.get((int)i2)).timeOffline < this.maxPlayerOfflineTime) continue;
                    for (int j2 = 0; j2 < server.b.length; ++j2) {
                        if (server.b[j2] == null) continue;
                        this.removeOfflineBase(server.b[j2], (SurvivorBase)this.baseList.get(i2));
                    }
                }
            }
            this.tick1 = 0;
        }
    }

    @Override
    public void initLoading(FDSCompound fds) {
        if (fds.hasTag("survivorBaseListSize")) {
            int var1 = fds.getInteger("survivorBaseListSize");
            for (int i2 = 0; i2 < var1; ++i2) {
                String data = fds.getString("survivorBase" + i2);
                String[] dataSplit = data.split(":");
                String owner = dataSplit[0];
                EnumSurvivorBase type = this.getBaseTypeFromName(dataSplit[4]);
                int x2 = Integer.parseInt(dataSplit[1]);
                int y2 = Integer.parseInt(dataSplit[2]);
                int z2 = Integer.parseInt(dataSplit[3]);
                int offline = Integer.parseInt(dataSplit[5]);
                SurvivorBase base = new SurvivorBase(owner, type).setCoords(x2, y2, z2);
                base.timeOffline = offline;
                this.addBase(base);
            }
        }
    }

    @Override
    public void initSaving(FDSCompound fds) {
        fds.setInteger("survivorBaseListSize", this.baseList.size());
        for (int i2 = 0; i2 < this.baseList.size(); ++i2) {
            SurvivorBase base = (SurvivorBase)this.baseList.get(i2);
            fds.setString("survivorBase" + i2, base.getOwnerName() + ":" + base.posX + ":" + base.posY + ":" + base.posZ + ":" + base.baseType.name + ":" + base.timeOffline);
        }
    }

    public void removeOfflineBase(aab world, SurvivorBase base) {
        int flatRadius = this.flatAreaCkeck;
        int pX = base.posX;
        int pY = base.posY;
        int pZ = base.posZ;
        for (int i2 = -flatRadius; i2 < flatRadius; ++i2) {
            for (int j2 = -flatRadius; j2 < flatRadius; ++j2) {
                for (int k2 = 0; k2 < flatRadius * 3; ++k2) {
                    int blockId = world.a(pX + i2, pY + k2, pZ + j2);
                    if (!this.buildingBlocks.contains(blockId)) continue;
                    if (k2 == 0) {
                        world.c(pX + i2, pY + k2, pZ + j2, 3);
                        continue;
                    }
                    world.c(pX + i2, pY + k2, pZ + j2, 0);
                }
            }
        }
    }

    public void removePlayerBase(sq par1EntityPlayer, EnumSurvivorBase par2BaseType) {
        PlayerData data = PlayerDataHandler.getPlayerData(par1EntityPlayer);
        int flatRadius = this.flatAreaCkeck;
        if (this.getPlayersBase(par1EntityPlayer.bS) != null) {
            int pX = (int)par1EntityPlayer.u;
            int pY = (int)par1EntityPlayer.v - 1;
            int pZ = (int)par1EntityPlayer.w;
            SurvivorBase curBase = this.getPlayersBase(par1EntityPlayer.bS);
            if (this.isPlayerInCeneter(curBase, par1EntityPlayer)) {
                int i2;
                aab world = par1EntityPlayer.q;
                world.d(new rh(world, pX, pY, pZ, new wm(ItemManager.basePartDoor)));
                world.d(new rh(world, pX, pY, pZ, new wm(ItemManager.basePartLight)));
                for (i2 = 0; i2 < par2BaseType.getWalls(); ++i2) {
                    world.d(new rh(world, pX, pY, pZ, new wm(ItemManager.basePartWall)));
                }
                for (i2 = -flatRadius; i2 < flatRadius; ++i2) {
                    for (int j2 = -flatRadius; j2 < flatRadius; ++j2) {
                        for (int k2 = 0; k2 < flatRadius * 3; ++k2) {
                            int blockId = par1EntityPlayer.q.a(pX + i2, pY + k2, pZ + j2);
                            if (!this.buildingBlocks.contains(blockId)) continue;
                            if (k2 == 0) {
                                par1EntityPlayer.q.c(pX + i2, pY + k2, pZ + j2, 3);
                                continue;
                            }
                            par1EntityPlayer.q.c(pX + i2, pY + k2, pZ + j2, 0);
                        }
                    }
                }
                CDCure.sendCDChatMessage(par1EntityPlayer, "Removing Base!");
                this.removeBase(curBase);
            } else {
                CDCure.sendCDChatMessage(par1EntityPlayer, "You need to be in the center of your base or where you spawned it in!");
            }
        } else {
            CDCure.sendCDChatMessage(par1EntityPlayer, "You need to have a base first!");
        }
    }

    public boolean isPlayerInCeneter(SurvivorBase base, sq player) {
        int x2 = (int)player.u;
        int y2 = (int)player.v;
        int z2 = (int)player.w;
        int radiusCheck = 1;
        boolean flag = false;
        boolean flag1 = false;
        for (int i2 = -radiusCheck; i2 < radiusCheck; ++i2) {
            for (int j2 = -radiusCheck; j2 < radiusCheck; ++j2) {
                if (base.posX == x2 + i2) {
                    flag = true;
                }
                if (base.posZ == z2 + j2) {
                    flag1 = true;
                }
                if (!flag || !flag1 || base.posY != y2 - 1) continue;
                return true;
            }
        }
        return false;
    }

    public void createPlayerBase(sq par1EntityPlayer, EnumSurvivorBase par2BaseType) {
        PlayerData data = PlayerDataHandler.getPlayerData(par1EntityPlayer);
        int flatRadius = 3;
        if (this.getPlayersBase(par1EntityPlayer.bS) == null) {
            int pX = (int)par1EntityPlayer.u;
            int pY = (int)par1EntityPlayer.v;
            int pZ = (int)par1EntityPlayer.w;
            apa block = apa.r[par1EntityPlayer.q.a(pX, pY - 1, pZ)];
            if (block.cz == apa.y.cz) {
                if (this.isFlatArea(par1EntityPlayer.q, flatRadius, pX, pY - 1, pZ)) {
                    if (this.hasBaseParts(par1EntityPlayer, par2BaseType)) {
                        if (this.isCreationCooledDown(par1EntityPlayer)) {
                            if (!this.isBaseInResctricedZone(par1EntityPlayer.q, pX, pY, pZ)) {
                                this.removeBaseParts(par1EntityPlayer, par2BaseType);
                                CDCure.sendCDChatMessage(par1EntityPlayer, "Generating " + par2BaseType.name + " base!");
                                SurvivorBase base1 = new SurvivorBase(par1EntityPlayer.bS, par2BaseType).setCoords(pX, pY - 1, pZ);
                                base1.generate(par1EntityPlayer.q, pX, pY - 1, pZ);
                                this.addBase(base1);
                                data.baseCreationCoolDown = this.createBaseCoolDown * 20;
                            } else {
                                CDCure.sendCDChatMessage(par1EntityPlayer, "You are within a restricted area, you can not build a base here!");
                            }
                        } else {
                            CDCure.sendCDChatMessage(par1EntityPlayer, "You must wait " + this.createBaseCoolDown + " seconds to remake a base!");
                        }
                    } else {
                        CDCure.sendCDChatMessage(par1EntityPlayer, "You dont have the required parts for this base!");
                    }
                } else {
                    CDCure.sendCDChatMessage(par1EntityPlayer, "Not a flat area!");
                }
            } else {
                CDCure.sendCDChatMessage(par1EntityPlayer, "You can only build bases on grass!");
            }
        } else {
            CDCure.sendCDChatMessage(par1EntityPlayer, "You already have a base placed!");
        }
    }

    public boolean isOwnerOnline(SurvivorBase base) {
        jc player = FMLCommonHandler.instance().getSidedDelegate().getServer().ad().f(base.getOwnerName());
        FMLCommonHandler.instance().getMinecraftServerInstance();
        ArrayList players = (ArrayList)MinecraftServer.D().ad().a;
        return players.contains(players);
    }

    public boolean isCreationCooledDown(sq player) {
        PlayerData data = PlayerDataHandler.getPlayerData(player);
        return CDCure.isEclipseOpen || data.baseCreationCoolDown == 0;
    }

    public boolean hasBaseParts(sq player, EnumSurvivorBase type) {
        return player.bK.e(ItemManager.basePartLight.cp) && player.bK.e(ItemManager.basePartDoor.cp) && this.hasNumberOfWalls(player, type.getWalls());
    }

    public void removeBaseParts(sq player, EnumSurvivorBase type) {
        so inv = player.bK;
        int wallcount = type.getWalls();
        int doorcount = 1;
        int lightcount = 1;
        for (int i2 = 0; i2 < inv.j_(); ++i2) {
            if (inv.a(i2) == null) continue;
            wm itemstack = inv.a(i2);
            if (itemstack.c == ItemManager.basePartLight.cp && lightcount > 0) {
                inv.a(i2, 1);
                --lightcount;
            }
            if (itemstack.c == ItemManager.basePartDoor.cp && doorcount > 0) {
                inv.a(i2, 1);
                --doorcount;
            }
            if (itemstack.c != ItemManager.basePartWall.cp || wallcount <= 0) continue;
            inv.a(i2, 1);
            --wallcount;
        }
    }

    public boolean hasNumberOfWalls(sq player, int par1) {
        so inv = player.bK;
        int var1 = 0;
        for (int i2 = 0; i2 < inv.j_(); ++i2) {
            if (inv.a(i2) == null) continue;
            wm itemstack = inv.a(i2);
            if (itemstack.b().cp != ItemManager.basePartWall.cp) continue;
            ++var1;
        }
        return var1 >= par1;
    }

    public boolean isBaseInResctricedZone(aab world, int x2, int y2, int z2) {
        int var1 = this.anitBaseRadius;
        for (int x1 = -var1; x1 < var1; ++x1) {
            for (int y1 = -var1; y1 < var1; ++y1) {
                for (int z1 = -var1; z1 < var1; ++z1) {
                    int x22 = x2 + x1;
                    int y22 = y2 + y1;
                    int z22 = z2 + z1;
                    if (world.a(x22, y22, z22) != BlockManager.antiBase.cz) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isFlatArea(aab world, int radius, int x2, int y2, int z2) {
        ArrayList<Integer> replaceAble = new ArrayList<Integer>();
        replaceAble.add(apa.ab.cz);
        replaceAble.add(apa.ai.cz);
        replaceAble.add(apa.ah.cz);
        replaceAble.add(0);
        boolean flag = true;
        for (int i2 = -radius; i2 < radius; ++i2) {
            for (int j2 = -radius; j2 < radius; ++j2) {
                if (world.a(x2 + i2, y2, z2 + j2) == 0) {
                    flag = false;
                }
                if (replaceAble.contains(world.a(x2 + i2, y2 + 1, z2 + j2))) continue;
                flag = false;
            }
        }
        return flag;
    }

    public EnumSurvivorBase getBaseTypeFromName(String name) {
        if (name.equals("Small")) {
            return EnumSurvivorBase.LEVEL1;
        }
        if (name.equals("Medium")) {
            return EnumSurvivorBase.LEVEL2;
        }
        if (name.equals("Large")) {
            return EnumSurvivorBase.LEVEL3;
        }
        return null;
    }

    public void addBase(SurvivorBase par1) {
        this.baseList.add(par1);
    }

    public void removeBase(SurvivorBase par1) {
        if (this.baseList.contains(par1)) {
            this.baseList.remove(par1);
        }
    }

    public SurvivorBase getPlayersBase(String name) {
        for (int i2 = 0; i2 < this.baseList.size(); ++i2) {
            if (!((SurvivorBase)this.baseList.get(i2)).getOwnerName().equals(name)) continue;
            return (SurvivorBase)this.baseList.get(i2);
        }
        return null;
    }
}

