/*
 * Decompiled with CFR 0.152.
 */
package com.f3rullo14.cdc.common;

import com.f3rullo14.cdc.CDCure;
import com.f3rullo14.cdc.common.entity.EntityManager;
import com.f3rullo14.fds.FCFile;
import net.minecraft.server.MinecraftServer;

public class LagManager {
    private FCFile lagConfig = new FCFile("lag config", CDCure.folderLocation + "/configs/manage_lag.properties");
    private boolean isClearBodiesEnabled = this.lagConfig.getBoolean("entity.corpse.shouldclear", false, "Will auto clear bodies if set true, reduces lag");
    private boolean warnWhenClearBodies = this.lagConfig.getBoolean("entity.corpse.warn", true, "Warn players on server if clearing bodies");
    private int tickClearBodies = 0;
    private int maxTimeTillClearBodies = this.lagConfig.getInteger("entity.corpse.interval", 120, "Time in seconds bodies will be cleared");
    private boolean isClearCustomItemsEnabled = false;
    private boolean warnWhenClearItems = true;
    private int tickClearItems = 0;
    private int maxTimeTillClearItems = 0;

    public LagManager() {
        this.maxTimeTillClearBodies *= 20;
        this.isClearCustomItemsEnabled = this.lagConfig.getBoolean("entity.customCDitem.shouldclear", false, "Will auto clear CD Items if set true, reduces lag");
        this.warnWhenClearItems = this.lagConfig.getBoolean("entity.customCDitem.warn", true, "Warn players on serevr when clearing items");
        this.maxTimeTillClearItems = this.lagConfig.getInteger("entity.customCDitem.interval", 120, "Time in seconds CD Items will be cleared");
        this.maxTimeTillClearItems *= 20;
    }

    public void onServerUpdate(MinecraftServer server) {
        if (this.isClearBodiesEnabled && this.tickClearBodies++ >= this.maxTimeTillClearBodies) {
            if (this.warnWhenClearBodies) {
                server.a((Object)((Object)a.e) + "[Crafting Dead]: " + (Object)((Object)a.p) + "Removing Dead Bodies!");
            }
            EntityManager.removeAllCorpse();
            this.tickClearBodies = 0;
        }
        if (this.isClearCustomItemsEnabled && this.tickClearItems++ >= this.maxTimeTillClearItems) {
            if (this.warnWhenClearItems) {
                server.a((Object)((Object)a.e) + "[Crafting Dead]: " + (Object)((Object)a.p) + "Removing CD Entity Items!");
            }
            EntityManager.removeAllCustomCDEntityItems();
            this.tickClearItems = 0;
        }
    }
}

