/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.collect.Maps;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import net.minecraftforge.client.model.IModelCustom;
import net.minecraftforge.client.model.IModelCustomLoader;
import net.minecraftforge.client.model.ModelFormatException;
import net.minecraftforge.client.model.obj.ObjModelLoader;

@SideOnly(value=Side.CLIENT)
public class AdvancedModelLoader {
    private static Map<String, IModelCustomLoader> instances = Maps.newHashMap();

    public static void registerModelHandler(IModelCustomLoader modelHandler) {
        for (String suffix : modelHandler.getSuffixes()) {
            instances.put(suffix, modelHandler);
        }
    }

    public static IModelCustom loadModel(String resourceName) throws IllegalArgumentException, ModelFormatException {
        int i2 = resourceName.lastIndexOf(46);
        if (i2 == -1) {
            FMLLog.severe("The resource name %s is not valid", resourceName);
            throw new IllegalArgumentException("The resource name is not valid");
        }
        String suffix = resourceName.substring(i2 + 1);
        IModelCustomLoader loader = instances.get(suffix);
        if (loader == null) {
            FMLLog.severe("The resource name %s is not supported", resourceName);
            throw new IllegalArgumentException("The resource name is not supported");
        }
        URL resource = AdvancedModelLoader.class.getResource(resourceName);
        if (resource == null) {
            FMLLog.severe("The resource name %s could not be found", resourceName);
            throw new IllegalArgumentException("The resource name could not be found");
        }
        return loader.loadInstance(resourceName, resource);
    }

    public static Collection<String> getSupportedSuffixes() {
        return instances.keySet();
    }

    static {
        AdvancedModelLoader.registerModelHandler(new ObjModelLoader());
    }
}

