/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol;

import com.comphenix.protocol.Application;
import com.comphenix.protocol.PacketTypeLookup;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.ConnectionSide;
import com.comphenix.protocol.injector.packet.PacketRegistry;
import com.comphenix.protocol.reflect.ObjectEnum;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.utility.MinecraftVersion;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.commons.lang.WordUtils;
import org.bukkit.Bukkit;

public class PacketType
implements Serializable,
Comparable<PacketType> {
    private static final long serialVersionUID = 1L;
    public static final int UNKNOWN_PACKET = -1;
    private static PacketTypeLookup LOOKUP;
    private static final MinecraftVersion PROTOCOL_VERSION;
    private final Protocol protocol;
    private final Sender sender;
    private final int currentId;
    private final int legacyId;
    private final MinecraftVersion version;
    private final String[] classNames;
    private boolean forceAsync;
    private boolean dynamic;

    private static PacketTypeLookup getLookup() {
        if (LOOKUP == null) {
            LOOKUP = new PacketTypeLookup().addPacketTypes(Handshake.Client.getInstance()).addPacketTypes(Handshake.Server.getInstance()).addPacketTypes(Play.Client.getInstance()).addPacketTypes(Play.Server.getInstance()).addPacketTypes(Status.Client.getInstance()).addPacketTypes(Status.Server.getInstance()).addPacketTypes(Login.Client.getInstance()).addPacketTypes(Login.Server.getInstance()).addPacketTypes(Legacy.Client.getInstance()).addPacketTypes(Legacy.Server.getInstance());
        }
        return LOOKUP;
    }

    public static Iterable<PacketType> values() {
        ArrayList sources = Lists.newArrayList();
        sources.add(Handshake.Client.getInstance());
        sources.add(Handshake.Server.getInstance());
        sources.add(Play.Client.getInstance());
        sources.add(Play.Server.getInstance());
        sources.add(Status.Client.getInstance());
        sources.add(Status.Server.getInstance());
        sources.add(Login.Client.getInstance());
        sources.add(Login.Server.getInstance());
        if (!MinecraftReflection.isUsingNetty()) {
            sources.add(Legacy.Client.getInstance());
            sources.add(Legacy.Server.getInstance());
        }
        return Iterables.concat((Iterable)sources);
    }

    public static PacketType findLegacy(int packetId) {
        PacketType type = PacketType.getLookup().getFromLegacy(packetId);
        if (type != null) {
            return type;
        }
        throw new IllegalArgumentException("Cannot find legacy packet " + packetId);
    }

    public static PacketType findLegacy(int packetId, Sender preference) {
        if (preference == null) {
            return PacketType.findLegacy(packetId);
        }
        PacketType type = PacketType.getLookup().getFromLegacy(packetId, preference);
        if (type != null) {
            return type;
        }
        throw new IllegalArgumentException("Cannot find legacy packet " + packetId);
    }

    public static boolean hasLegacy(int packetId) {
        return PacketType.getLookup().getFromLegacy(packetId) != null;
    }

    @Deprecated
    public static PacketType findCurrent(Protocol protocol, Sender sender, int packetId) {
        PacketType type = PacketType.getLookup().getFromCurrent(protocol, sender, packetId);
        if (type != null) {
            return type;
        }
        throw new IllegalArgumentException("Cannot find packet " + packetId + "(Protocol: " + (Object)((Object)protocol) + ", Sender: " + (Object)((Object)sender) + ")");
    }

    public static PacketType findCurrent(Protocol protocol, Sender sender, String name) {
        name = PacketType.format(protocol, sender, name);
        PacketType type = PacketType.getLookup().getFromCurrent(protocol, sender, name);
        if (type != null) {
            return type;
        }
        throw new IllegalArgumentException("Cannot find packet " + name + "(Protocol: " + (Object)((Object)protocol) + ", Sender: " + (Object)((Object)sender) + ")");
    }

    private static String format(Protocol protocol, Sender sender, String name) {
        if (name.contains("Packet")) {
            return name;
        }
        return String.format("Packet%s%s%s", protocol.getPacketName(), sender.getPacketName(), name);
    }

    @Deprecated
    public static boolean hasCurrent(Protocol protocol, Sender sender, int packetId) {
        return PacketType.getLookup().getFromCurrent(protocol, sender, packetId) != null;
    }

    public static PacketType fromLegacy(int id, Sender sender) {
        PacketType type = PacketType.getLookup().getFromLegacy(id, sender);
        if (type == null) {
            if (sender == null) {
                throw new IllegalArgumentException("Cannot find legacy packet " + id);
            }
            type = PacketType.newLegacy(sender, id);
            PacketType.scheduleRegister(type, "Dynamic-" + UUID.randomUUID().toString());
        }
        return type;
    }

    public static PacketType fromID(Protocol protocol, Sender sender, int packetId, Class<?> packetClass) {
        PacketType type = PacketType.getLookup().getFromCurrent(protocol, sender, packetId);
        if (type == null) {
            type = new PacketType(protocol, sender, packetId, -1, PROTOCOL_VERSION, packetClass.getName());
            type.dynamic = true;
            PacketType.scheduleRegister(type, "Dynamic-" + UUID.randomUUID().toString());
        }
        return type;
    }

    public static PacketType fromCurrent(Protocol protocol, Sender sender, int packetId, Class<?> packetClass) {
        String className;
        PacketTypeLookup.ClassLookup lookup = PacketType.getLookup().getClassLookup();
        Map<String, PacketType> map = lookup.getMap(protocol, sender);
        PacketType type = map.get(className = packetClass.getSimpleName());
        if (type == null) {
            for (PacketType check : map.values()) {
                String[] aliases = check.getClassNames();
                if (aliases.length <= 1) continue;
                for (String alias : aliases) {
                    if (!alias.equals(className)) continue;
                    type = check;
                }
            }
            type = new PacketType(protocol, sender, packetId, -1, PROTOCOL_VERSION, className);
            type.dynamic = true;
            PacketType.scheduleRegister(type, "Dynamic-" + UUID.randomUUID().toString());
        }
        return type;
    }

    public static PacketType fromClass(Class<?> packetClass) {
        PacketType type = PacketRegistry.getPacketType(packetClass);
        if (type != null) {
            return type;
        }
        throw new IllegalArgumentException("Class " + packetClass + " is not a registered packet.");
    }

    public static Collection<PacketType> fromName(String name) {
        return PacketType.getLookup().getFromName(name);
    }

    public static boolean hasClass(Class<?> packetClass) {
        return PacketRegistry.getPacketType(packetClass) != null;
    }

    public static Future<Boolean> scheduleRegister(final PacketType type, final String name) {
        Callable<Boolean> callable = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                ObjectEnum<PacketType> objEnum = PacketType.getObjectEnum(type);
                if (objEnum.registerMember(type, name)) {
                    PacketType.getLookup().addPacketTypes(Arrays.asList(type));
                    return true;
                }
                return false;
            }
        };
        if (Bukkit.getServer() == null || Application.isPrimaryThread()) {
            try {
                return Futures.immediateFuture(callable.call());
            }
            catch (Exception e) {
                return Futures.immediateFailedFuture((Throwable)e);
            }
        }
        return ProtocolLibrary.getExecutorSync().submit((Callable)callable);
    }

    public static ObjectEnum<PacketType> getObjectEnum(PacketType type) {
        switch (type.getProtocol()) {
            case HANDSHAKING: {
                return type.isClient() ? Handshake.Client.getInstance() : Handshake.Server.getInstance();
            }
            case PLAY: {
                return type.isClient() ? Play.Client.getInstance() : Play.Server.getInstance();
            }
            case STATUS: {
                return type.isClient() ? Status.Client.getInstance() : Status.Server.getInstance();
            }
            case LOGIN: {
                return type.isClient() ? Login.Client.getInstance() : Login.Server.getInstance();
            }
            case LEGACY: {
                return type.isClient() ? Legacy.Client.getInstance() : Legacy.Server.getInstance();
            }
        }
        throw new IllegalStateException("Unexpected protocol: " + (Object)((Object)type.getProtocol()));
    }

    public PacketType(Protocol protocol, Sender sender, int currentId, int legacyId, String ... names) {
        this(protocol, sender, currentId, legacyId, PROTOCOL_VERSION, names);
    }

    public PacketType(Protocol protocol, Sender sender, int currentId, int legacyId, MinecraftVersion version, String ... names) {
        this.protocol = (Protocol)((Object)Preconditions.checkNotNull((Object)((Object)protocol), (Object)"protocol cannot be NULL"));
        this.sender = (Sender)((Object)Preconditions.checkNotNull((Object)((Object)sender), (Object)"sender cannot be NULL"));
        this.currentId = currentId;
        this.legacyId = legacyId;
        this.version = version;
        this.classNames = new String[names.length];
        for (int i = 0; i < this.classNames.length; ++i) {
            this.classNames[i] = PacketType.format(protocol, sender, names[i]);
        }
    }

    public static PacketType newLegacy(Sender sender, int legacyId) {
        return new PacketType(Protocol.LEGACY, sender, -1, legacyId, MinecraftVersion.WORLD_UPDATE, new String[0]);
    }

    public boolean isSupported() {
        return PacketRegistry.isSupported(this);
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public Sender getSender() {
        return this.sender;
    }

    public boolean isClient() {
        return this.sender == Sender.CLIENT;
    }

    public boolean isServer() {
        return this.sender == Sender.SERVER;
    }

    @Deprecated
    public int getCurrentId() {
        return this.currentId;
    }

    public String[] getClassNames() {
        return this.classNames;
    }

    public Class<?> getPacketClass() {
        try {
            return PacketRegistry.getPacketClassFromType(this);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String name() {
        return PacketType.getObjectEnum(this).getDeclaredName(this);
    }

    public MinecraftVersion getCurrentVersion() {
        return this.version;
    }

    public int getLegacyId() {
        return this.legacyId;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    private PacketType forceAsync(boolean forceAsync) {
        this.forceAsync = forceAsync;
        return this;
    }

    public boolean forceAsync() {
        return this.forceAsync;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.protocol, this.sender, this.currentId, this.legacyId});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PacketType) {
            PacketType other = (PacketType)obj;
            return this.protocol == other.protocol && this.sender == other.sender && this.currentId == other.currentId && this.legacyId == other.legacyId;
        }
        return false;
    }

    @Override
    public int compareTo(PacketType other) {
        return ComparisonChain.start().compare((Comparable)((Object)this.protocol), (Comparable)((Object)other.getProtocol())).compare((Comparable)((Object)this.sender), (Comparable)((Object)other.getSender())).compare(this.currentId, other.getCurrentId()).compare(this.legacyId, other.getLegacyId()).result();
    }

    public String toString() {
        Class<?> clazz = this.getPacketClass();
        if (clazz == null) {
            return "UNREGISTERED[" + (Object)((Object)this.protocol) + ", " + (Object)((Object)this.sender) + ", " + this.currentId + ", legacy: " + this.legacyId + ", classNames: " + Arrays.toString(this.classNames) + "]";
        }
        return clazz.getSimpleName() + "[" + this.currentId + ", legacy: " + this.legacyId + "]";
    }

    static /* synthetic */ PacketType access$300(PacketType x0, boolean x1) {
        return x0.forceAsync(x1);
    }

    static {
        PROTOCOL_VERSION = MinecraftVersion.BOUNTIFUL_UPDATE;
    }

    public static enum Sender {
        CLIENT,
        SERVER;


        public ConnectionSide toSide() {
            return this == CLIENT ? ConnectionSide.CLIENT_SIDE : ConnectionSide.SERVER_SIDE;
        }

        public String getPacketName() {
            return this == CLIENT ? "In" : "Out";
        }
    }

    public static enum Protocol {
        HANDSHAKING,
        PLAY,
        STATUS,
        LOGIN,
        LEGACY;


        public static Protocol fromVanilla(Enum<?> vanilla) {
            String name = vanilla.name();
            if ("HANDSHAKING".equals(name)) {
                return HANDSHAKING;
            }
            if ("PLAY".equals(name)) {
                return PLAY;
            }
            if ("STATUS".equals(name)) {
                return STATUS;
            }
            if ("LOGIN".equals(name)) {
                return LOGIN;
            }
            throw new IllegalArgumentException("Unrecognized vanilla enum " + vanilla);
        }

        public String getPacketName() {
            return WordUtils.capitalize((String)this.name().toLowerCase());
        }
    }

    public static class Legacy {
        private static final Protocol PROTOCOL = Protocol.LEGACY;

        public static Protocol getProtocol() {
            return PROTOCOL;
        }

        public static class Client
        extends ObjectEnum<PacketType> {
            private static final Sender SENDER = Sender.CLIENT;
            public static final PacketType LOGIN = PacketType.newLegacy(SENDER, 1);
            public static final PacketType RESPAWN = PacketType.newLegacy(SENDER, 9);
            public static final PacketType DISCONNECT = PacketType.newLegacy(SENDER, 255);
            private static final Client INSTANCE = new Client();

            private Client() {
                super(PacketType.class);
            }

            public static Sender getSender() {
                return SENDER;
            }

            public static Client getInstance() {
                return INSTANCE;
            }
        }

        public static class Server
        extends ObjectEnum<PacketType> {
            private static final Sender SENDER = Sender.SERVER;
            public static final PacketType PLAYER_FLYING = PacketType.newLegacy(SENDER, 10);
            public static final PacketType PLAYER_POSITION = PacketType.newLegacy(SENDER, 11);
            public static final PacketType PLAYER_POSITON_LOOK = PacketType.newLegacy(SENDER, 12);
            public static final PacketType PICKUP_SPAWN = PacketType.newLegacy(SENDER, 21);
            public static final PacketType SET_CREATIVE_SLOT = PacketType.newLegacy(SENDER, 107);
            public static final PacketType KEY_RESPONSE = PacketType.newLegacy(SENDER, 252);
            private static final Server INSTANCE = new Server();

            private Server() {
                super(PacketType.class);
            }

            public static Sender getSender() {
                return SENDER;
            }

            public static Server getInstance() {
                return INSTANCE;
            }
        }
    }

    public static class Login {
        private static final Protocol PROTOCOL = Protocol.LOGIN;

        public static Protocol getProtocol() {
            return PROTOCOL;
        }

        static /* synthetic */ Protocol access$400() {
            return PROTOCOL;
        }

        public static class Client
        extends ObjectEnum<PacketType> {
            private static final Sender SENDER = Sender.CLIENT;
            public static final PacketType START = new PacketType(Login.access$400(), SENDER, 0, 231, "Start");
            public static final PacketType ENCRYPTION_BEGIN = new PacketType(Login.access$400(), SENDER, 1, 252, "EncryptionBegin");
            private static final Client INSTANCE = new Client();

            private Client() {
                super(PacketType.class);
            }

            public static Sender getSender() {
                return SENDER;
            }

            public static Client getInstance() {
                return INSTANCE;
            }
        }

        public static class Server
        extends ObjectEnum<PacketType> {
            private static final Sender SENDER = Sender.SERVER;
            public static final PacketType DISCONNECT = new PacketType(Login.access$400(), SENDER, 0, 255, "Disconnect");
            public static final PacketType ENCRYPTION_BEGIN = new PacketType(Login.access$400(), SENDER, 1, 253, "EncryptionBegin");
            public static final PacketType SUCCESS = new PacketType(Login.access$400(), SENDER, 2, 232, "Success");
            public static final PacketType SET_COMPRESSION = new PacketType(Login.access$400(), SENDER, 3, -1, "SetCompression");
            private static final Server INSTANCE = new Server();

            private Server() {
                super(PacketType.class);
            }

            public static Sender getSender() {
                return SENDER;
            }

            public static Server getInstance() {
                return INSTANCE;
            }
        }
    }

    public static class Status {
        private static final Protocol PROTOCOL = Protocol.STATUS;

        public static Protocol getProtocol() {
            return PROTOCOL;
        }

        static /* synthetic */ Protocol access$200() {
            return PROTOCOL;
        }

        public static class Client
        extends ObjectEnum<PacketType> {
            private static final Sender SENDER = Sender.CLIENT;
            public static final PacketType IN_START = new PacketType(Status.access$200(), SENDER, 0, 254, "Start");
            public static final PacketType IN_PING = new PacketType(Status.access$200(), SENDER, 1, 230, "Ping");
            private static final Client INSTANCE = new Client();

            private Client() {
                super(PacketType.class);
            }

            public static Sender getSender() {
                return SENDER;
            }

            public static Client getInstance() {
                return INSTANCE;
            }
        }

        public static class Server
        extends ObjectEnum<PacketType> {
            private static final Sender SENDER = Sender.SERVER;
            public static final PacketType OUT_SERVER_INFO = PacketType.access$300(new PacketType(Status.access$200(), SENDER, 0, 255, "ServerInfo"), true);
            public static final PacketType OUT_PING = new PacketType(Status.access$200(), SENDER, 1, 230, "Pong");
            private static final Server INSTANCE = new Server();

            private Server() {
                super(PacketType.class);
            }

            public static Sender getSender() {
                return SENDER;
            }

            public static Server getInstance() {
                return INSTANCE;
            }
        }
    }

    public static class Play {
        private static final Protocol PROTOCOL = Protocol.PLAY;

        public static Protocol getProtocol() {
            return PROTOCOL;
        }

        static /* synthetic */ Protocol access$100() {
            return PROTOCOL;
        }

        public static class Client
        extends ObjectEnum<PacketType> {
            private static final Sender SENDER = Sender.CLIENT;
            public static final PacketType KEEP_ALIVE = new PacketType(Play.access$100(), SENDER, 0, 0, "KeepAlive");
            public static final PacketType CHAT = new PacketType(Play.access$100(), SENDER, 1, 3, "Chat");
            public static final PacketType USE_ENTITY = new PacketType(Play.access$100(), SENDER, 2, 7, "UseEntity");
            public static final PacketType FLYING = new PacketType(Play.access$100(), SENDER, 3, 10, "Flying");
            public static final PacketType POSITION = new PacketType(Play.access$100(), SENDER, 4, 11, "Position");
            public static final PacketType LOOK = new PacketType(Play.access$100(), SENDER, 5, 12, "Look");
            public static final PacketType POSITION_LOOK = new PacketType(Play.access$100(), SENDER, 6, 13, "PositionLook");
            public static final PacketType BLOCK_DIG = new PacketType(Play.access$100(), SENDER, 7, 14, "BlockDig");
            public static final PacketType BLOCK_PLACE = new PacketType(Play.access$100(), SENDER, 8, 15, "BlockPlace");
            public static final PacketType HELD_ITEM_SLOT = new PacketType(Play.access$100(), SENDER, 9, 16, "HeldItemSlot");
            public static final PacketType ARM_ANIMATION = new PacketType(Play.access$100(), SENDER, 10, 18, "ArmAnimation");
            public static final PacketType ENTITY_ACTION = new PacketType(Play.access$100(), SENDER, 11, 19, "EntityAction");
            public static final PacketType STEER_VEHICLE = new PacketType(Play.access$100(), SENDER, 12, 27, "SteerVehicle");
            public static final PacketType CLOSE_WINDOW = new PacketType(Play.access$100(), SENDER, 13, 101, "CloseWindow");
            public static final PacketType WINDOW_CLICK = new PacketType(Play.access$100(), SENDER, 14, 102, "WindowClick");
            public static final PacketType TRANSACTION = new PacketType(Play.access$100(), SENDER, 15, 106, "Transaction");
            public static final PacketType SET_CREATIVE_SLOT = new PacketType(Play.access$100(), SENDER, 16, 107, "SetCreativeSlot");
            public static final PacketType ENCHANT_ITEM = new PacketType(Play.access$100(), SENDER, 17, 108, "EnchantItem");
            public static final PacketType UPDATE_SIGN = new PacketType(Play.access$100(), SENDER, 18, 130, "UpdateSign");
            public static final PacketType ABILITIES = new PacketType(Play.access$100(), SENDER, 19, 202, "Abilities");
            public static final PacketType TAB_COMPLETE = new PacketType(Play.access$100(), SENDER, 20, 203, "TabComplete");
            public static final PacketType SETTINGS = new PacketType(Play.access$100(), SENDER, 21, 204, "Settings");
            public static final PacketType CLIENT_COMMAND = new PacketType(Play.access$100(), SENDER, 22, 205, "ClientCommand");
            public static final PacketType CUSTOM_PAYLOAD = new PacketType(Play.access$100(), SENDER, 23, 250, "CustomPayload");
            public static final PacketType SPECTATE = new PacketType(Play.access$100(), SENDER, 24, -1, "Spectate");
            public static final PacketType RESOURCE_PACK_STATUS = new PacketType(Play.access$100(), SENDER, 25, -1, "ResourcePackStatus");
            private static final Client INSTANCE = new Client();

            private Client() {
                super(PacketType.class);
            }

            public static Sender getSender() {
                return SENDER;
            }

            public static Client getInstance() {
                return INSTANCE;
            }
        }

        public static class Server
        extends ObjectEnum<PacketType> {
            private static final Sender SENDER = Sender.SERVER;
            public static final PacketType KEEP_ALIVE = new PacketType(Play.access$100(), SENDER, 0, 0, "KeepAlive");
            public static final PacketType LOGIN = new PacketType(Play.access$100(), SENDER, 1, 1, "Login");
            public static final PacketType CHAT = new PacketType(Play.access$100(), SENDER, 2, 3, "Chat");
            public static final PacketType UPDATE_TIME = new PacketType(Play.access$100(), SENDER, 3, 4, "UpdateTime");
            public static final PacketType ENTITY_EQUIPMENT = new PacketType(Play.access$100(), SENDER, 4, 5, "EntityEquipment");
            public static final PacketType SPAWN_POSITION = new PacketType(Play.access$100(), SENDER, 5, 6, "SpawnPosition");
            public static final PacketType UPDATE_HEALTH = new PacketType(Play.access$100(), SENDER, 6, 8, "UpdateHealth");
            public static final PacketType RESPAWN = new PacketType(Play.access$100(), SENDER, 7, 9, "Respawn");
            public static final PacketType POSITION = new PacketType(Play.access$100(), SENDER, 8, 13, "Position");
            public static final PacketType HELD_ITEM_SLOT = new PacketType(Play.access$100(), SENDER, 9, 16, "HeldItemSlot");
            public static final PacketType BED = new PacketType(Play.access$100(), SENDER, 10, 17, "Bed");
            public static final PacketType ANIMATION = new PacketType(Play.access$100(), SENDER, 11, 18, "Animation");
            public static final PacketType NAMED_ENTITY_SPAWN = new PacketType(Play.access$100(), SENDER, 12, 20, "NamedEntitySpawn");
            public static final PacketType COLLECT = new PacketType(Play.access$100(), SENDER, 13, 22, "Collect");
            public static final PacketType SPAWN_ENTITY = new PacketType(Play.access$100(), SENDER, 14, 23, "SpawnEntity");
            public static final PacketType SPAWN_ENTITY_LIVING = new PacketType(Play.access$100(), SENDER, 15, 24, "SpawnEntityLiving");
            public static final PacketType SPAWN_ENTITY_PAINTING = new PacketType(Play.access$100(), SENDER, 16, 25, "SpawnEntityPainting");
            public static final PacketType SPAWN_ENTITY_EXPERIENCE_ORB = new PacketType(Play.access$100(), SENDER, 17, 26, "SpawnEntityExperienceOrb");
            public static final PacketType ENTITY_VELOCITY = new PacketType(Play.access$100(), SENDER, 18, 28, "EntityVelocity");
            public static final PacketType ENTITY_DESTROY = new PacketType(Play.access$100(), SENDER, 19, 29, "EntityDestroy");
            public static final PacketType ENTITY = new PacketType(Play.access$100(), SENDER, 20, 30, "Entity");
            public static final PacketType REL_ENTITY_MOVE = new PacketType(Play.access$100(), SENDER, 21, 31, "RelEntityMove");
            public static final PacketType ENTITY_LOOK = new PacketType(Play.access$100(), SENDER, 22, 32, "EntityLook");
            public static final PacketType ENTITY_MOVE_LOOK = new PacketType(Play.access$100(), SENDER, 23, 33, "RelEntityMoveLook");
            public static final PacketType ENTITY_TELEPORT = new PacketType(Play.access$100(), SENDER, 24, 34, "EntityTeleport");
            public static final PacketType ENTITY_HEAD_ROTATION = new PacketType(Play.access$100(), SENDER, 25, 35, "EntityHeadRotation");
            public static final PacketType ENTITY_STATUS = new PacketType(Play.access$100(), SENDER, 26, 38, "EntityStatus");
            public static final PacketType ATTACH_ENTITY = new PacketType(Play.access$100(), SENDER, 27, 39, "AttachEntity");
            public static final PacketType ENTITY_METADATA = new PacketType(Play.access$100(), SENDER, 28, 40, "EntityMetadata");
            public static final PacketType ENTITY_EFFECT = new PacketType(Play.access$100(), SENDER, 29, 41, "EntityEffect");
            public static final PacketType REMOVE_ENTITY_EFFECT = new PacketType(Play.access$100(), SENDER, 30, 42, "RemoveEntityEffect");
            public static final PacketType EXPERIENCE = new PacketType(Play.access$100(), SENDER, 31, 43, "Experience");
            public static final PacketType UPDATE_ATTRIBUTES = new PacketType(Play.access$100(), SENDER, 32, 44, "UpdateAttributes");
            public static final PacketType MAP_CHUNK = new PacketType(Play.access$100(), SENDER, 33, 51, "MapChunk");
            public static final PacketType MULTI_BLOCK_CHANGE = new PacketType(Play.access$100(), SENDER, 34, 52, "MultiBlockChange");
            public static final PacketType BLOCK_CHANGE = new PacketType(Play.access$100(), SENDER, 35, 53, "BlockChange");
            public static final PacketType BLOCK_ACTION = new PacketType(Play.access$100(), SENDER, 36, 54, "BlockAction");
            public static final PacketType BLOCK_BREAK_ANIMATION = new PacketType(Play.access$100(), SENDER, 37, 55, "BlockBreakAnimation");
            public static final PacketType MAP_CHUNK_BULK = new PacketType(Play.access$100(), SENDER, 38, 56, "MapChunkBulk");
            public static final PacketType EXPLOSION = new PacketType(Play.access$100(), SENDER, 39, 60, "Explosion");
            public static final PacketType WORLD_EVENT = new PacketType(Play.access$100(), SENDER, 40, 61, "WorldEvent");
            public static final PacketType NAMED_SOUND_EFFECT = new PacketType(Play.access$100(), SENDER, 41, 62, "NamedSoundEffect");
            public static final PacketType WORLD_PARTICLES = new PacketType(Play.access$100(), SENDER, 42, 63, "WorldParticles");
            public static final PacketType GAME_STATE_CHANGE = new PacketType(Play.access$100(), SENDER, 43, 70, "GameStateChange");
            public static final PacketType SPAWN_ENTITY_WEATHER = new PacketType(Play.access$100(), SENDER, 44, 71, "SpawnEntityWeather");
            public static final PacketType OPEN_WINDOW = new PacketType(Play.access$100(), SENDER, 45, 100, "OpenWindow");
            public static final PacketType CLOSE_WINDOW = new PacketType(Play.access$100(), SENDER, 46, 101, "CloseWindow");
            public static final PacketType SET_SLOT = new PacketType(Play.access$100(), SENDER, 47, 103, "SetSlot");
            public static final PacketType WINDOW_ITEMS = new PacketType(Play.access$100(), SENDER, 48, 104, "WindowItems");
            public static final PacketType CRAFT_PROGRESS_BAR = new PacketType(Play.access$100(), SENDER, 49, 105, "WindowData");
            public static final PacketType TRANSACTION = new PacketType(Play.access$100(), SENDER, 50, 106, "Transaction");
            public static final PacketType UPDATE_SIGN = new PacketType(Play.access$100(), SENDER, 51, 130, "UpdateSign");
            public static final PacketType MAP = new PacketType(Play.access$100(), SENDER, 52, 131, "Map");
            public static final PacketType TILE_ENTITY_DATA = new PacketType(Play.access$100(), SENDER, 53, 132, "TileEntityData");
            public static final PacketType OPEN_SIGN_ENTITY = new PacketType(Play.access$100(), SENDER, 54, 133, "OpenSignEditor");
            public static final PacketType STATISTICS = new PacketType(Play.access$100(), SENDER, 55, 200, "Statistic");
            public static final PacketType PLAYER_INFO = new PacketType(Play.access$100(), SENDER, 56, 201, "PlayerInfo");
            public static final PacketType ABILITIES = new PacketType(Play.access$100(), SENDER, 57, 202, "Abilities");
            public static final PacketType TAB_COMPLETE = new PacketType(Play.access$100(), SENDER, 58, 203, "TabComplete");
            public static final PacketType SCOREBOARD_OBJECTIVE = new PacketType(Play.access$100(), SENDER, 59, 206, "ScoreboardObjective");
            public static final PacketType SCOREBOARD_SCORE = new PacketType(Play.access$100(), SENDER, 60, 207, "ScoreboardScore");
            public static final PacketType SCOREBOARD_DISPLAY_OBJECTIVE = new PacketType(Play.access$100(), SENDER, 61, 208, "ScoreboardDisplayObjective");
            public static final PacketType SCOREBOARD_TEAM = new PacketType(Play.access$100(), SENDER, 62, 209, "ScoreboardTeam");
            public static final PacketType CUSTOM_PAYLOAD = new PacketType(Play.access$100(), SENDER, 63, 250, "CustomPayload");
            public static final PacketType KICK_DISCONNECT = new PacketType(Play.access$100(), SENDER, 64, 255, "KickDisconnect");
            public static final PacketType SERVER_DIFFICULTY = new PacketType(Play.access$100(), SENDER, 65, -1, "ServerDifficulty");
            public static final PacketType COMBAT_EVENT = new PacketType(Play.access$100(), SENDER, 66, -1, "CombatEvent");
            public static final PacketType CAMERA = new PacketType(Play.access$100(), SENDER, 67, -1, "Camera");
            public static final PacketType WORLD_BORDER = new PacketType(Play.access$100(), SENDER, 68, -1, "WorldBorder");
            public static final PacketType TITLE = new PacketType(Play.access$100(), SENDER, 69, -1, "Title");
            public static final PacketType SET_COMPRESSION = new PacketType(Play.access$100(), SENDER, 70, -1, "SetCompression");
            public static final PacketType PLAYER_LIST_HEADER_FOOTER = new PacketType(Play.access$100(), SENDER, 71, -1, "PlayerListHeaderFooter");
            public static final PacketType RESOURCE_PACK_SEND = new PacketType(Play.access$100(), SENDER, 72, -1, "ResourcePackSend");
            public static final PacketType UPDATE_ENTITY_NBT = new PacketType(Play.access$100(), SENDER, 73, -1, "UpdateEntityNBT");
            private static final Server INSTANCE = new Server();

            private Server() {
                super(PacketType.class);
            }

            public static Sender getSender() {
                return SENDER;
            }

            public static Server getInstance() {
                return INSTANCE;
            }
        }
    }

    public static class Handshake {
        private static final Protocol PROTOCOL = Protocol.HANDSHAKING;

        public static Protocol getProtocol() {
            return PROTOCOL;
        }

        static /* synthetic */ Protocol access$000() {
            return PROTOCOL;
        }

        public static class Server
        extends ObjectEnum<PacketType> {
            private static final Sender SENDER = Sender.CLIENT;
            private static final Server INSTANCE = new Server();

            private Server() {
                super(PacketType.class);
            }

            public static Server getInstance() {
                return INSTANCE;
            }

            public static Sender getSender() {
                return SENDER;
            }
        }

        public static class Client
        extends ObjectEnum<PacketType> {
            private static final Sender SENDER = Sender.CLIENT;
            public static final PacketType SET_PROTOCOL = new PacketType(Handshake.access$000(), SENDER, 0, 2, "SetProtocol");
            private static final Client INSTANCE = new Client();

            private Client() {
                super(PacketType.class);
            }

            public static Client getInstance() {
                return INSTANCE;
            }

            public static Sender getSender() {
                return SENDER;
            }
        }
    }
}

