/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.compat.guava;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.compat.guava.GuavaCompat;
import com.google.common.collect.DiscreteDomains;
import com.google.common.collect.Range;
import com.google.common.collect.Ranges;
import com.google.common.io.ByteStreams;
import com.google.common.io.InputSupplier;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;

public class Guava10
implements GuavaCompat {
    @Override
    public <C extends Comparable<C>> Range<C> closedRange(C lower, C upper) {
        return Ranges.closed(lower, upper);
    }

    @Override
    public <C extends Comparable<C>> Range<C> singletonRange(C value) {
        return Ranges.singleton(value);
    }

    @Override
    public Set<Integer> toSet(Range<Integer> range) {
        return range.asSet(DiscreteDomains.integers());
    }

    @Override
    public DataInputStream addHeader(final DataInputStream input, final PacketType type) {
        InputSupplier<InputStream> header = new InputSupplier<InputStream>(){

            public InputStream getInput() throws IOException {
                byte[] data = new byte[]{(byte)type.getLegacyId()};
                return new ByteArrayInputStream(data);
            }
        };
        InputSupplier<InputStream> data = new InputSupplier<InputStream>(){

            public InputStream getInput() throws IOException {
                return input;
            }
        };
        try {
            return new DataInputStream((InputStream)ByteStreams.join((InputSupplier[])new InputSupplier[]{header, data}).getInput());
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot add header.", e);
        }
    }
}

