/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.compat.netty;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.injector.netty.ProtocolRegistry;
import com.comphenix.protocol.injector.packet.MapContainer;
import com.comphenix.protocol.reflect.StructureModifier;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;

public class LegacyProtocolRegistry
extends ProtocolRegistry {
    @Override
    protected void initialize() {
        T[] protocols = this.enumProtocol.getEnumConstants();
        ArrayList serverMaps = Lists.newArrayList();
        ArrayList clientMaps = Lists.newArrayList();
        StructureModifier modifier = null;
        ProtocolRegistry.Register result = new ProtocolRegistry.Register();
        for (Object protocol : protocols) {
            if (modifier == null) {
                modifier = new StructureModifier(protocol.getClass().getSuperclass(), false);
            }
            StructureModifier maps = modifier.withTarget(protocol).withType(Map.class);
            serverMaps.add(maps.read(0));
            clientMaps.add(maps.read(1));
        }
        for (Map map : Iterables.concat((Iterable)serverMaps, (Iterable)clientMaps)) {
            result.containers.add(new MapContainer(map));
        }
        if (this.sum(clientMaps) > this.sum(serverMaps)) {
            ArrayList temp = serverMaps;
            serverMaps = clientMaps;
            clientMaps = temp;
        }
        for (int i = 0; i < protocols.length; ++i) {
            Enum enumProtocol = (Enum)protocols[i];
            PacketType.Protocol equivalent = PacketType.Protocol.fromVanilla(enumProtocol);
            this.associatePackets(result, (Map)serverMaps.get(i), equivalent, PacketType.Sender.SERVER);
            this.associatePackets(result, (Map)clientMaps.get(i), equivalent, PacketType.Sender.CLIENT);
        }
        this.register = result;
    }

    @Override
    protected void associatePackets(ProtocolRegistry.Register register, Map<Integer, Class<?>> lookup, PacketType.Protocol protocol, PacketType.Sender sender) {
        for (Map.Entry<Integer, Class<?>> entry : lookup.entrySet()) {
            PacketType type = PacketType.fromID(protocol, sender, entry.getKey(), entry.getValue());
            try {
                register.typeToClass.put((Object)type, entry.getValue());
                if (sender == PacketType.Sender.SERVER) {
                    register.serverPackets.add(type);
                }
                if (sender != PacketType.Sender.CLIENT) continue;
                register.clientPackets.add(type);
            }
            catch (IllegalArgumentException ex) {}
        }
    }
}

