/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.compat.netty.independent;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.compat.netty.ChannelInjector;
import com.comphenix.protocol.compat.netty.ProtocolInjector;
import com.comphenix.protocol.compat.netty.WrappedChannel;
import com.comphenix.protocol.compat.netty.independent.NettyBootstrapList;
import com.comphenix.protocol.compat.netty.independent.NettyInjectionFactory;
import com.comphenix.protocol.concurrency.PacketTypeSet;
import com.comphenix.protocol.error.ErrorReporter;
import com.comphenix.protocol.error.Report;
import com.comphenix.protocol.error.ReportType;
import com.comphenix.protocol.events.ConnectionSide;
import com.comphenix.protocol.events.ListenerOptions;
import com.comphenix.protocol.events.NetworkMarker;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.injector.ListenerInvoker;
import com.comphenix.protocol.injector.netty.ChannelListener;
import com.comphenix.protocol.injector.netty.Injector;
import com.comphenix.protocol.injector.netty.NettyNetworkMarker;
import com.comphenix.protocol.injector.packet.PacketInjector;
import com.comphenix.protocol.injector.packet.PacketRegistry;
import com.comphenix.protocol.injector.player.PlayerInjectionHandler;
import com.comphenix.protocol.injector.server.TemporaryPlayerFactory;
import com.comphenix.protocol.injector.spigot.AbstractPacketInjector;
import com.comphenix.protocol.injector.spigot.AbstractPlayerHandler;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.VolatileField;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.google.common.collect.Lists;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class NettyProtocolInjector
implements ProtocolInjector {
    public static final ReportType REPORT_CANNOT_INJECT_INCOMING_CHANNEL = new ReportType("Unable to inject incoming channel %s.");
    private volatile boolean injected;
    private volatile boolean closed;
    private TemporaryPlayerFactory playerFactory = new TemporaryPlayerFactory();
    private List<VolatileField> bootstrapFields = Lists.newArrayList();
    private NettyInjectionFactory injectionFactory;
    private volatile List<Object> networkManagers;
    private PacketTypeSet sendingFilters = new PacketTypeSet();
    private PacketTypeSet reveivedFilters = new PacketTypeSet();
    private PacketTypeSet mainThreadFilters = new PacketTypeSet();
    private PacketTypeSet bufferedPackets = new PacketTypeSet();
    private ListenerInvoker invoker;
    private ErrorReporter reporter;
    private boolean debug;

    public NettyProtocolInjector(Plugin plugin, ListenerInvoker invoker, ErrorReporter reporter) {
        this.injectionFactory = new NettyInjectionFactory(plugin);
        this.invoker = invoker;
        this.reporter = reporter;
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    @Override
    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Override
    public synchronized void inject() {
        if (this.injected) {
            throw new IllegalStateException("Cannot inject twice.");
        }
        try {
            FuzzyReflection fuzzyServer = FuzzyReflection.fromClass(MinecraftReflection.getMinecraftServerClass());
            List<Method> serverConnectionMethods = fuzzyServer.getMethodListByParameters(MinecraftReflection.getServerConnectionClass(), new Class[0]);
            Object server = fuzzyServer.getSingleton();
            Object serverConnection = null;
            for (Method method : serverConnectionMethods) {
                try {
                    serverConnection = method.invoke(server, new Object[0]);
                    if (serverConnection == null) continue;
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ChannelInitializer<Channel> endInitProtocol = new ChannelInitializer<Channel>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void initChannel(Channel channel) throws Exception {
                    try {
                        List list = NettyProtocolInjector.this.networkManagers;
                        synchronized (list) {
                            NettyProtocolInjector.this.injectionFactory.fromChannel(channel, NettyProtocolInjector.this, NettyProtocolInjector.this.playerFactory).inject();
                        }
                    }
                    catch (Exception e) {
                        NettyProtocolInjector.this.reporter.reportDetailed((Object)NettyProtocolInjector.this, Report.newBuilder(REPORT_CANNOT_INJECT_INCOMING_CHANNEL).messageParam(channel).error(e));
                    }
                }
            };
            ChannelInitializer<Channel> beginInitProtocol = new ChannelInitializer<Channel>((ChannelInboundHandler)endInitProtocol){
                final /* synthetic */ ChannelInboundHandler val$endInitProtocol;
                {
                    this.val$endInitProtocol = channelInboundHandler;
                }

                protected void initChannel(Channel channel) throws Exception {
                    channel.pipeline().addLast(new ChannelHandler[]{this.val$endInitProtocol});
                }
            };
            ChannelInboundHandlerAdapter connectionHandler = new ChannelInboundHandlerAdapter((ChannelInboundHandler)beginInitProtocol){
                final /* synthetic */ ChannelInboundHandler val$beginInitProtocol;
                {
                    this.val$beginInitProtocol = channelInboundHandler;
                }

                public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                    Channel channel = (Channel)msg;
                    channel.pipeline().addFirst(new ChannelHandler[]{this.val$beginInitProtocol});
                    ctx.fireChannelRead(msg);
                }
            };
            this.networkManagers = (List)FuzzyReflection.fromObject(serverConnection, true).invokeMethod(null, "getNetworkManagers", List.class, serverConnection);
            this.bootstrapFields = this.getBootstrapFields(serverConnection);
            for (VolatileField field : this.bootstrapFields) {
                List list = (List)field.getValue();
                if (list == this.networkManagers) continue;
                field.setValue(new NettyBootstrapList(list, (ChannelHandler)connectionHandler));
            }
            this.injected = true;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to inject channel futures.", e);
        }
    }

    @Override
    public boolean hasListener(Class<?> packetClass) {
        return this.reveivedFilters.contains(packetClass) || this.sendingFilters.contains(packetClass);
    }

    @Override
    public boolean hasMainThreadListener(Class<?> packetClass) {
        return this.mainThreadFilters.contains(packetClass);
    }

    @Override
    public ErrorReporter getReporter() {
        return this.reporter;
    }

    public void injectPlayer(Player player) {
        this.injectionFactory.fromPlayer(player, this).inject();
    }

    private List<VolatileField> getBootstrapFields(Object serverConnection) {
        ArrayList result = Lists.newArrayList();
        for (Field field : FuzzyReflection.fromObject(serverConnection, true).getFieldListByType(List.class)) {
            VolatileField volatileField = new VolatileField(field, serverConnection, true).toSynchronized();
            List list = (List)volatileField.getValue();
            if (list.size() != 0 && !(list.get(0) instanceof ChannelFuture)) continue;
            result.add(volatileField);
        }
        return result;
    }

    @Override
    public synchronized void close() {
        if (!this.closed) {
            this.closed = true;
            for (VolatileField field : this.bootstrapFields) {
                Object value = field.getValue();
                if (value instanceof NettyBootstrapList) {
                    ((NettyBootstrapList)value).close();
                }
                field.revertValue();
            }
            this.injectionFactory.close();
        }
    }

    @Override
    public PacketEvent onPacketSending(Injector injector, Object packet, NetworkMarker marker) {
        Class<?> clazz = packet.getClass();
        if (this.sendingFilters.contains(clazz) || marker != null) {
            try {
                PacketContainer container = new PacketContainer(PacketRegistry.getPacketType(clazz), packet);
                return this.packetQueued(container, injector.getPlayer(), marker);
            }
            catch (LinkageError e) {
                System.err.println("[ProtocolLib] Encountered a LinkageError. Make sure you're not using this jar for multiple server instances!");
                System.err.println("[ProtocolLib] If you're getting this error for other reasons, please report it!");
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public PacketEvent onPacketReceiving(Injector injector, Object packet, NetworkMarker marker) {
        Class<?> clazz = packet.getClass();
        if (this.reveivedFilters.contains(clazz) || marker != null) {
            PacketContainer container = new PacketContainer(PacketRegistry.getPacketType(clazz), packet);
            return this.packetReceived(container, injector.getPlayer(), marker);
        }
        return null;
    }

    @Override
    public boolean includeBuffer(Class<?> packetClass) {
        return this.bufferedPackets.contains(packetClass);
    }

    private PacketEvent packetQueued(PacketContainer packet, Player receiver, NetworkMarker marker) {
        PacketEvent event = PacketEvent.fromServer(this, packet, marker, receiver);
        this.invoker.invokePacketSending(event);
        return event;
    }

    private PacketEvent packetReceived(PacketContainer packet, Player sender, NetworkMarker marker) {
        PacketEvent event = PacketEvent.fromClient(this, packet, marker, sender);
        this.invoker.invokePacketRecieving(event);
        return event;
    }

    @Override
    public PlayerInjectionHandler getPlayerInjector() {
        return new AbstractPlayerHandler(this.sendingFilters){
            private ChannelListener listener;
            {
                this.listener = NettyProtocolInjector.this;
            }

            @Override
            public int getProtocolVersion(Player player) {
                return NettyProtocolInjector.this.injectionFactory.fromPlayer(player, this.listener).getProtocolVersion();
            }

            @Override
            public void updatePlayer(Player player) {
                NettyProtocolInjector.this.injectionFactory.fromPlayer(player, this.listener).inject();
            }

            @Override
            public void injectPlayer(Player player, PlayerInjectionHandler.ConflictStrategy strategy) {
                NettyProtocolInjector.this.injectionFactory.fromPlayer(player, this.listener).inject();
            }

            @Override
            public boolean uninjectPlayer(InetSocketAddress address) {
                return true;
            }

            @Override
            public void addPacketHandler(PacketType type, Set<ListenerOptions> options) {
                if (options != null && !type.forceAsync() && !options.contains((Object)ListenerOptions.ASYNC)) {
                    NettyProtocolInjector.this.mainThreadFilters.addType(type);
                }
                super.addPacketHandler(type, options);
            }

            @Override
            public void removePacketHandler(PacketType type) {
                NettyProtocolInjector.this.mainThreadFilters.removeType(type);
                super.removePacketHandler(type);
            }

            @Override
            public boolean uninjectPlayer(Player player) {
                return true;
            }

            @Override
            public void sendServerPacket(Player receiver, PacketContainer packet, NetworkMarker marker, boolean filters) throws InvocationTargetException {
                NettyProtocolInjector.this.injectionFactory.fromPlayer(receiver, this.listener).sendServerPacket(packet.getHandle(), marker, filters);
            }

            @Override
            public boolean hasMainThreadListener(PacketType type) {
                return NettyProtocolInjector.this.mainThreadFilters.contains(type);
            }

            @Override
            public void recieveClientPacket(Player player, Object mcPacket) throws IllegalAccessException, InvocationTargetException {
                NettyProtocolInjector.this.injectionFactory.fromPlayer(player, this.listener).recieveClientPacket(mcPacket);
            }

            @Override
            public PacketEvent handlePacketRecieved(PacketContainer packet, InputStream input, byte[] buffered) {
                return null;
            }

            @Override
            public void handleDisconnect(Player player) {
                NettyProtocolInjector.this.injectionFactory.fromPlayer(player, this.listener).close();
            }

            @Override
            public WrappedChannel getChannel(Player player) {
                Injector injector = NettyProtocolInjector.this.injectionFactory.fromPlayer(player, this.listener);
                if (injector instanceof ChannelInjector) {
                    return ((ChannelInjector)injector).getChannel();
                }
                return null;
            }
        };
    }

    @Override
    public PacketInjector getPacketInjector() {
        return new AbstractPacketInjector(this.reveivedFilters){

            @Override
            public PacketEvent packetRecieved(PacketContainer packet, Player client, byte[] buffered) {
                NettyNetworkMarker marker = buffered != null ? new NettyNetworkMarker(ConnectionSide.CLIENT_SIDE, buffered) : null;
                NettyProtocolInjector.this.injectionFactory.fromPlayer(client, NettyProtocolInjector.this).saveMarker(packet.getHandle(), marker);
                return NettyProtocolInjector.this.packetReceived(packet, client, marker);
            }

            @Override
            public void inputBuffersChanged(Set<PacketType> set) {
                NettyProtocolInjector.this.bufferedPackets = new PacketTypeSet(set);
            }
        };
    }
}

