/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.compat.netty.independent;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.injector.netty.ProtocolRegistry;
import com.comphenix.protocol.injector.packet.MapContainer;
import com.comphenix.protocol.reflect.StructureModifier;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;

public class NettyProtocolRegistry
extends ProtocolRegistry {
    @Override
    protected synchronized void initialize() {
        T[] protocols = this.enumProtocol.getEnumConstants();
        LinkedHashMap serverMaps = Maps.newLinkedHashMap();
        LinkedHashMap clientMaps = Maps.newLinkedHashMap();
        ProtocolRegistry.Register result = new ProtocolRegistry.Register();
        StructureModifier modifier = null;
        for (Object protocol : protocols) {
            if (modifier == null) {
                modifier = new StructureModifier(protocol.getClass().getSuperclass(), false);
            }
            StructureModifier maps = modifier.withTarget(protocol).withType(Map.class);
            for (Map.Entry entry : ((Map)maps.read(0)).entrySet()) {
                String direction = entry.getKey().toString();
                if (direction.contains("CLIENTBOUND")) {
                    serverMaps.put(protocol, entry.getValue());
                    continue;
                }
                if (!direction.contains("SERVERBOUND")) continue;
                clientMaps.put(protocol, entry.getValue());
            }
        }
        for (Map map : serverMaps.values()) {
            result.containers.add(new MapContainer(map));
        }
        for (Map map : clientMaps.values()) {
            result.containers.add(new MapContainer(map));
        }
        for (int i = 0; i < protocols.length; ++i) {
            Object protocol = protocols[i];
            Enum enumProtocol = (Enum)protocol;
            PacketType.Protocol equivalent = PacketType.Protocol.fromVanilla(enumProtocol);
            if (serverMaps.containsKey(protocol)) {
                this.associatePackets(result, (Map)serverMaps.get(protocol), equivalent, PacketType.Sender.SERVER);
            }
            if (!clientMaps.containsKey(protocol)) continue;
            this.associatePackets(result, (Map)clientMaps.get(protocol), equivalent, PacketType.Sender.CLIENT);
        }
        this.register = result;
    }

    @Override
    protected void associatePackets(ProtocolRegistry.Register register, Map<Integer, Class<?>> lookup, PacketType.Protocol protocol, PacketType.Sender sender) {
        for (Map.Entry<Integer, Class<?>> entry : lookup.entrySet()) {
            PacketType type = PacketType.fromCurrent(protocol, sender, entry.getKey(), entry.getValue());
            try {
                register.typeToClass.put((Object)type, entry.getValue());
                if (sender == PacketType.Sender.SERVER) {
                    register.serverPackets.add(type);
                }
                if (sender != PacketType.Sender.CLIENT) continue;
                register.clientPackets.add(type);
            }
            catch (IllegalArgumentException ex) {}
        }
    }
}

