/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.compat.netty.shaded;

import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.FieldAccessor;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.google.common.io.ByteStreams;
import com.google.common.io.LimitInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.WritableByteChannel;
import net.minecraft.util.io.netty.buffer.AbstractByteBuf;
import net.minecraft.util.io.netty.buffer.ByteBuf;
import net.minecraft.util.io.netty.buffer.ByteBufAllocator;

public class ShadedByteBufAdapter
extends AbstractByteBuf {
    private DataInputStream input;
    private DataOutputStream output;
    private static FieldAccessor READER_INDEX;
    private static FieldAccessor WRITER_INDEX;
    private static final int CAPACITY = Short.MAX_VALUE;

    private ShadedByteBufAdapter(DataInputStream input, DataOutputStream output) {
        super(Short.MAX_VALUE);
        this.input = input;
        this.output = output;
        try {
            if (READER_INDEX == null) {
                READER_INDEX = Accessors.getFieldAccessor(AbstractByteBuf.class.getDeclaredField("readerIndex"));
            }
            if (WRITER_INDEX == null) {
                WRITER_INDEX = Accessors.getFieldAccessor(AbstractByteBuf.class.getDeclaredField("writerIndex"));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot initialize ByteBufAdapter.", e);
        }
        if (input == null) {
            READER_INDEX.set((Object)this, Integer.MAX_VALUE);
        }
        if (output == null) {
            WRITER_INDEX.set((Object)this, Integer.MAX_VALUE);
        }
    }

    public static ByteBuf packetReader(DataInputStream input) {
        return (ByteBuf)MinecraftReflection.getPacketDataSerializer((Object)new ShadedByteBufAdapter(input, null));
    }

    public static ByteBuf packetWriter(DataOutputStream output) {
        return (ByteBuf)MinecraftReflection.getPacketDataSerializer((Object)new ShadedByteBufAdapter(null, output));
    }

    public int refCnt() {
        return 1;
    }

    public boolean release() {
        return false;
    }

    public boolean release(int paramInt) {
        return false;
    }

    protected byte _getByte(int paramInt) {
        try {
            return this.input.readByte();
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot read input.", e);
        }
    }

    protected short _getShort(int paramInt) {
        try {
            return this.input.readShort();
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot read input.", e);
        }
    }

    protected int _getUnsignedMedium(int paramInt) {
        try {
            return this.input.readUnsignedShort();
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot read input.", e);
        }
    }

    protected int _getInt(int paramInt) {
        try {
            return this.input.readInt();
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot read input.", e);
        }
    }

    protected long _getLong(int paramInt) {
        try {
            return this.input.readLong();
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot read input.", e);
        }
    }

    protected void _setByte(int index, int value) {
        try {
            this.output.writeByte(value);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot write output.", e);
        }
    }

    protected void _setShort(int index, int value) {
        try {
            this.output.writeShort(value);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot write output.", e);
        }
    }

    protected void _setMedium(int index, int value) {
        try {
            this.output.writeShort(value);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot write output.", e);
        }
    }

    protected void _setInt(int index, int value) {
        try {
            this.output.writeInt(value);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot write output.", e);
        }
    }

    protected void _setLong(int index, long value) {
        try {
            this.output.writeLong(value);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot write output.", e);
        }
    }

    public int capacity() {
        return Short.MAX_VALUE;
    }

    public ByteBuf capacity(int paramInt) {
        return this;
    }

    public ByteBufAllocator alloc() {
        return null;
    }

    public ByteOrder order() {
        return ByteOrder.LITTLE_ENDIAN;
    }

    public ByteBuf unwrap() {
        return null;
    }

    public boolean isDirect() {
        return false;
    }

    public ByteBuf getBytes(int index, ByteBuf dst, int dstIndex, int length) {
        try {
            for (int i = 0; i < length; ++i) {
                dst.setByte(dstIndex + i, this.input.read());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot read input.", e);
        }
        return this;
    }

    public ByteBuf getBytes(int index, byte[] dst, int dstIndex, int length) {
        try {
            this.input.read(dst, dstIndex, length);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot read input.", e);
        }
        return this;
    }

    public ByteBuf getBytes(int index, ByteBuffer dst) {
        try {
            dst.put(ByteStreams.toByteArray((InputStream)this.input));
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot read input.", e);
        }
        return this;
    }

    public ByteBuf getBytes(int index, OutputStream dst, int length) throws IOException {
        ByteStreams.copy((InputStream)new LimitInputStream((InputStream)this.input, (long)length), (OutputStream)dst);
        return this;
    }

    public int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        byte[] data = ByteStreams.toByteArray((InputStream)new LimitInputStream((InputStream)this.input, (long)length));
        out.write(ByteBuffer.wrap(data));
        return data.length;
    }

    public ByteBuf setBytes(int index, ByteBuf src, int srcIndex, int length) {
        byte[] buffer = new byte[length];
        src.getBytes(srcIndex, buffer);
        try {
            this.output.write(buffer);
            return this;
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot write output.", e);
        }
    }

    public ByteBuf setBytes(int index, byte[] src, int srcIndex, int length) {
        try {
            this.output.write(src, srcIndex, length);
            return this;
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot write output.", e);
        }
    }

    public ByteBuf setBytes(int index, ByteBuffer src) {
        try {
            WritableByteChannel channel = Channels.newChannel(this.output);
            channel.write(src);
            return this;
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot write output.", e);
        }
    }

    public int setBytes(int index, InputStream in, int length) throws IOException {
        LimitInputStream limit = new LimitInputStream(in, (long)length);
        ByteStreams.copy((InputStream)limit, (OutputStream)this.output);
        return length - limit.available();
    }

    public int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(length);
        WritableByteChannel channel = Channels.newChannel(this.output);
        int count = in.read(buffer);
        channel.write(buffer);
        return count;
    }

    public ByteBuf copy(int index, int length) {
        throw new UnsupportedOperationException("Cannot seek in input stream.");
    }

    public int nioBufferCount() {
        return 0;
    }

    public ByteBuffer nioBuffer(int paramInt1, int paramInt2) {
        throw new UnsupportedOperationException();
    }

    public ByteBuffer internalNioBuffer(int paramInt1, int paramInt2) {
        return null;
    }

    public ByteBuffer[] nioBuffers(int paramInt1, int paramInt2) {
        return null;
    }

    public boolean hasArray() {
        return false;
    }

    public byte[] array() {
        return null;
    }

    public int arrayOffset() {
        return 0;
    }

    public boolean hasMemoryAddress() {
        return false;
    }

    public long memoryAddress() {
        return 0L;
    }

    public ByteBuf retain(int paramInt) {
        return this;
    }

    public ByteBuf retain() {
        return this;
    }
}

