/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.compat.netty.shaded;

import com.comphenix.protocol.compat.netty.shaded.ShadedEventLoopProxy;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.FieldAccessor;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.Callable;
import net.minecraft.util.io.netty.buffer.ByteBufAllocator;
import net.minecraft.util.io.netty.channel.Channel;
import net.minecraft.util.io.netty.channel.ChannelConfig;
import net.minecraft.util.io.netty.channel.ChannelFuture;
import net.minecraft.util.io.netty.channel.ChannelMetadata;
import net.minecraft.util.io.netty.channel.ChannelPipeline;
import net.minecraft.util.io.netty.channel.ChannelProgressivePromise;
import net.minecraft.util.io.netty.channel.ChannelPromise;
import net.minecraft.util.io.netty.channel.EventLoop;
import net.minecraft.util.io.netty.util.Attribute;
import net.minecraft.util.io.netty.util.AttributeKey;

public abstract class ShadedChannelProxy
implements Channel {
    private static final FieldAccessor MARK_NO_MESSAGE = new FieldAccessor(){

        @Override
        public void set(Object instance, Object value) {
        }

        @Override
        public Object get(Object instance) {
            return null;
        }

        @Override
        public Field getField() {
            return null;
        }
    };
    private static Map<Class<?>, FieldAccessor> MESSAGE_LOOKUP = Maps.newConcurrentMap();
    protected Channel delegate;
    protected Class<?> messageClass;
    private transient ShadedEventLoopProxy loopProxy;

    public ShadedChannelProxy(Channel delegate, Class<?> messageClass) {
        this.delegate = delegate;
        this.messageClass = messageClass;
    }

    protected abstract <T> Callable<T> onMessageScheduled(Callable<T> var1, FieldAccessor var2);

    protected abstract Runnable onMessageScheduled(Runnable var1, FieldAccessor var2);

    public <T> Attribute<T> attr(AttributeKey<T> paramAttributeKey) {
        return this.delegate.attr(paramAttributeKey);
    }

    public ChannelFuture bind(SocketAddress paramSocketAddress) {
        return this.delegate.bind(paramSocketAddress);
    }

    public ChannelPipeline pipeline() {
        return this.delegate.pipeline();
    }

    public ChannelFuture connect(SocketAddress paramSocketAddress) {
        return this.delegate.connect(paramSocketAddress);
    }

    public ByteBufAllocator alloc() {
        return this.delegate.alloc();
    }

    public ChannelPromise newPromise() {
        return this.delegate.newPromise();
    }

    public EventLoop eventLoop() {
        if (this.loopProxy == null) {
            this.loopProxy = new ShadedEventLoopProxy(){

                @Override
                protected EventLoop getDelegate() {
                    return ShadedChannelProxy.this.delegate.eventLoop();
                }

                @Override
                protected Runnable schedulingRunnable(Runnable runnable) {
                    FieldAccessor accessor = ShadedChannelProxy.this.getMessageAccessor(runnable);
                    if (accessor != null) {
                        Runnable result = ShadedChannelProxy.this.onMessageScheduled(runnable, accessor);
                        return result != null ? result : 2.getEmptyRunnable();
                    }
                    return runnable;
                }

                @Override
                protected <T> Callable<T> schedulingCallable(Callable<T> callable) {
                    FieldAccessor accessor = ShadedChannelProxy.this.getMessageAccessor(callable);
                    if (accessor != null) {
                        Callable<T> result = ShadedChannelProxy.this.onMessageScheduled(callable, accessor);
                        return result != null ? result : ShadedEventLoopProxy.getEmptyCallable();
                    }
                    return callable;
                }
            };
        }
        return this.loopProxy;
    }

    private FieldAccessor getMessageAccessor(Object value) {
        Class<?> clazz = value.getClass();
        FieldAccessor accessor = MESSAGE_LOOKUP.get(clazz);
        if (accessor == null) {
            try {
                accessor = Accessors.getFieldAccessor(clazz, this.messageClass, true);
            }
            catch (IllegalArgumentException e) {
                accessor = MARK_NO_MESSAGE;
            }
            MESSAGE_LOOKUP.put(clazz, accessor);
        }
        return accessor != MARK_NO_MESSAGE ? accessor : null;
    }

    public ChannelFuture connect(SocketAddress paramSocketAddress1, SocketAddress paramSocketAddress2) {
        return this.delegate.connect(paramSocketAddress1, paramSocketAddress2);
    }

    public ChannelProgressivePromise newProgressivePromise() {
        return this.delegate.newProgressivePromise();
    }

    public Channel parent() {
        return this.delegate.parent();
    }

    public ChannelConfig config() {
        return this.delegate.config();
    }

    public ChannelFuture newSucceededFuture() {
        return this.delegate.newSucceededFuture();
    }

    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    public ChannelFuture disconnect() {
        return this.delegate.disconnect();
    }

    public boolean isRegistered() {
        return this.delegate.isRegistered();
    }

    public ChannelFuture newFailedFuture(Throwable paramThrowable) {
        return this.delegate.newFailedFuture(paramThrowable);
    }

    public ChannelFuture close() {
        return this.delegate.close();
    }

    public boolean isActive() {
        return this.delegate.isActive();
    }

    @Deprecated
    public ChannelFuture deregister() {
        return this.delegate.deregister();
    }

    public ChannelPromise voidPromise() {
        return this.delegate.voidPromise();
    }

    public ChannelMetadata metadata() {
        return this.delegate.metadata();
    }

    public ChannelFuture bind(SocketAddress paramSocketAddress, ChannelPromise paramChannelPromise) {
        return this.delegate.bind(paramSocketAddress, paramChannelPromise);
    }

    public SocketAddress localAddress() {
        return this.delegate.localAddress();
    }

    public SocketAddress remoteAddress() {
        return this.delegate.remoteAddress();
    }

    public ChannelFuture connect(SocketAddress paramSocketAddress, ChannelPromise paramChannelPromise) {
        return this.delegate.connect(paramSocketAddress, paramChannelPromise);
    }

    public ChannelFuture closeFuture() {
        return this.delegate.closeFuture();
    }

    public boolean isWritable() {
        return this.delegate.isWritable();
    }

    public Channel flush() {
        return this.delegate.flush();
    }

    public ChannelFuture connect(SocketAddress paramSocketAddress1, SocketAddress paramSocketAddress2, ChannelPromise paramChannelPromise) {
        return this.delegate.connect(paramSocketAddress1, paramSocketAddress2, paramChannelPromise);
    }

    public Channel read() {
        return this.delegate.read();
    }

    public Channel.Unsafe unsafe() {
        return this.delegate.unsafe();
    }

    public ChannelFuture disconnect(ChannelPromise paramChannelPromise) {
        return this.delegate.disconnect(paramChannelPromise);
    }

    public ChannelFuture close(ChannelPromise paramChannelPromise) {
        return this.delegate.close(paramChannelPromise);
    }

    @Deprecated
    public ChannelFuture deregister(ChannelPromise paramChannelPromise) {
        return this.delegate.deregister(paramChannelPromise);
    }

    public ChannelFuture write(Object paramObject) {
        return this.delegate.write(paramObject);
    }

    public ChannelFuture write(Object paramObject, ChannelPromise paramChannelPromise) {
        return this.delegate.write(paramObject, paramChannelPromise);
    }

    public ChannelFuture writeAndFlush(Object paramObject, ChannelPromise paramChannelPromise) {
        return this.delegate.writeAndFlush(paramObject, paramChannelPromise);
    }

    public ChannelFuture writeAndFlush(Object paramObject) {
        return this.delegate.writeAndFlush(paramObject);
    }

    public int compareTo(Channel o) {
        return this.delegate.compareTo((Object)o);
    }
}

