/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.compat.netty.shaded;

import com.comphenix.protocol.compat.netty.NettyCompat;
import com.comphenix.protocol.compat.netty.ProtocolInjector;
import com.comphenix.protocol.compat.netty.WrappedByteBuf;
import com.comphenix.protocol.compat.netty.shaded.ShadedByteBuf;
import com.comphenix.protocol.compat.netty.shaded.ShadedByteBufAdapter;
import com.comphenix.protocol.compat.netty.shaded.ShadedProtocolInjector;
import com.comphenix.protocol.error.ErrorReporter;
import com.comphenix.protocol.injector.ListenerInvoker;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.WrappedServerPing;
import com.google.common.base.Charsets;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import net.minecraft.util.io.netty.buffer.ByteBuf;
import net.minecraft.util.io.netty.buffer.Unpooled;
import net.minecraft.util.io.netty.buffer.UnpooledByteBufAllocator;
import net.minecraft.util.io.netty.channel.ChannelHandlerContext;
import net.minecraft.util.io.netty.handler.codec.base64.Base64;
import net.minecraft.util.io.netty.util.concurrent.GenericFutureListener;
import org.bukkit.plugin.Plugin;

public class ShadedNetty
implements NettyCompat {
    @Override
    public WrappedByteBuf createPacketBuffer() {
        ByteBuf buffer = UnpooledByteBufAllocator.DEFAULT.buffer();
        Class<?> packetSerializer = MinecraftReflection.getPacketDataSerializerClass();
        try {
            return new ShadedByteBuf((ByteBuf)packetSerializer.getConstructor(ByteBuf.class).newInstance(buffer));
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot construct packet serializer.", e);
        }
    }

    @Override
    public Class<?> getGenericFutureListenerArray() {
        return GenericFutureListener[].class;
    }

    @Override
    public Class<?> getChannelHandlerContext() {
        return ChannelHandlerContext.class;
    }

    @Override
    public String toEncodedText(WrappedServerPing.CompressedImage image) {
        ByteBuf buffer = Unpooled.wrappedBuffer((byte[])image.getDataCopy());
        String computed = "data:" + image.getMime() + ";base64," + Base64.encode((ByteBuf)buffer).toString(Charsets.UTF_8);
        return computed;
    }

    @Override
    public WrappedByteBuf decode(byte[] encoded) {
        return new ShadedByteBuf(Base64.decode((ByteBuf)Unpooled.wrappedBuffer((byte[])encoded)));
    }

    @Override
    public ProtocolInjector getProtocolInjector(Plugin plugin, ListenerInvoker invoker, ErrorReporter reporter) {
        return new ShadedProtocolInjector(plugin, invoker, reporter);
    }

    @Override
    public WrappedByteBuf packetReader(DataInputStream input) {
        return new ShadedByteBuf(ShadedByteBufAdapter.packetReader(input));
    }

    @Override
    public WrappedByteBuf packetWriter(DataOutputStream output) {
        return new ShadedByteBuf(ShadedByteBufAdapter.packetWriter(output));
    }

    @Override
    public WrappedByteBuf copiedBuffer(byte[] array) {
        return new ShadedByteBuf(Unpooled.copiedBuffer((byte[])array));
    }

    @Override
    public WrappedByteBuf buffer() {
        return new ShadedByteBuf(Unpooled.buffer());
    }
}

