/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector.player;

import com.google.common.base.Objects;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

class ReplacedArrayList<TKey>
extends ArrayList<TKey> {
    private static final long serialVersionUID = 1008492765999744804L;
    private BiMap<TKey, TKey> replaceMap = HashBiMap.create();
    private List<TKey> underlyingList;

    public ReplacedArrayList(List<TKey> underlyingList) {
        this.underlyingList = underlyingList;
    }

    protected void onReplacing(TKey inserting, TKey replacement) {
    }

    protected void onInserting(TKey inserting) {
    }

    protected void onRemoved(TKey removing) {
    }

    @Override
    public boolean add(TKey element) {
        this.onInserting(element);
        if (this.replaceMap.containsKey(element)) {
            Object replacement = this.replaceMap.get(element);
            this.onReplacing(element, replacement);
            return this.delegate().add(replacement);
        }
        return this.delegate().add(element);
    }

    @Override
    public void add(int index, TKey element) {
        this.onInserting(element);
        if (this.replaceMap.containsKey(element)) {
            Object replacement = this.replaceMap.get(element);
            this.onReplacing(element, replacement);
            this.delegate().add(index, replacement);
        } else {
            this.delegate().add(index, element);
        }
    }

    @Override
    public boolean addAll(Collection<? extends TKey> collection) {
        int oldSize = this.size();
        for (TKey element : collection) {
            this.add(element);
        }
        return this.size() != oldSize;
    }

    @Override
    public boolean addAll(int index, Collection<? extends TKey> elements) {
        int oldSize = this.size();
        for (TKey element : elements) {
            this.add(index++, element);
        }
        return this.size() != oldSize;
    }

    @Override
    public boolean remove(Object object) {
        boolean success = this.delegate().remove(object);
        if (success) {
            this.onRemoved(object);
        }
        return success;
    }

    @Override
    public TKey remove(int index) {
        TKey removed = this.delegate().remove(index);
        if (removed != null) {
            this.onRemoved(removed);
        }
        return removed;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        int oldSize = this.size();
        for (Object element : collection) {
            this.remove(element);
        }
        return this.size() != oldSize;
    }

    protected List<TKey> delegate() {
        return this.underlyingList;
    }

    @Override
    public void clear() {
        for (TKey element : this.delegate()) {
            this.onRemoved(element);
        }
        this.delegate().clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate().contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.delegate().containsAll(c);
    }

    @Override
    public TKey get(int index) {
        return this.delegate().get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.delegate().indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.delegate().isEmpty();
    }

    @Override
    public Iterator<TKey> iterator() {
        return this.delegate().iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.delegate().lastIndexOf(o);
    }

    @Override
    public ListIterator<TKey> listIterator() {
        return this.delegate().listIterator();
    }

    @Override
    public ListIterator<TKey> listIterator(int index) {
        return this.delegate().listIterator(index);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        int oldSize = this.size();
        Iterator<TKey> it = this.delegate().iterator();
        while (it.hasNext()) {
            TKey current = it.next();
            if (c.contains(current)) continue;
            it.remove();
            this.onRemoved(current);
        }
        return this.size() != oldSize;
    }

    @Override
    public TKey set(int index, TKey element) {
        if (this.replaceMap.containsKey(element)) {
            Object replacement = this.replaceMap.get(element);
            this.onReplacing(element, replacement);
            return (TKey)this.delegate().set(index, replacement);
        }
        return this.delegate().set(index, element);
    }

    @Override
    public int size() {
        return this.delegate().size();
    }

    @Override
    public List<TKey> subList(int fromIndex, int toIndex) {
        return this.delegate().subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.delegate().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.delegate().toArray(a);
    }

    public synchronized void addMapping(TKey target, TKey replacement) {
        this.addMapping(target, replacement, false);
    }

    public TKey getMapping(TKey target) {
        return (TKey)this.replaceMap.get(target);
    }

    public synchronized void addMapping(TKey target, TKey replacement, boolean ignoreExisting) {
        this.replaceMap.put(target, replacement);
        if (!ignoreExisting) {
            this.replaceAll(target, replacement);
        }
    }

    public synchronized TKey removeMapping(TKey target) {
        if (this.replaceMap.containsKey(target)) {
            Object replacement = this.replaceMap.get(target);
            this.replaceMap.remove(target);
            this.replaceAll(replacement, target);
            return (TKey)replacement;
        }
        return null;
    }

    public synchronized TKey swapMapping(TKey target) {
        TKey replacement = this.removeMapping(target);
        if (replacement != null) {
            this.replaceMap.put(replacement, target);
        }
        return replacement;
    }

    public synchronized void replaceAll(TKey find, TKey replace) {
        for (int i = 0; i < this.underlyingList.size(); ++i) {
            if (!Objects.equal(this.underlyingList.get(i), find)) continue;
            this.onReplacing(find, replace);
            this.underlyingList.set(i, replace);
        }
    }

    public synchronized void revertAll() {
        if (this.replaceMap.size() < 1) {
            return;
        }
        BiMap inverse = this.replaceMap.inverse();
        for (int i = 0; i < this.underlyingList.size(); ++i) {
            TKey replaced = this.underlyingList.get(i);
            if (!inverse.containsKey(replaced)) continue;
            Object original = inverse.get(replaced);
            this.onReplacing(replaced, original);
            this.underlyingList.set(i, original);
        }
        this.replaceMap.clear();
    }

    protected void finalize() throws Throwable {
        this.revertAll();
        super.finalize();
    }
}

