/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.utility;

import com.google.common.base.Preconditions;
import java.io.IOException;

public class HexDumper {
    private static final char[] HEX_DIGITS = "0123456789ABCDEF".toCharArray();
    private int positionLength = 6;
    private char[] positionSuffix = ": ".toCharArray();
    private char[] delimiter = " ".toCharArray();
    private int groupLength = 2;
    private int groupCount = 24;
    private char[] lineDelimiter = "\n".toCharArray();

    public static HexDumper defaultDumper() {
        return new HexDumper();
    }

    public HexDumper lineDelimiter(String lineDelimiter) {
        this.lineDelimiter = ((String)Preconditions.checkNotNull((Object)lineDelimiter, (Object)"lineDelimiter cannot be NULL")).toCharArray();
        return this;
    }

    public HexDumper positionLength(int positionLength) {
        if (positionLength < 0) {
            throw new IllegalArgumentException("positionLength cannot be less than zero.");
        }
        if (positionLength > 8) {
            throw new IllegalArgumentException("positionLength cannot be greater than eight.");
        }
        this.positionLength = positionLength;
        return this;
    }

    public HexDumper positionSuffix(String positionSuffix) {
        this.positionSuffix = ((String)Preconditions.checkNotNull((Object)positionSuffix, (Object)"positionSuffix cannot be NULL")).toCharArray();
        return this;
    }

    public HexDumper delimiter(String delimiter) {
        this.delimiter = ((String)Preconditions.checkNotNull((Object)delimiter, (Object)"delimiter cannot be NULL")).toCharArray();
        return this;
    }

    public HexDumper groupLength(int groupLength) {
        if (groupLength < 1) {
            throw new IllegalArgumentException("groupLength cannot be less than one.");
        }
        this.groupLength = groupLength;
        return this;
    }

    public HexDumper groupCount(int groupCount) {
        if (groupCount < 1) {
            throw new IllegalArgumentException("groupCount cannot be less than one.");
        }
        this.groupCount = groupCount;
        return this;
    }

    public void appendTo(Appendable appendable, byte[] data) throws IOException {
        this.appendTo(appendable, data, 0, data.length);
    }

    public void appendTo(Appendable appendable, byte[] data, int start, int length) throws IOException {
        StringBuilder output = new StringBuilder();
        this.appendTo(output, data, start, length);
        appendable.append(output.toString());
    }

    public void appendTo(StringBuilder builder, byte[] data) {
        this.appendTo(builder, data, 0, data.length);
    }

    public void appendTo(StringBuilder builder, byte[] data, int start, int length) {
        int dataIndex = start;
        int dataEnd = start + length;
        int groupCounter = 0;
        int currentGroupLength = 0;
        int value = 0;
        boolean highNiblet = true;
        while (dataIndex < dataEnd || !highNiblet) {
            if (groupCounter == 0 && currentGroupLength == 0) {
                for (int i = this.positionLength - 1; i >= 0; --i) {
                    builder.append(HEX_DIGITS[dataIndex >>> 4 * i & 0xF]);
                }
                builder.append(this.positionSuffix);
            }
            if (highNiblet) {
                value = data[dataIndex++] & 0xFF;
                builder.append(HEX_DIGITS[value >>> 4]);
            } else {
                builder.append(HEX_DIGITS[value & 0xF]);
            }
            boolean bl = highNiblet = !highNiblet;
            if (++currentGroupLength < this.groupLength) continue;
            currentGroupLength = 0;
            if (++groupCounter >= this.groupCount) {
                builder.append(this.lineDelimiter);
                groupCounter = 0;
                continue;
            }
            builder.append(this.delimiter);
        }
    }

    public int getLineLength(int byteCount) {
        int constant = this.positionLength + this.positionSuffix.length + this.lineDelimiter.length;
        int groups = Math.min(2 * byteCount / this.groupLength, this.groupCount);
        return constant + this.delimiter.length * (groups - 1) + this.groupLength * groups;
    }
}

