/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.utility;

import com.comphenix.net.sf.cglib.proxy.Enhancer;
import com.comphenix.net.sf.cglib.proxy.MethodInterceptor;
import com.comphenix.net.sf.cglib.proxy.MethodProxy;
import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.compat.netty.Netty;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.utility.EnhancerFactory;
import com.comphenix.protocol.utility.MinecraftReflection;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;

public class MinecraftMethods {
    private static volatile Method sendPacketMethod;
    private static volatile Method networkManagerHandle;
    private static volatile Method networkManagerPacketRead;
    private static volatile Method packetReadByteBuf;
    private static volatile Method packetWriteByteBuf;

    public static Method getSendPacketMethod() {
        if (sendPacketMethod == null) {
            Class<?> serverHandlerClass = MinecraftReflection.getPlayerConnectionClass();
            try {
                sendPacketMethod = FuzzyReflection.fromClass(serverHandlerClass).getMethodByName("sendPacket.*");
            }
            catch (IllegalArgumentException e) {
                if (MinecraftReflection.isUsingNetty()) {
                    sendPacketMethod = FuzzyReflection.fromClass(serverHandlerClass).getMethodByParameters("sendPacket", MinecraftReflection.getPacketClass());
                    return sendPacketMethod;
                }
                Map<String, Method> netServer = MinecraftMethods.getMethodList(serverHandlerClass, MinecraftReflection.getPacketClass());
                Map<String, Method> netHandler = MinecraftMethods.getMethodList(MinecraftReflection.getNetHandlerClass(), MinecraftReflection.getPacketClass());
                for (String methodName : netHandler.keySet()) {
                    netServer.remove(methodName);
                }
                if (netServer.size() == 1) {
                    Method[] methods = netServer.values().toArray(new Method[0]);
                    sendPacketMethod = methods[0];
                }
                throw new IllegalArgumentException("Unable to find the sendPacket method in NetServerHandler/PlayerConnection.");
            }
        }
        return sendPacketMethod;
    }

    public static Method getDisconnectMethod(Class<? extends Object> playerConnection) {
        try {
            return FuzzyReflection.fromClass(playerConnection).getMethodByName("disconnect.*");
        }
        catch (IllegalArgumentException e) {
            return FuzzyReflection.fromObject(playerConnection).getMethodByParameters("disconnect", String.class);
        }
    }

    public static Method getNetworkManagerHandleMethod() {
        if (networkManagerHandle == null) {
            networkManagerHandle = FuzzyReflection.fromClass(MinecraftReflection.getNetworkManagerClass(), true).getMethodByParameters("handle", MinecraftReflection.getPacketClass(), Netty.getGenericFutureListenerArray());
            networkManagerHandle.setAccessible(true);
        }
        return networkManagerHandle;
    }

    public static Method getNetworkManagerReadPacketMethod() {
        if (networkManagerPacketRead == null) {
            networkManagerPacketRead = FuzzyReflection.fromClass(MinecraftReflection.getNetworkManagerClass(), true).getMethodByParameters("packetRead", Netty.getChannelHandlerContext(), MinecraftReflection.getPacketClass());
            networkManagerPacketRead.setAccessible(true);
        }
        return networkManagerPacketRead;
    }

    private static Map<String, Method> getMethodList(Class<?> source, Class<?> ... params) {
        FuzzyReflection reflect = FuzzyReflection.fromClass(source, true);
        return reflect.getMappedMethods(reflect.getMethodListByParameters(Void.TYPE, params));
    }

    public static Method getPacketReadByteBufMethod() {
        MinecraftMethods.initializePacket();
        return packetReadByteBuf;
    }

    public static Method getPacketWriteByteBufMethod() {
        MinecraftMethods.initializePacket();
        return packetWriteByteBuf;
    }

    private static void initializePacket() {
        if (packetReadByteBuf == null || packetWriteByteBuf == null) {
            Enhancer enhancer = EnhancerFactory.getInstance().createEnhancer();
            enhancer.setSuperclass(MinecraftReflection.getPacketDataSerializerClass());
            enhancer.setCallback(new MethodInterceptor(){

                @Override
                public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
                    if (method.getName().contains("read")) {
                        throw new ReadMethodException();
                    }
                    if (method.getName().contains("write")) {
                        throw new WriteMethodException();
                    }
                    return proxy.invokeSuper(obj, args);
                }
            });
            Object javaProxy = enhancer.create(new Class[]{MinecraftReflection.getByteBufClass()}, new Object[]{Netty.buffer().getHandle()});
            Object lookPacket = new PacketContainer(PacketType.Play.Client.CLOSE_WINDOW).getHandle();
            List<Method> candidates = FuzzyReflection.fromClass(MinecraftReflection.getPacketClass()).getMethodListByParameters(Void.TYPE, new Class[]{MinecraftReflection.getPacketDataSerializerClass()});
            for (Method method : candidates) {
                try {
                    method.invoke(lookPacket, javaProxy);
                }
                catch (InvocationTargetException e) {
                    if (e.getCause() instanceof ReadMethodException) {
                        packetReadByteBuf = method;
                        continue;
                    }
                    if (!(e.getCause() instanceof WriteMethodException)) continue;
                    packetWriteByteBuf = method;
                }
                catch (Exception e) {
                    throw new RuntimeException("Generic reflection error.", e);
                }
            }
            if (packetReadByteBuf == null) {
                throw new IllegalStateException("Unable to find Packet.read(PacketDataSerializer)");
            }
            if (packetWriteByteBuf == null) {
                throw new IllegalStateException("Unable to find Packet.write(PacketDataSerializer)");
            }
        }
    }

    private static class WriteMethodException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public WriteMethodException() {
            super("A write method was executed.");
        }
    }

    private static class ReadMethodException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ReadMethodException() {
            super("A read method was executed.");
        }
    }
}

