/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers;

import com.comphenix.protocol.reflect.EquivalentConverter;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.BukkitConverters;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.google.common.base.Objects;
import java.lang.reflect.Constructor;

public class PlayerInfoData {
    private static Constructor<?> constructor;
    protected final WrappedGameProfile profile;
    protected final int ping;
    protected final EnumWrappers.NativeGameMode gameMode;
    protected final WrappedChatComponent displayName;

    public PlayerInfoData(WrappedGameProfile profile, int ping, EnumWrappers.NativeGameMode gameMode, WrappedChatComponent displayName) {
        this.ping = ping;
        this.gameMode = gameMode;
        this.profile = profile;
        this.displayName = displayName;
    }

    public WrappedGameProfile getProfile() {
        return this.profile;
    }

    public int getPing() {
        return this.ping;
    }

    public EnumWrappers.NativeGameMode getGameMode() {
        return this.gameMode;
    }

    public WrappedChatComponent getDisplayName() {
        return this.displayName;
    }

    public static EquivalentConverter<PlayerInfoData> getConverter() {
        return new EquivalentConverter<PlayerInfoData>(){

            @Override
            public Object getGeneric(Class<?> genericType, PlayerInfoData specific) {
                if (constructor == null) {
                    try {
                        constructor = MinecraftReflection.getPlayerInfoDataClass().getConstructor(MinecraftReflection.getMinecraftClass("PacketPlayOutPlayerInfo"), MinecraftReflection.getGameProfileClass(), Integer.TYPE, EnumWrappers.getGameModeClass(), MinecraftReflection.getIChatBaseComponentClass());
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Cannot find PlayerInfoData constructor.", e);
                    }
                }
                try {
                    Object result = constructor.newInstance(null, specific.profile.handle, specific.ping, EnumWrappers.getGameModeConverter().getGeneric(EnumWrappers.getGameModeClass(), specific.gameMode), specific.displayName != null ? specific.displayName.handle : null);
                    return result;
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to construct PlayerInfoData.", e);
                }
            }

            @Override
            public PlayerInfoData getSpecific(Object generic) {
                if (MinecraftReflection.isPlayerInfoData(generic)) {
                    StructureModifier modifier = new StructureModifier(generic.getClass(), null, false).withTarget(generic);
                    StructureModifier<WrappedGameProfile> gameProfiles = modifier.withType(MinecraftReflection.getGameProfileClass(), BukkitConverters.getWrappedGameProfileConverter());
                    WrappedGameProfile gameProfile = gameProfiles.read(0);
                    StructureModifier ints = modifier.withType(Integer.TYPE);
                    int ping = (Integer)ints.read(0);
                    StructureModifier<EnumWrappers.NativeGameMode> gameModes = modifier.withType(EnumWrappers.getGameModeClass(), EnumWrappers.getGameModeConverter());
                    EnumWrappers.NativeGameMode gameMode = gameModes.read(0);
                    StructureModifier<WrappedChatComponent> displayNames = modifier.withType(MinecraftReflection.getIChatBaseComponentClass(), BukkitConverters.getWrappedChatComponentConverter());
                    WrappedChatComponent displayName = displayNames.read(0);
                    return new PlayerInfoData(gameProfile, ping, gameMode, displayName);
                }
                return null;
            }

            @Override
            public Class<PlayerInfoData> getSpecificType() {
                return PlayerInfoData.class;
            }
        };
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof PlayerInfoData) {
            PlayerInfoData other = (PlayerInfoData)obj;
            return this.profile.equals(other.profile) && this.ping == other.ping && this.gameMode == other.gameMode && this.displayName.equals(other.displayName);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.profile, this.ping, this.gameMode, this.displayName});
    }

    public String toString() {
        return String.format("PlayerInfoData { profile=%s, ping=%s, gameMode=%s, displayName=%s }", new Object[]{this.profile, this.ping, this.gameMode, this.displayName});
    }
}

