/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers.nbt;

import com.comphenix.protocol.reflect.FieldAccessException;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.nbt.NameProperty;
import com.comphenix.protocol.wrappers.nbt.NbtBase;
import com.comphenix.protocol.wrappers.nbt.NbtFactory;
import com.comphenix.protocol.wrappers.nbt.NbtType;
import com.comphenix.protocol.wrappers.nbt.NbtVisitor;
import com.comphenix.protocol.wrappers.nbt.NbtWrapper;
import com.comphenix.protocol.wrappers.nbt.io.NbtBinarySerializer;
import com.google.common.base.Objects;
import java.io.DataOutput;
import java.lang.reflect.Method;

class WrappedElement<TType>
implements NbtWrapper<TType> {
    private static volatile Method methodGetTypeID;
    private static volatile Method methodClone;
    private static volatile Boolean hasNbtName;
    private static StructureModifier<?>[] modifiers;
    private Object handle;
    private NbtType type;
    private NameProperty nameProperty;

    public WrappedElement(Object handle) {
        this.handle = handle;
        this.initializeProperty();
    }

    public WrappedElement(Object handle, String name) {
        this.handle = handle;
        this.initializeProperty();
        this.setName(name);
    }

    private void initializeProperty() {
        if (this.nameProperty == null) {
            Class<?> base = MinecraftReflection.getNBTBaseClass();
            if (hasNbtName == null) {
                hasNbtName = NameProperty.hasStringIndex(base, 0);
            }
            this.nameProperty = hasNbtName != false ? NameProperty.fromStringIndex(base, this.handle, 0) : NameProperty.fromBean();
        }
    }

    protected StructureModifier<TType> getCurrentModifier() {
        NbtType type = this.getType();
        return this.getCurrentBaseModifier().withType(type.getValueType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StructureModifier<Object> getCurrentBaseModifier() {
        int index = this.getType().ordinal();
        StructureModifier<Object> modifier = modifiers[index];
        if (modifier == null) {
            WrappedElement wrappedElement = this;
            synchronized (wrappedElement) {
                if (modifiers[index] == null) {
                    WrappedElement.modifiers[index] = new StructureModifier(this.handle.getClass(), MinecraftReflection.getNBTBaseClass(), false);
                }
                modifier = modifiers[index];
            }
        }
        return modifier;
    }

    @Override
    public boolean accept(NbtVisitor visitor) {
        return visitor.visit(this);
    }

    @Override
    public Object getHandle() {
        return this.handle;
    }

    @Override
    public NbtType getType() {
        if (methodGetTypeID == null) {
            methodGetTypeID = FuzzyReflection.fromClass(MinecraftReflection.getNBTBaseClass()).getMethodByParameters("getTypeID", (Class<?>)Byte.TYPE, (Class<?>[])new Class[0]);
        }
        if (this.type == null) {
            try {
                this.type = NbtType.getTypeFromID(((Byte)methodGetTypeID.invoke(this.handle, new Object[0])).byteValue());
            }
            catch (Exception e) {
                throw new FieldAccessException("Cannot get NBT type of " + this.handle, e);
            }
        }
        return this.type;
    }

    public NbtType getSubType() {
        byte subID = (Byte)this.getCurrentBaseModifier().withType(Byte.TYPE).withTarget(this.handle).read(0);
        return NbtType.getTypeFromID(subID);
    }

    public void setSubType(NbtType type) {
        byte subID = (byte)type.getRawID();
        this.getCurrentBaseModifier().withType(Byte.TYPE).withTarget(this.handle).write(0, subID);
    }

    @Override
    public String getName() {
        return this.nameProperty.getName();
    }

    @Override
    public void setName(String name) {
        this.nameProperty.setName(name);
    }

    @Override
    public TType getValue() {
        return this.getCurrentModifier().withTarget(this.handle).read(0);
    }

    @Override
    public void setValue(TType newValue) {
        this.getCurrentModifier().withTarget(this.handle).write(0, newValue);
    }

    @Override
    public void write(DataOutput destination) {
        NbtBinarySerializer.DEFAULT.serialize(this, destination);
    }

    @Override
    public NbtBase<TType> deepClone() {
        if (methodClone == null) {
            Class<?> base = MinecraftReflection.getNBTBaseClass();
            methodClone = FuzzyReflection.fromClass(base).getMethodByParameters("clone", base, (Class<?>[])new Class[0]);
        }
        try {
            return NbtFactory.fromNMS(methodClone.invoke(this.handle, new Object[0]), this.getName());
        }
        catch (Exception e) {
            throw new FieldAccessException("Unable to clone " + this.handle, e);
        }
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getName(), this.getType(), this.getValue()});
    }

    public boolean equals(Object obj) {
        NbtBase other;
        if (obj instanceof NbtBase && (other = (NbtBase)obj).getType().equals((Object)this.getType())) {
            return Objects.equal(this.getValue(), other.getValue());
        }
        return false;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        String name = this.getName();
        result.append("{");
        if (name != null && name.length() > 0) {
            result.append("name: '" + name + "', ");
        }
        result.append("value: ");
        if (this.getType() == NbtType.TAG_STRING) {
            result.append("'" + this.getValue() + "'");
        } else {
            result.append(this.getValue());
        }
        result.append("}");
        return result.toString();
    }

    static {
        modifiers = new StructureModifier[NbtType.values().length];
    }
}

