/*
 * Decompiled with CFR 0.152.
 */
package craftingdead.client.renderers;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import craftingdead.items.interfaces.ItemPart;
import craftingdead.items.interfaces.ItemScope;
import craftingdead.items.interfaces.ItemWeapon;
import craftingdead.utils.GunHelper;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderItemWeapon
implements IItemRenderer {
    public static final ResourceLocation gunMetal = new ResourceLocation("craftingdead", "textures/models/gun_metal.png");
    public static final RenderItemWeapon instance = new RenderItemWeapon();

    private RenderItemWeapon() {
    }

    public static void RegisterWeapon(ItemWeapon weapon) {
        MinecraftForgeClient.registerItemRenderer((Item)weapon, (IItemRenderer)instance);
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack stack, Object ... data) {
        if (stack == null || !(stack.func_77973_b() instanceof ItemWeapon)) {
            return;
        }
        ItemWeapon weapon = (ItemWeapon)stack.func_77973_b();
        Vec3 handle = weapon.HandlePos();
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON || type == IItemRenderer.ItemRenderType.EQUIPPED) {
            EntityLivingBase entity = (EntityLivingBase)data[1];
            if (type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
                if (entity.func_70093_af()) {
                    this.ResetToZero();
                    GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    ItemStack sight = GunHelper.getPart(stack, GunHelper.PartType.SIGHTRAIL);
                    if (sight != null && sight.func_77973_b() instanceof ItemScope) {
                        ItemScope scope = (ItemScope)sight.func_77973_b();
                        scope.RenderScope();
                        GL11.glPopMatrix();
                        return;
                    }
                    weapon.IronSightOffset();
                } else {
                    GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)-25.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glTranslated((double)0.5, (double)-0.125, (double)0.5);
                    if (entity.func_70051_ag()) {
                        GL11.glRotatef((float)60.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    }
                }
            } else {
                GL11.glTranslated((double)0.5, (double)0.0, (double)0.0);
                GL11.glRotatef((float)15.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                if (entity.func_70051_ag() && weapon.ModelSize() >= 40.0f) {
                    GL11.glRotatef((float)60.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
            }
            GL11.glTranslated((double)handle.field_72450_a, (double)handle.field_72448_b, (double)handle.field_72449_c);
            this.RenderGunBasic(weapon, stack);
        } else if (type == IItemRenderer.ItemRenderType.ENTITY) {
            EntityItem entity = (EntityItem)data[1];
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            if (entity.field_70173_aa >= 1) {
                GL11.glRotatef((float)entity.field_70177_z, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            this.RenderGunBasic(weapon, stack);
        } else if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            float size = weapon.ModelSize();
            ItemStack barrel = GunHelper.getPart(stack, GunHelper.PartType.SUPPRESSOR);
            double bOff = 0.0;
            if (barrel != null && barrel.func_77973_b() instanceof ItemPart) {
                float bl = ((ItemPart)barrel.func_77973_b()).ModelSize();
                size += bl;
                bOff = (double)bl / 2.0 * 0.3;
            }
            size = Math.max(0.01f, size);
            float slotDiag = 20.0f;
            float scale = slotDiag * (slotDiag / size);
            GL11.glTranslated((double)(8.0 + (bOff /= (double)scale)), (double)(8.0 + bOff), (double)8.0);
            GL11.glScalef((float)(-scale), (float)(-scale), (float)(-scale));
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)-45.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            this.RenderGunBasic(weapon, stack);
        }
        GL11.glPopMatrix();
    }

    public void RenderGunBasic(ItemWeapon weapon, ItemStack stack) {
        ItemPart part;
        Vec3 offset;
        float scale = weapon.ModelScale();
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        Color baseCol = GunHelper.getTint(stack);
        GL11.glColor4f((float)((float)baseCol.getRed() / 255.0f), (float)((float)baseCol.getGreen() / 255.0f), (float)((float)baseCol.getBlue() / 255.0f), (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(gunMetal);
        weapon.ItemModel().renderAll();
        if (stack.func_77978_p() != null) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            NBTTagList list = stack.func_77978_p().func_150295_c("Camos", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound tag = list.func_150305_b(i);
                Color c = new Color(tag.func_74762_e("COLOR"));
                GL11.glColor4f((float)((float)c.getRed() / 255.0f), (float)((float)c.getGreen() / 255.0f), (float)((float)c.getBlue() / 255.0f), (float)1.0f);
                Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation(tag.func_74779_i("TEX")));
                weapon.ItemModel().renderAll();
            }
            GL11.glDisable((int)3042);
        }
        GL11.glScalef((float)(1.0f / scale), (float)(1.0f / scale), (float)(1.0f / scale));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (weapon.SupportsPartType(GunHelper.PartType.SIGHTRAIL)) {
            offset = weapon.SightRail();
            ItemStack partStack = GunHelper.getPart(stack, GunHelper.PartType.SIGHTRAIL);
            if (partStack != null && offset != null) {
                GL11.glPushMatrix();
                GL11.glTranslated((double)offset.field_72450_a, (double)offset.field_72448_b, (double)offset.field_72449_c);
                part = (ItemPart)partStack.func_77973_b();
                scale = part.ModelScale();
                GL11.glScalef((float)scale, (float)scale, (float)scale);
                Minecraft.func_71410_x().field_71446_o.func_110577_a(part.ModelTexture());
                part.ItemModel().renderAll();
                GL11.glPopMatrix();
            }
        }
        if (weapon.SupportsPartType(GunHelper.PartType.SUPPRESSOR)) {
            offset = weapon.BarrelTip();
            ItemStack partStack = GunHelper.getPart(stack, GunHelper.PartType.SUPPRESSOR);
            if (partStack != null && offset != null) {
                GL11.glPushMatrix();
                GL11.glTranslated((double)offset.field_72450_a, (double)offset.field_72448_b, (double)offset.field_72449_c);
                part = (ItemPart)partStack.func_77973_b();
                scale = part.ModelScale();
                GL11.glScalef((float)scale, (float)scale, (float)scale);
                Minecraft.func_71410_x().field_71446_o.func_110577_a(part.ModelTexture());
                part.ItemModel().renderAll();
                GL11.glPopMatrix();
            }
        }
        if (weapon.SupportsPartType(GunHelper.PartType.UNDERRAIL)) {
            offset = weapon.UnderRail();
            ItemStack partStack = GunHelper.getPart(stack, GunHelper.PartType.UNDERRAIL);
            if (partStack != null && offset != null) {
                GL11.glPushMatrix();
                GL11.glTranslated((double)offset.field_72450_a, (double)offset.field_72448_b, (double)offset.field_72449_c);
                part = (ItemPart)partStack.func_77973_b();
                scale = part.ModelScale();
                GL11.glScalef((float)scale, (float)scale, (float)scale);
                Minecraft.func_71410_x().field_71446_o.func_110577_a(part.ModelTexture());
                part.ItemModel().renderAll();
                GL11.glPopMatrix();
            }
        }
        if (weapon.ModelTexture() != null) {
            GL11.glPushMatrix();
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            scale = weapon.ModelScale();
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(weapon.ModelTexture());
            weapon.ItemModel().renderAll();
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
        }
    }

    public void ResetToZero() {
        GL11.glTranslatef((float)0.9375f, (float)0.0625f, (float)0.0f);
        GL11.glRotatef((float)-335.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)-50.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)0.3f, (float)0.0f);
        GL11.glRotatef((float)-45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)0.56f, (float)-1.12f, (float)-0.71999997f);
        GL11.glTranslated((double)-1.49, (double)1.885, (double)0.0);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
    }
}

