/*
 * Decompiled with CFR 0.152.
 */
package craftingdead.client.renderers;

import craftingdead.trackers.SkinTracker;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.RenderZombie;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class RenderZombieWalker
extends RenderZombie {
    private static final ResourceLocation baseSkin;
    static ArrayList<ResourceLocation> layerDetail;
    static ArrayList<ResourceLocation> layerShirt;
    static ArrayList<ResourceLocation> layerPants;
    ResourceLocation curTex = null;
    int curLayer = 0;
    Random rand = new Random();

    public void func_76986_a(EntityZombie zombie, double x, double y, double z, float p_76986_8_, float partialTick) {
        SkinTracker tracker = SkinTracker.GetTracker((EntityLivingBase)zombie);
        this.rand.setSeed(tracker == null ? 0L : tracker.seed);
        GL11.glPushMatrix();
        if (this.initLayer(zombie, 0)) {
            super.func_76986_a(zombie, x, y, z, p_76986_8_, partialTick);
        }
        if (layerPants.size() > 0 && this.initLayer(zombie, 1)) {
            super.func_76986_a(zombie, x, y, z, p_76986_8_, partialTick);
        }
        if (layerShirt.size() > 0 && this.initLayer(zombie, 2)) {
            super.func_76986_a(zombie, x, y, z, p_76986_8_, partialTick);
        }
        if (layerDetail.size() > 0 && this.initLayer(zombie, 3)) {
            super.func_76986_a(zombie, x, y, z, p_76986_8_, partialTick);
        }
        GL11.glPopMatrix();
    }

    private boolean initLayer(EntityZombie zombie, int layer) {
        this.curLayer = layer;
        if (layer == 0) {
            this.curTex = baseSkin;
        } else if (layer == 1 && layerPants.size() > 0) {
            int i = this.rand.nextInt(layerPants.size());
            this.curTex = layerPants.get(i);
        } else if (layer == 2 && layerShirt.size() > 0) {
            int i = this.rand.nextInt(layerShirt.size() + 1);
            this.curTex = i >= layerShirt.size() ? null : layerShirt.get(i);
        } else if (layer == 3 && layerDetail.size() > 0) {
            int i = this.rand.nextInt(layerDetail.size());
            this.curTex = layerDetail.get(i);
        } else {
            this.curTex = null;
        }
        return this.curTex != null;
    }

    protected ResourceLocation func_110775_a(EntityZombie zombie) {
        if (this.curLayer == 0) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Color c = Color.getHSBColor(0.08f, 0.27f, 0.25f + this.rand.nextFloat() * 0.75f);
            GL11.glColor4f((float)((float)c.getRed() / 255.0f), (float)((float)c.getGreen() / 255.0f), (float)((float)c.getBlue() / 255.0f), (float)1.0f);
        } else if (this.curLayer < 3) {
            Color c = Color.getHSBColor(this.rand.nextFloat(), 0.25f + this.rand.nextFloat() * 0.75f, 0.25f + this.rand.nextFloat() * 0.75f);
            GL11.glColor4f((float)((float)c.getRed() / 255.0f), (float)((float)c.getGreen() / 255.0f), (float)((float)c.getBlue() / 255.0f), (float)1.0f);
        }
        return this.curTex;
    }

    static {
        ResourceLocation res;
        baseSkin = new ResourceLocation("craftingdead", "textures/entity/biped/base_skin.png");
        layerDetail = new ArrayList();
        layerShirt = new ArrayList();
        layerPants = new ArrayList();
        layerDetail.clear();
        layerShirt.clear();
        layerPants.clear();
        int i = 0;
        while (true) {
            res = new ResourceLocation("craftingdead", "textures/entity/biped/detail/zombie/detail" + i + ".png");
            try {
                if (res == null) break;
                if (Minecraft.func_71410_x().func_110442_L().func_110536_a(res) == null) {
                }
            }
            catch (Exception e) {}
            break;
            layerDetail.add(res);
            ++i;
        }
        i = 0;
        while (true) {
            res = new ResourceLocation("craftingdead", "textures/entity/biped/clothes/shirt" + i + ".png");
            try {
                if (res == null) break;
                if (Minecraft.func_71410_x().func_110442_L().func_110536_a(res) == null) {
                }
            }
            catch (Exception e) {}
            break;
            layerShirt.add(res);
            ++i;
        }
        i = 0;
        while (true) {
            res = new ResourceLocation("craftingdead", "textures/entity/biped/clothes/pants" + i + ".png");
            try {
                if (res == null) break;
                if (Minecraft.func_71410_x().func_110442_L().func_110536_a(res) == null) {
                }
            }
            catch (Exception e) {}
            break;
            layerPants.add(res);
            ++i;
        }
        System.out.println("Found " + layerDetail.size() + " detail, " + layerShirt.size() + " shirt and " + layerPants.size() + " pant layers");
    }
}

