/*
 * Decompiled with CFR 0.152.
 */
package craftingdead.core;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import craftingdead.blocks.BlockBarbedWire;
import craftingdead.blocks.BlockLootPile;
import craftingdead.blocks.BlockSpawnMarker;
import craftingdead.blocks.tileentity.TileEntityLootPile;
import craftingdead.blocks.tileentity.TileEntitySpawnMarker;
import craftingdead.core.CreativeTabCraftingDead;
import craftingdead.core.CreativeTabFoods;
import craftingdead.core.CreativeTabMaterials;
import craftingdead.core.proxies.CommonProxy;
import craftingdead.entities.EntityItemLoot;
import craftingdead.entities.EntityZombieWalker;
import craftingdead.handlers.ConfigHandler;
import craftingdead.items.ItemLootEditor;
import craftingdead.items.ItemMakeBuilding;
import craftingdead.items.ItemRecBuilding;
import craftingdead.items.clothing.ItemClothesGeneric;
import craftingdead.items.interfaces.ItemClip;
import craftingdead.items.interfaces.ItemPart;
import craftingdead.items.interfaces.ItemScope;
import craftingdead.items.interfaces.ItemWeapon;
import craftingdead.items.loot.ItemCanOpener;
import craftingdead.items.loot.ItemCannedFood;
import craftingdead.items.loot.ItemFoodBar;
import craftingdead.items.loot.ItemFoodPacket;
import craftingdead.items.loot.ItemJuiceBox;
import craftingdead.items.loot.ItemSodaCan;
import craftingdead.items.loot.ItemSprayPaint;
import craftingdead.items.loot.ItemWaterBottle;
import craftingdead.items.loot.ItemWireCutters;
import craftingdead.items.weapons.ItemM4A1;
import craftingdead.items.weapons.ItemM82A1;
import craftingdead.items.weapons.ItemM9;
import craftingdead.items.weapons.ItemSPAS12;
import craftingdead.items.weapons.clips.ItemClip44mm;
import craftingdead.items.weapons.clips.ItemClip50BMG;
import craftingdead.items.weapons.clips.ItemClip9mm;
import craftingdead.items.weapons.clips.ItemRound12Gauge;
import craftingdead.items.weapons.melee.ItemFireAxe;
import craftingdead.items.weapons.melee.ItemGenericMelee;
import craftingdead.items.weapons.parts.ItemACOG;
import craftingdead.items.weapons.parts.ItemGrip;
import craftingdead.items.weapons.parts.ItemScope4X;
import craftingdead.items.weapons.parts.ItemSuppressor;
import craftingdead.network.PacketCraftingDead;
import craftingdead.world.CityGenerator;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.MaterialTransparent;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.Logger;

@Mod(modid="craftingdead", version="0.0.10", name="The Crafting Dead", guiFactory="craftingdead.handlers.ConfigGuiFactory")
public class CraftingDead {
    public static final String MODID = "craftingdead";
    public static final String VERSION = "0.0.10";
    public static final String NAME = "The Crafting Dead";
    public static final String PROXY = "craftingdead.core.proxies";
    public static final String CHANNEL = "CRAFT_DEAD_CHAN";
    @Mod.Instance(value="craftingdead")
    public static CraftingDead instance;
    @SidedProxy(clientSide="craftingdead.core.proxies.ClientProxy", serverSide="craftingdead.core.proxies.CommonProxy")
    public static CommonProxy proxy;
    public SimpleNetworkWrapper network;
    public static Logger logger;
    public static CreativeTabs mainTab;
    public static CreativeTabs foodTab;
    public static CreativeTabs materialTab;
    public static MaterialTransparent marker;
    public static Block lootPile;
    public static Block spawnMarker;
    public static Item lootEditor;
    public static Block barbedWire;
    public static Item wireCutters;
    public static ItemSprayPaint itemPaint;
    public static Item waterBottle;
    public static Item canOpener;
    public static Item nails;
    public static ItemWeapon gunM4A1;
    public static ItemWeapon gunSPAS12;
    public static ItemWeapon gunM9;
    public static ItemWeapon gunM82A1;
    public static ItemScope partACOG;
    public static ItemScope partScope4x;
    public static ItemPart partGrip;
    public static ItemPart partSuppressor;
    public static ItemClip clip44mm;
    public static ItemClip round12Gauge;
    public static ItemClip clip9mm;
    public static ItemClip clip50bmg;
    public static Item fireAxe;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        this.network = NetworkRegistry.INSTANCE.newSimpleChannel(CHANNEL);
        this.network.registerMessage(PacketCraftingDead.HandleClient.class, PacketCraftingDead.class, 0, Side.CLIENT);
        this.network.registerMessage(PacketCraftingDead.HandleServer.class, PacketCraftingDead.class, 1, Side.SERVER);
        ConfigHandler.config = new Configuration(event.getSuggestedConfigurationFile(), true);
        ConfigHandler.initConfigs();
        proxy.registerHandlers();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        GameRegistry.registerBlock((Block)lootPile, (String)"loot_pile");
        GameRegistry.registerTileEntity(TileEntityLootPile.class, (String)"tile_loot_pile");
        GameRegistry.registerBlock((Block)spawnMarker, (String)"spawn_marker");
        GameRegistry.registerTileEntity(TileEntitySpawnMarker.class, (String)"tile_spawn_marker");
        GameRegistry.registerBlock((Block)barbedWire, (String)"barbed_wire");
        GameRegistry.registerItem((Item)wireCutters, (String)"wire_cutters");
        GameRegistry.registerItem((Item)lootEditor, (String)"loot_editor");
        GameRegistry.registerItem((Item)gunM4A1, (String)"gun_m4a1");
        GameRegistry.registerItem((Item)gunSPAS12, (String)"gun_spas12");
        GameRegistry.registerItem((Item)gunM9, (String)"gun_m9");
        GameRegistry.registerItem((Item)gunM82A1, (String)"gun_m82a1");
        GameRegistry.registerItem((Item)clip44mm, (String)"clip_nato44");
        gunM4A1.addSupportedClip(clip44mm);
        GameRegistry.registerItem((Item)round12Gauge, (String)"round_12gauge");
        gunSPAS12.addSupportedClip(round12Gauge);
        GameRegistry.registerItem((Item)clip9mm, (String)"clip_9mm");
        gunM9.addSupportedClip(clip9mm);
        GameRegistry.registerItem((Item)clip50bmg, (String)"clip_50bmg");
        gunM82A1.addSupportedClip(clip50bmg);
        GameRegistry.registerItem((Item)partACOG, (String)"part_acog");
        GameRegistry.registerItem((Item)partScope4x, (String)"part_scope_4x");
        GameRegistry.registerItem((Item)partGrip, (String)"part_grip");
        GameRegistry.registerItem((Item)partSuppressor, (String)"part_suppressor");
        GameRegistry.registerItem((Item)itemPaint, (String)"spray_paint");
        GameRegistry.registerItem((Item)waterBottle, (String)"water_bottle");
        GameRegistry.registerItem((Item)canOpener, (String)"can_opener");
        GameRegistry.registerItem((Item)nails, (String)"nails");
        GameRegistry.registerItem((Item)fireAxe, (String)"fire_axe");
        GameRegistry.registerItem((Item)new ItemRecBuilding(), (String)"rec_building");
        GameRegistry.registerItem((Item)new ItemMakeBuilding(), (String)"make_building");
        ItemGenericMelee.InitMelee();
        ItemCannedFood.InitCans();
        ItemFoodPacket.InitPackets();
        ItemFoodBar.InitBars();
        ItemJuiceBox.InitJuiceBoxes();
        ItemSodaCan.InitSodas();
        ItemClothesGeneric.InitClothing();
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)ItemGenericMelee.nailedBat), (Object[])new Object[]{new ItemStack((Item)ItemGenericMelee.baseballBat), new ItemStack(nails)});
        int eID = EntityRegistry.findGlobalUniqueEntityId();
        EntityRegistry.registerGlobalEntityID(EntityItemLoot.class, (String)"item_loot", (int)eID);
        EntityRegistry.registerModEntity(EntityItemLoot.class, (String)"item_loot", (int)eID, (Object)this, (int)64, (int)1, (boolean)true);
        eID = EntityRegistry.findGlobalUniqueEntityId();
        EntityRegistry.registerGlobalEntityID(EntityZombieWalker.class, (String)"zombie_walker", (int)eID);
        EntityRegistry.registerModEntity(EntityZombieWalker.class, (String)"zombie_walker", (int)eID, (Object)this, (int)64, (int)1, (boolean)true);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.registerRenderers();
        CityGenerator.LoadBuildings();
    }

    static {
        mainTab = new CreativeTabCraftingDead();
        foodTab = new CreativeTabFoods();
        materialTab = new CreativeTabMaterials();
        marker = new MaterialTransparent(MapColor.field_151660_b);
        lootPile = new BlockLootPile();
        spawnMarker = new BlockSpawnMarker();
        lootEditor = new ItemLootEditor();
        barbedWire = new BlockBarbedWire();
        wireCutters = new ItemWireCutters();
        itemPaint = new ItemSprayPaint();
        waterBottle = new ItemWaterBottle();
        canOpener = new ItemCanOpener();
        nails = new Item().func_111206_d("craftingdead:nails").func_77655_b("craftingdead.nails").func_77637_a(materialTab);
        gunM4A1 = new ItemM4A1();
        gunSPAS12 = new ItemSPAS12();
        gunM9 = new ItemM9();
        gunM82A1 = new ItemM82A1();
        partACOG = new ItemACOG();
        partScope4x = new ItemScope4X();
        partGrip = new ItemGrip();
        partSuppressor = new ItemSuppressor();
        clip44mm = new ItemClip44mm();
        round12Gauge = new ItemRound12Gauge();
        clip9mm = new ItemClip9mm();
        clip50bmg = new ItemClip50BMG();
        fireAxe = new ItemFireAxe();
    }
}

