/*
 * Decompiled with CFR 0.152.
 */
package craftingdead.handlers;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import craftingdead.client.KeyBindings;
import craftingdead.core.CD_Settings;
import craftingdead.core.CraftingDead;
import craftingdead.entities.EntityItemLoot;
import craftingdead.entities.EntityZombieWalker;
import craftingdead.handlers.ConfigHandler;
import craftingdead.items.interfaces.ItemScope;
import craftingdead.items.interfaces.ItemWeapon;
import craftingdead.network.PacketCraftingDead;
import craftingdead.trackers.SkinTracker;
import craftingdead.trackers.StatusTracker;
import craftingdead.utils.AuxUtilities;
import craftingdead.utils.GunHelper;
import craftingdead.utils.HackTracker;
import craftingdead.world.CityGenerator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.event.world.WorldEvent;

public class EventHandler {
    float mSpeedCache = -1.0f;
    boolean edited = false;

    @SubscribeEvent
    public void onPlayerClick(PlayerInteractEvent event) {
        StatusTracker statTrack = StatusTracker.GetTracker(event.entityPlayer);
        if (statTrack != null) {
            ++statTrack.clicks;
        }
        if (Math.abs(event.entityPlayer.field_70759_as - event.entityPlayer.field_70758_at) >= 30.0f && event.entityPlayer instanceof EntityPlayerMP) {
            HackTracker.instance.FlagAimBot((EntityPlayerMP)event.entityPlayer);
            return;
        }
        if (event.action == PlayerInteractEvent.Action.LEFT_CLICK_BLOCK) {
            return;
        }
        if (CraftingDead.proxy.isClient() && event.entityPlayer.field_70170_p.field_72995_K) {
            MovingObjectPosition mop = AuxUtilities.RayCastEntity((EntityLivingBase)event.entityPlayer, 2.5);
            Entity entity = mop.field_72308_g;
            if (entity instanceof EntityItemLoot) {
                NBTTagCompound tags = new NBTTagCompound();
                tags.func_74768_a("ID", 0);
                tags.func_74768_a("EntityID", entity.func_145782_y());
                CraftingDead.instance.network.sendToServer((IMessage)new PacketCraftingDead(tags));
                event.setCanceled(true);
                return;
            }
        }
        ItemStack stack = event.entityPlayer.func_70694_bm();
        if (!event.entityPlayer.field_70170_p.field_72995_K && stack != null && stack.func_77973_b() instanceof ItemWeapon && statTrack != null) {
            statTrack.firing = true;
        }
    }

    @SubscribeEvent
    public void onEntityJoin(EntityJoinWorldEvent event) {
        if (event.world.field_72995_K) {
            return;
        }
        if (event.entity.getClass() == EntityItem.class) {
            event.setCanceled(true);
            EntityItemLoot loot = new EntityItemLoot((EntityItem)event.entity);
            event.world.func_72838_d((Entity)loot);
            event.entity.func_70106_y();
            return;
        }
        if (event.entity instanceof IMob && !(event.entity instanceof EntityZombieWalker)) {
            if (event.entity instanceof EntityZombie && (CD_Settings.walkersOnly || event.world.field_73012_v.nextBoolean())) {
                EntityZombieWalker walker = new EntityZombieWalker(event.world);
                walker.func_70107_b(event.entity.field_70165_t, event.entity.field_70163_u, event.entity.field_70161_v);
                event.entity.field_70170_p.func_72838_d((Entity)walker);
                event.setCanceled(true);
                event.entity.func_70106_y();
            } else if (CD_Settings.walkersOnly) {
                event.setCanceled(true);
                event.entity.func_70106_y();
            }
        }
    }

    @SubscribeEvent
    public void onEntityConstruct(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityZombieWalker || event.entity instanceof EntityPlayer) {
            SkinTracker.RegisterTracker((EntityLivingBase)event.entity);
            if (event.entity instanceof EntityPlayer) {
                StatusTracker.RegisterTracker((EntityPlayer)event.entity);
            }
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityPlayer player;
        StatusTracker statTrack;
        if (event.entity.field_70170_p.field_72995_K) {
            return;
        }
        SkinTracker tracker = SkinTracker.GetTracker(event.entityLiving);
        if (tracker != null && (event.entity.field_70173_aa == 1 || event.entity.field_70173_aa % 1200 == 0)) {
            NBTTagCompound tags = new NBTTagCompound();
            NBTTagCompound trackTag = new NBTTagCompound();
            tracker.saveNBTData(trackTag);
            tags.func_74768_a("ID", 1);
            tags.func_74768_a("EntityID", event.entity.func_145782_y());
            tags.func_74782_a("Tracker", (NBTBase)trackTag);
            PacketCraftingDead packet = new PacketCraftingDead(tags);
            CraftingDead.instance.network.sendToAllAround((IMessage)packet, new NetworkRegistry.TargetPoint(event.entity.field_71093_bK, event.entity.field_70165_t, event.entity.field_70163_u, event.entity.field_70161_v, 64.0));
        }
        if (event.entityLiving instanceof EntityPlayer && (statTrack = StatusTracker.GetTracker(player = (EntityPlayer)event.entityLiving)) != null) {
            statTrack.onUpdate(player);
            if (!player.field_70170_p.field_72995_K) {
                ItemStack stack = player.func_70694_bm();
                if (stack != null && stack.func_77973_b() instanceof ItemWeapon && player.field_71070_bA == player.field_71069_bz) {
                    if (stack.func_77978_p() == null) {
                        stack.func_77982_d(new NBTTagCompound());
                    }
                    if (statTrack.firing || GunHelper.GetMode(stack) == GunHelper.FireMode.BURST && stack.func_77978_p().func_74762_e("Burst") > 0) {
                        ItemWeapon weapon = (ItemWeapon)stack.func_77973_b();
                        weapon.onTriggerTick(player, stack);
                    }
                } else {
                    statTrack.firing = false;
                }
            }
        }
    }

    @SubscribeEvent
    public void onExplode(ExplosionEvent.Detonate event) {
        if (event.world.field_72995_K) {
            return;
        }
        double ex = event.explosion.field_77284_b;
        double ey = event.explosion.field_77285_c;
        double ez = event.explosion.field_77282_d;
        AxisAlignedBB bounds = AxisAlignedBB.func_72330_a((double)ex, (double)ey, (double)ez, (double)ex, (double)ey, (double)ez);
        List walkers = event.world.func_72872_a(EntityZombieWalker.class, bounds.func_72314_b(64.0, 64.0, 64.0));
        for (EntityZombieWalker zomb : walkers) {
            if (!zomb.func_70661_as().func_75500_f() || zomb.func_70777_m() != null) continue;
            zomb.func_70661_as().func_75484_a(zomb.func_70661_as().func_75488_a(ex, ey, ez), 1.0);
            zomb.func_70690_d(new PotionEffect(Potion.field_76424_c.field_76415_H, 600, 1, true));
        }
    }

    @SubscribeEvent
    public void onPopulate(PopulateChunkEvent.Pre event) {
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (!event.world.field_72995_K && !MinecraftServer.func_71276_C().func_71278_l()) {
            CityGenerator.cities.clear();
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        NBTTagCompound tag;
        if (KeyBindings.mode.func_151468_f()) {
            tag = new NBTTagCompound();
            tag.func_74768_a("ID", 5);
            CraftingDead.instance.network.sendToServer((IMessage)new PacketCraftingDead(tag));
        }
        if (KeyBindings.reload.func_151468_f()) {
            tag = new NBTTagCompound();
            tag.func_74768_a("ID", 4);
            CraftingDead.instance.network.sendToServer((IMessage)new PacketCraftingDead(tag));
        }
        if (KeyBindings.editor.func_151468_f()) {
            tag = new NBTTagCompound();
            tag.func_74768_a("ID", 3);
            CraftingDead.instance.network.sendToServer((IMessage)new PacketCraftingDead(tag));
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onMouseInput(InputEvent.MouseInputEvent event) {
        if (!Minecraft.func_71410_x().field_71474_y.field_74313_G.func_151470_d()) {
            NBTTagCompound tags = new NBTTagCompound();
            tags.func_74768_a("ID", 6);
            CraftingDead.instance.network.sendToServer((IMessage)new PacketCraftingDead(tags));
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPlayerRender(RenderPlayerEvent.Pre event) {
        ItemWeapon wep;
        if (event.entityPlayer.func_70694_bm() != null && event.entityPlayer.func_70694_bm().func_77973_b() instanceof ItemWeapon && ((wep = GunHelper.GetItemWeapon(event.entityPlayer.func_70694_bm())).ModelSize() >= 40.0f || !event.entityPlayer.func_70051_ag())) {
            event.renderer.field_77109_a.field_78118_o = true;
            event.renderer.field_77111_i.field_78118_o = true;
            event.renderer.field_77108_b.field_78118_o = true;
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onGuiRender(RenderGameOverlayEvent.Post event) {
        if (event.type != RenderGameOverlayEvent.ElementType.HELMET) {
            return;
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void FOVEvent(FOVUpdateEvent event) {
        ItemStack stack = event.entity.func_70694_bm();
        if (this.mSpeedCache != -1.0f && event.entity.func_70093_af() && stack != null && stack.func_77973_b() instanceof ItemWeapon) {
            ItemStack part = GunHelper.getPart(stack, GunHelper.PartType.SIGHTRAIL);
            event.newfov = part != null && part.func_77973_b() instanceof ItemScope ? ((ItemScope)part.func_77973_b()).ZoomFOV() : 0.75f;
            Minecraft.func_71410_x().field_71474_y.field_74341_c = event.newfov * 0.5f;
            this.edited = true;
        } else if (this.edited) {
            Minecraft.func_71410_x().field_71474_y.field_74341_c = this.mSpeedCache;
            this.edited = false;
        } else {
            this.mSpeedCache = Minecraft.func_71410_x().field_71474_y.field_74341_c;
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals("craftingdead")) {
            ConfigHandler.config.save();
            ConfigHandler.initConfigs();
        }
    }
}

