/*
 * Decompiled with CFR 0.152.
 */
package craftingdead.items;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import craftingdead.core.CraftingDead;
import craftingdead.utils.NBTConverter;
import java.io.FileWriter;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;

public class ItemRecBuilding
extends Item {
    public ItemRecBuilding() {
        this.func_77655_b("craftingdead.rec_building");
        this.func_77637_a(CraftingDead.mainTab);
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (player.func_70093_af() || stack.func_77978_p().func_74764_b("World") && stack.func_77978_p().func_74762_e("World") != world.field_73011_w.field_76574_g) {
            stack.func_77982_d(new NBTTagCompound());
            player.func_146105_b((IChatComponent)new ChatComponentText("Reset selection"));
        } else if (!stack.func_77978_p().func_74764_b("P1")) {
            NBTTagCompound pointTag = new NBTTagCompound();
            pointTag.func_74768_a("x", MathHelper.func_76128_c((double)player.field_70165_t));
            pointTag.func_74768_a("y", MathHelper.func_76128_c((double)(player.field_70163_u - 1.0)));
            pointTag.func_74768_a("z", MathHelper.func_76128_c((double)player.field_70161_v));
            stack.func_77978_p().func_74782_a("P1", (NBTBase)pointTag);
            stack.func_77978_p().func_74768_a("World", world.field_73011_w.field_76574_g);
            player.func_146105_b((IChatComponent)new ChatComponentText("Position 1 set"));
        } else {
            NBTTagCompound pointTag = stack.func_77978_p().func_74775_l("P1");
            int x1 = pointTag.func_74762_e("x");
            int y1 = pointTag.func_74762_e("y");
            int z1 = pointTag.func_74762_e("z");
            player.func_146105_b((IChatComponent)new ChatComponentText("Saving..."));
            this.SaveBuilding(world, x1, y1, z1, MathHelper.func_76128_c((double)player.field_70165_t), MathHelper.func_76128_c((double)(player.field_70163_u - 1.0)), MathHelper.func_76128_c((double)player.field_70161_v));
            stack.func_77982_d(new NBTTagCompound());
            player.func_146105_b((IChatComponent)new ChatComponentText("Done"));
        }
        return true;
    }

    public void SaveBuilding(World world, int x1, int y1, int z1, int x2, int y2, int z2) {
        int sx = Math.min(x1, x2);
        int sy = Math.min(y1, y2);
        int sz = Math.min(z1, z2);
        int ex = Math.max(x1, x2);
        int ey = Math.max(y1, y2);
        int ez = Math.max(z1, z2);
        JsonObject base = new JsonObject();
        JsonArray blockMap = new JsonArray();
        JsonArray metaMap = new JsonArray();
        JsonArray tileMap = new JsonArray();
        base.addProperty("Rotation", (Number)0);
        base.addProperty("SizeX", (Number)(ex - sx + 1));
        base.addProperty("SizeY", (Number)(ey - sy + 1));
        base.addProperty("SizeZ", (Number)(ez - sz + 1));
        for (int i = sx; i <= ex; ++i) {
            for (int j = sy; j <= ey; ++j) {
                for (int k = sz; k <= ez; ++k) {
                    Block block = world.func_147439_a(i, j, k);
                    String id = Block.field_149771_c.func_148750_c((Object)block);
                    int meta = world.func_72805_g(i, j, k);
                    TileEntity tile = world.func_147438_o(i, j, k);
                    blockMap.add((JsonElement)new JsonPrimitive(id));
                    metaMap.add((JsonElement)new JsonPrimitive((Number)meta));
                    if (tile != null) {
                        NBTTagCompound tileTags = new NBTTagCompound();
                        tile.func_145841_b(tileTags);
                        tileMap.add((JsonElement)NBTConverter.NBTtoJSON_Compound(tileTags, new JsonObject()));
                        continue;
                    }
                    JsonObject n = new JsonObject();
                    tileMap.add((JsonElement)n);
                }
            }
        }
        JsonArray repeat = new JsonArray();
        repeat.add((JsonElement)new JsonPrimitive((Number)0));
        repeat.add((JsonElement)new JsonPrimitive((Number)0));
        repeat.add((JsonElement)new JsonPrimitive((Number)0));
        base.addProperty("Rotation", (Number)15);
        base.add("Repeat", (JsonElement)repeat);
        base.add("Blocks", (JsonElement)blockMap);
        base.add("Metadata", (JsonElement)metaMap);
        base.add("Tiles", (JsonElement)tileMap);
        Gson g = new GsonBuilder().setPrettyPrinting().create();
        try {
            FileWriter fw = new FileWriter(MinecraftServer.func_71276_C().func_71209_f("last_building.json"));
            g.toJson((JsonElement)base, (Appendable)fw);
            fw.flush();
            fw.close();
        }
        catch (Exception e) {
            CraftingDead.logger.log(Level.ERROR, "Failed to save building to json", (Throwable)e);
        }
    }
}

