/*
 * Decompiled with CFR 0.152.
 */
package craftingdead.items.interfaces;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import craftingdead.items.interfaces.IItemModel;
import craftingdead.items.interfaces.ItemClip;
import craftingdead.items.interfaces.ItemPart;
import craftingdead.utils.GunHelper;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public abstract class ItemWeapon
extends Item
implements IItemModel {
    protected ArrayList<ItemClip> supportedClips = new ArrayList();

    public ItemWeapon() {
        this.func_77625_d(1);
        this.func_111206_d("diamond_sword");
    }

    public void onTriggerTick(EntityPlayer player, ItemStack stack) {
        if (!player.field_70170_p.field_72995_K) {
            player.func_70031_b(false);
            GunHelper.FireBullet((EntityLivingBase)player, stack);
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean held) {
        if (!world.field_72995_K && entity instanceof EntityPlayer) {
            int reload;
            EntityPlayer player = (EntityPlayer)entity;
            ItemWeapon wep = GunHelper.GetItemWeapon(stack);
            if (wep == null) {
                return;
            }
            if (stack.func_77978_p() == null) {
                stack.func_77982_d(new NBTTagCompound());
            }
            if ((reload = stack.func_77978_p().func_74762_e("Reload")) > 0) {
                --reload;
                int clipSlot = GunHelper.getFirstValidClip(wep, (IInventory)player.field_71071_by);
                if (clipSlot < 0 || !held) {
                    stack.func_77978_p().func_74768_a("Reload", 0);
                    return;
                }
                stack.func_77978_p().func_74768_a("Reload", reload);
                if (reload <= 0) {
                    ItemStack clip = player.field_71071_by.func_70301_a(clipSlot).func_77946_l();
                    clip.field_77994_a = 1;
                    if (GunHelper.loadClip(player, stack, clip)) {
                        player.field_71071_by.func_70298_a(clipSlot, 1);
                        player.field_71069_bz.func_75142_b();
                        ItemStack newClip = GunHelper.getClip(stack);
                        if (newClip != null && newClip.field_77994_a < this.ClipCapacity() && GunHelper.getFirstValidClip(wep, (IInventory)player.field_71071_by) >= 0) {
                            GunHelper.SetReloading(player, stack);
                        }
                    }
                }
            }
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        ItemStack clip = GunHelper.getClip(stack);
        if (clip != null) {
            if (this.ClipCapacity() > 1) {
                return 1.0 - (double)clip.field_77994_a / (double)this.ClipCapacity();
            }
            return (double)clip.func_77952_i() / (double)clip.func_77958_k();
        }
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74762_e("Reload") > 0) {
            return (double)stack.func_77978_p().func_74762_e("Reload") / (double)this.ReloadTicks();
        }
        return 1.0;
    }

    public final void addSupportedClip(ItemClip clip) {
        if (!this.supportedClips.contains((Object)clip)) {
            this.supportedClips.add(clip);
        }
    }

    public final boolean supportsClip(ItemClip clip) {
        return this.supportedClips.contains((Object)clip);
    }

    public abstract int RPM();

    public abstract int ReloadTicks();

    public abstract GunHelper.FireMode DefaultMode();

    public boolean SupportsMode(GunHelper.FireMode mode) {
        return mode == this.DefaultMode() || mode == GunHelper.FireMode.SAFETY;
    }

    public int ClipCapacity() {
        return 1;
    }

    public int BurstSize() {
        return 3;
    }

    public abstract Color defColor();

    public String SoundFire() {
        return "craftingdead:pistol.fire";
    }

    public String SoundReloadStart() {
        return "random.click";
    }

    public String SoundReloadEnd() {
        return "random.click";
    }

    public boolean SupportsPartType(GunHelper.PartType type) {
        return false;
    }

    public boolean SupportsPart(ItemStack stack) {
        if (stack == null || !(stack.func_77973_b() instanceof ItemPart)) {
            return false;
        }
        ItemPart part = (ItemPart)stack.func_77973_b();
        return this.SupportsPartType(part.GetType());
    }

    @SideOnly(value=Side.CLIENT)
    public abstract Vec3 HandlePos();

    @SideOnly(value=Side.CLIENT)
    public abstract Vec3 BarrelTip();

    public Vec3 SightRail() {
        return null;
    }

    public Vec3 UnderRail() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public abstract void IronSightOffset();
}

