/*
 * Decompiled with CFR 0.152.
 */
package craftingdead.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import craftingdead.blocks.tileentity.TileEntityLootPile;
import craftingdead.core.CraftingDead;
import craftingdead.entities.EntityItemLoot;
import craftingdead.inventory.ContainerWeaponTable;
import craftingdead.trackers.SkinTracker;
import craftingdead.trackers.StatusTracker;
import craftingdead.utils.GunHelper;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import org.apache.logging.log4j.Level;

public class PacketCraftingDead
implements IMessage {
    NBTTagCompound tags = new NBTTagCompound();

    public PacketCraftingDead() {
        this(new NBTTagCompound());
    }

    public PacketCraftingDead(NBTTagCompound tags) {
        this.tags = tags;
    }

    public void fromBytes(ByteBuf buf) {
        this.tags = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        if (CraftingDead.proxy.isClient() && Minecraft.func_71410_x().field_71439_g != null) {
            this.tags.func_74768_a("Dimension", Minecraft.func_71410_x().field_71439_g.field_71093_bK);
            this.tags.func_74778_a("Sender", Minecraft.func_71410_x().field_71439_g.func_110124_au().toString());
        }
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.tags);
    }

    public static class HandleServer
    implements IMessageHandler<PacketCraftingDead, IMessage> {
        public IMessage onMessage(PacketCraftingDead msg, MessageContext ctx) {
            int ID = msg.tags.func_74764_b("ID") ? msg.tags.func_74762_e("ID") : -1;
            WorldServer world = null;
            EntityPlayer player = null;
            boolean approved = false;
            try {
                world = MinecraftServer.func_71276_C().func_71218_a(msg.tags.func_74762_e("Dimension"));
                player = world.func_152378_a(UUID.fromString(msg.tags.func_74779_i("Sender")));
            }
            catch (Exception e) {
                // empty catch block
            }
            boolean bl = approved = world != null && player != null;
            if (ID < 0 || !approved) {
                return null;
            }
            if (ID == 0) {
                Entity entity = world.func_73045_a(msg.tags.func_74762_e("EntityID"));
                if (player != null && entity != null && entity instanceof EntityItemLoot) {
                    ((EntityItemLoot)entity).pickup(player);
                } else {
                    CraftingDead.logger.log(Level.ERROR, "Invalid Pickup Request: Entity not found");
                }
                return null;
            }
            if (ID == 1) {
                TileEntity tile;
                int x = msg.tags.func_74762_e("x");
                int y = msg.tags.func_74762_e("y");
                int z = msg.tags.func_74762_e("z");
                NBTTagCompound tileTag = msg.tags.func_74775_l("tile");
                TileEntity tileEntity = tile = world == null ? null : world.func_147438_o(x, y, z);
                if (tile instanceof TileEntityLootPile) {
                    boolean allow = false;
                    if (player.field_71075_bZ.field_75099_e && player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == CraftingDead.lootEditor) {
                        allow = true;
                    }
                    if (allow) {
                        tile.func_145839_a(tileTag);
                        MinecraftServer.func_71276_C().func_71203_ab().func_148541_a((double)x, (double)y, (double)z, 64.0, world.field_73011_w.field_76574_g, tile.func_145844_m());
                    } else {
                        CraftingDead.logger.log(Level.ERROR, "Loot pile attempted to be edited without permission!");
                        CraftingDead.logger.log(Level.ERROR, "Tile Pos: " + x + "," + y + "," + z);
                    }
                } else {
                    CraftingDead.logger.log(Level.ERROR, "Loot edit failed: Tile or world not found");
                }
            } else {
                StatusTracker statTrack;
                if (ID == 2) {
                    if (!(player.field_71070_bA instanceof ContainerWeaponTable)) {
                        return null;
                    }
                    ((ContainerWeaponTable)player.field_71070_bA).ConfirmPaint();
                    return null;
                }
                if (ID == 3) {
                    player.openGui((Object)CraftingDead.instance, 0, (World)world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
                } else if (ID == 4) {
                    GunHelper.SetReloading(player, player.func_70694_bm());
                } else if (ID == 5) {
                    if (GunHelper.GetItemWeapon(player.func_70694_bm()) != null) {
                        GunHelper.ToggleMode(player.func_70694_bm());
                        GunHelper.FireMode mode = GunHelper.GetMode(player.func_70694_bm());
                        player.func_146105_b((IChatComponent)new ChatComponentText("Fire Mode: " + mode.toString()));
                    }
                } else if (ID == 6 && (statTrack = StatusTracker.GetTracker(player)) != null) {
                    statTrack.firing = false;
                }
            }
            return null;
        }
    }

    public static class HandleClient
    implements IMessageHandler<PacketCraftingDead, IMessage> {
        public IMessage onMessage(PacketCraftingDead message, MessageContext ctx) {
            int ID;
            int n = ID = message.tags.func_74764_b("ID") ? message.tags.func_74762_e("ID") : -1;
            if (ID < 0) {
                return null;
            }
            if (ID == 0) {
                float force = message.tags.func_74760_g("Force");
                EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
                player.field_70726_aT -= 5.0f * force;
                player.field_70125_A -= 5.0f * force;
            } else if (ID == 1) {
                Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.tags.func_74762_e("EntityID"));
                if (entity != null && entity instanceof EntityLivingBase) {
                    SkinTracker tracker = SkinTracker.GetTracker((EntityLivingBase)entity);
                    if (tracker != null) {
                        tracker.loadNBTData(message.tags.func_74775_l("Tracker"));
                    } else {
                        CraftingDead.logger.log(Level.ERROR, "Failed to sync skin: Tracker not found");
                    }
                } else {
                    CraftingDead.logger.log(Level.ERROR, "Failed to sync skin: Entity not found");
                }
                return null;
            }
            return null;
        }
    }
}

