/*
 * Decompiled with CFR 0.152.
 */
package craftingdead.utils;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import craftingdead.core.CraftingDead;
import craftingdead.entities.EntityZombieWalker;
import craftingdead.items.interfaces.ItemClip;
import craftingdead.items.interfaces.ItemPart;
import craftingdead.items.interfaces.ItemWeapon;
import craftingdead.network.PacketCraftingDead;
import craftingdead.utils.AuxUtilities;
import java.awt.Color;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;

public class GunHelper {
    public static ItemWeapon GetItemWeapon(ItemStack stack) {
        if (stack == null || !(stack.func_77973_b() instanceof ItemWeapon)) {
            return null;
        }
        return (ItemWeapon)stack.func_77973_b();
    }

    public static void FireBullet(EntityLivingBase shooter, ItemStack gun) {
        if (shooter == null) {
            return;
        }
        GunHelper.FireBullet(shooter, gun, shooter.func_70676_i(1.0f));
    }

    public static void FireBullet(EntityLivingBase shooter, ItemStack gun, Vec3 direction) {
        ItemWeapon wep = GunHelper.GetItemWeapon(gun);
        if (wep == null || shooter == null || gun == null || shooter.field_70170_p.field_72995_K) {
            return;
        }
        if (gun.func_77978_p() == null) {
            gun.func_77982_d(new NBTTagCompound());
        }
        FireMode mode = GunHelper.GetMode(gun);
        int burst = gun.func_77978_p().func_74762_e("Burst");
        int curShot = Math.round((float)shooter.field_70170_p.func_82737_E() % 1200.0f / 1200.0f * (float)wep.RPM());
        int lastShot = gun.func_77978_p().func_74762_e("LastShot");
        int curShotTick = (int)(shooter.field_70170_p.func_82737_E() % 12000L);
        int lastShotTick = gun.func_77978_p().func_74762_e("LastShotTick");
        if (lastShot == curShot) {
            gun.func_77978_p().func_74768_a("LastShotTick", curShotTick);
            return;
        }
        if ((mode == FireMode.SAFETY || mode == FireMode.SEMI || mode == FireMode.BURST && burst <= 0) && Math.abs(curShotTick - lastShotTick) <= 2) {
            gun.func_77978_p().func_74768_a("LastShotTick", curShotTick);
            return;
        }
        gun.func_77978_p().func_74768_a("LastShot", curShot);
        gun.func_77978_p().func_74768_a("LastShotTick", curShotTick);
        if (mode == FireMode.SAFETY) {
            shooter.field_70170_p.func_72956_a((Entity)shooter, "random.click", 0.5f, 1.5f);
            return;
        }
        ItemStack clipStack = GunHelper.getClip(gun);
        if (burst > 0) {
            gun.func_77978_p().func_74768_a("Burst", burst - 1);
        } else {
            gun.func_77978_p().func_74768_a("Burst", wep.BurstSize() - 1);
        }
        if (clipStack == null || clipStack.field_77994_a <= 0 || clipStack.func_77984_f() && clipStack.func_77960_j() >= clipStack.func_77958_k()) {
            if (shooter instanceof EntityPlayer && GunHelper.getFirstValidClip(wep, (IInventory)((EntityPlayer)shooter).field_71071_by) >= 0) {
                GunHelper.SetReloading((EntityPlayer)shooter, gun);
            } else if (gun.func_77978_p().func_74762_e("Reload") <= 0) {
                shooter.field_70170_p.func_72956_a((Entity)shooter, "random.click", 0.5f, 1.5f);
            }
            return;
        }
        if (gun.func_77978_p().func_74762_e("Reload") >= 0) {
            gun.func_77978_p().func_74768_a("Reload", 0);
        }
        ItemClip clip = (ItemClip)clipStack.func_77973_b();
        float modRecoil = 1.0f;
        float modDamage = 1.0f;
        boolean suppressed = false;
        ItemStack[] part = new ItemStack[]{GunHelper.getPart(gun, PartType.SIGHTRAIL), GunHelper.getPart(gun, PartType.SUPPRESSOR), GunHelper.getPart(gun, PartType.UNDERRAIL)};
        for (ItemStack pStack : part) {
            if (pStack == null) continue;
            ItemPart p = (ItemPart)pStack.func_77973_b();
            modRecoil *= p.RecoilModifier();
            modDamage *= p.DamageModifier();
            if (!p.Silenced()) continue;
            suppressed = true;
        }
        if (GunHelper.useBullet(shooter, gun)) {
            shooter.field_70170_p.func_72956_a((Entity)shooter, wep.SoundFire(), 0.5f, 0.9f + shooter.func_70681_au().nextFloat() * 0.2f);
            if (!suppressed) {
                List walkers = shooter.field_70170_p.func_72872_a(EntityZombieWalker.class, shooter.field_70121_D.func_72314_b(64.0, 64.0, 64.0));
                for (EntityZombieWalker zomb : walkers) {
                    if (zomb.func_70777_m() != null) continue;
                    zomb.func_70661_as().func_75484_a(zomb.func_70661_as().func_75488_a(shooter.field_70165_t, shooter.field_70163_u, shooter.field_70161_v), 1.0);
                    zomb.func_70690_d(new PotionEffect(Potion.field_76424_c.field_76415_H, 600, 1, true));
                }
            }
            for (int i = 0; i < clip.BulletsPerShot(); ++i) {
                Entity entity;
                float xOff = shooter.func_70681_au().nextFloat() * clip.BulletError() - clip.BulletError() / 2.0f;
                float zOff = shooter.func_70681_au().nextFloat() * clip.BulletError() - clip.BulletError() / 2.0f;
                direction.func_72440_a(xOff);
                direction.func_72446_c(zOff);
                MovingObjectPosition mop = AuxUtilities.RayCastEntity(shooter, clip.FireDistance(), direction);
                Entity entity2 = entity = mop == null ? null : mop.field_72308_g;
                if (entity != null && entity instanceof EntityLivingBase) {
                    boolean headShot = Math.abs((double)entity.func_70047_e() + entity.field_70163_u - mop.field_72307_f.field_72448_b) < 0.25;
                    entity.field_70172_ad = 0;
                    double mx = entity.field_70159_w;
                    double my = entity.field_70181_x;
                    double mz = entity.field_70179_y;
                    boolean undead = ((EntityLivingBase)entity).func_70668_bt() == EnumCreatureAttribute.UNDEAD;
                    entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)shooter), clip.BulletDamage() * (headShot ? 2.0f : 1.0f) * (undead ? 0.75f : 1.0f) * modDamage);
                    entity.field_70159_w = mx + (entity.field_70159_w - mx) * (double)clip.GetForce() * (double)modRecoil;
                    entity.field_70181_x = my;
                    entity.field_70179_y = mz + (entity.field_70179_y - mz) * (double)clip.GetForce() * (double)modRecoil;
                }
                if (mop == null) continue;
                clip.OnImpact(shooter, entity, mop.field_72307_f);
            }
            if (shooter instanceof EntityPlayerMP) {
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74768_a("ID", 0);
                tag.func_74776_a("Force", clip.GetForce() * modRecoil);
                CraftingDead.instance.network.sendTo((IMessage)new PacketCraftingDead(tag), (EntityPlayerMP)shooter);
            }
        }
    }

    public static void SetReloading(EntityPlayer player, ItemStack gun) {
        ItemWeapon wep = GunHelper.GetItemWeapon(gun);
        if (wep == null) {
            return;
        }
        if (gun.func_77978_p() == null) {
            gun.func_77982_d(new NBTTagCompound());
        }
        if (gun.func_77978_p().func_74762_e("Reload") <= 0) {
            if (wep.ClipCapacity() <= 1) {
                GunHelper.unloadClip(player, gun);
            }
            gun.func_77978_p().func_74768_a("Reload", wep.ReloadTicks());
        }
    }

    public static int getFirstValidClip(ItemWeapon wep, IInventory invo) {
        int index = -1;
        ItemStack selected = null;
        for (int i = 0; i < invo.func_70302_i_(); ++i) {
            ItemStack stack = invo.func_70301_a(i);
            if (stack == null || !(stack.func_77973_b() instanceof ItemClip) || !wep.supportsClip((ItemClip)stack.func_77973_b()) || stack.func_77984_f() && stack.func_77960_j() >= stack.func_77958_k() || selected != null && selected.func_77960_j() <= stack.func_77960_j()) continue;
            index = i;
            selected = stack;
            if (selected.func_77960_j() > 0) continue;
            return index;
        }
        return index;
    }

    public static boolean useBullet(EntityLivingBase entity, ItemStack gun) {
        if (gun == null || gun.func_77978_p() == null || entity == null) {
            return false;
        }
        ItemStack clip = ItemStack.func_77949_a((NBTTagCompound)gun.func_77978_p().func_74775_l("Clip"));
        if (clip != null && clip.func_77973_b() instanceof ItemClip) {
            if (clip.func_77984_f() && clip.func_77960_j() < clip.func_77958_k()) {
                clip.func_96631_a(1, entity.func_70681_au());
                gun.func_77978_p().func_74782_a("Clip", (NBTBase)clip.func_77955_b(new NBTTagCompound()));
                return true;
            }
            if (!clip.func_77984_f()) {
                --clip.field_77994_a;
                if (clip.field_77994_a > 0) {
                    gun.func_77978_p().func_74782_a("Clip", (NBTBase)clip.func_77955_b(new NBTTagCompound()));
                } else {
                    gun.func_77978_p().func_82580_o("Clip");
                }
                return true;
            }
        }
        return false;
    }

    public static ItemStack getClip(ItemStack gun) {
        if (gun.func_77978_p() == null) {
            return null;
        }
        ItemStack clip = ItemStack.func_77949_a((NBTTagCompound)gun.func_77978_p().func_74775_l("Clip"));
        if (clip != null && clip.func_77973_b() instanceof ItemClip) {
            return clip;
        }
        return null;
    }

    public static boolean unloadClip(EntityPlayer player, ItemStack gun) {
        ItemWeapon wep = GunHelper.GetItemWeapon(gun);
        if (wep == null || gun.func_77978_p() == null) {
            return true;
        }
        ItemStack clip = GunHelper.getClip(gun);
        if (clip == null) {
            return false;
        }
        if (!player.field_71071_by.func_70441_a(clip = clip.func_77946_l())) {
            player.func_71019_a(clip, false);
        } else {
            player.field_71069_bz.func_75142_b();
        }
        gun.func_77978_p().func_82580_o("Clip");
        player.field_70170_p.func_72956_a((Entity)player, wep.SoundReloadStart(), 1.0f, 1.0f);
        return true;
    }

    public static boolean loadClip(EntityPlayer player, ItemStack gun, ItemStack clip) {
        ItemWeapon wep = GunHelper.GetItemWeapon(gun);
        if (wep == null || gun.func_77978_p() == null) {
            gun.func_77982_d(new NBTTagCompound());
        }
        if (clip == null) {
            return false;
        }
        if (player == null || !(clip.func_77973_b() instanceof ItemClip) || !wep.supportsClip((ItemClip)clip.func_77973_b())) {
            return false;
        }
        ItemStack oldClip = GunHelper.getClip(gun);
        if (oldClip != null) {
            if (oldClip.func_77973_b() == clip.func_77973_b() && !clip.func_77984_f() && clip.field_77994_a + oldClip.field_77994_a <= wep.ClipCapacity()) {
                clip.field_77994_a += oldClip.field_77994_a;
            } else {
                return false;
            }
        }
        gun.func_77978_p().func_74782_a("Clip", (NBTBase)clip.func_77955_b(new NBTTagCompound()));
        player.field_70170_p.func_72956_a((Entity)player, wep.SoundReloadEnd(), 1.0f, 1.0f);
        return true;
    }

    public static void ToggleMode(ItemStack stack) {
        ItemWeapon wep = GunHelper.GetItemWeapon(stack);
        if (wep == null) {
            return;
        }
        int i = GunHelper.GetMode(stack).ordinal();
        int j = (i + 1) % FireMode.values().length;
        while (j != i) {
            FireMode mode = FireMode.values()[j];
            if (wep.SupportsMode(mode)) {
                if (stack.func_77978_p() == null) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                stack.func_77978_p().func_74768_a("Mode", j);
                break;
            }
            j = (j + 1) % FireMode.values().length;
        }
    }

    public static FireMode GetMode(ItemStack stack) {
        ItemWeapon wep = GunHelper.GetItemWeapon(stack);
        if (wep == null) {
            return null;
        }
        if (stack.func_77978_p() == null || !stack.func_77978_p().func_74764_b("Mode")) {
            return wep.DefaultMode();
        }
        return FireMode.values()[stack.func_77978_p().func_74762_e("Mode") % FireMode.values().length];
    }

    public static void removePart(ItemStack weapon, PartType type) {
        if (weapon == null || weapon.func_77978_p() == null) {
            return;
        }
        weapon.func_77978_p().func_82580_o(type.toString());
    }

    public static boolean addPart(ItemStack weapon, PartType type, ItemStack part) {
        ItemWeapon wep = GunHelper.GetItemWeapon(weapon);
        if (weapon == null || type == null || part == null || !wep.SupportsPart(part)) {
            return false;
        }
        ItemPart itemPart = (ItemPart)part.func_77973_b();
        if (itemPart.GetType() != type || GunHelper.getPart(weapon, itemPart.GetType()) != null) {
            return false;
        }
        if (weapon.func_77978_p() == null) {
            weapon.func_77982_d(new NBTTagCompound());
        }
        weapon.func_77978_p().func_74782_a(itemPart.GetType().toString(), (NBTBase)part.func_77955_b(new NBTTagCompound()));
        return true;
    }

    public static ItemStack getPart(ItemStack weapon, PartType type) {
        if (weapon == null || type == null || weapon.func_77978_p() == null) {
            return null;
        }
        ItemStack part = ItemStack.func_77949_a((NBTTagCompound)weapon.func_77978_p().func_74775_l(type.toString()));
        if (part == null || !(part.func_77973_b() instanceof ItemPart)) {
            return null;
        }
        return part;
    }

    public static Color getTint(ItemStack stack) {
        ItemWeapon wep = GunHelper.GetItemWeapon(stack);
        if (wep == null) {
            return Color.DARK_GRAY;
        }
        if (stack == null || stack.func_77978_p() == null || !stack.func_77978_p().func_74764_b("TINT")) {
            return wep.defColor();
        }
        Color c = new Color(stack.func_77978_p().func_74762_e("TINT"));
        return c;
    }

    public static void setTint(ItemStack stack, Color c) {
        if (stack == null || c == null) {
            return;
        }
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("TINT", c.getRGB());
    }

    public static void clearCamo(ItemStack stack) {
        if (stack == null || stack.func_77978_p() == null) {
            return;
        }
        stack.func_77978_p().func_82580_o("Camos");
    }

    public static void addCamo(ItemStack stack, String res, Color c) {
        if (stack == null || res == null || c == null || res.length() <= 0) {
            return;
        }
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound camo = new NBTTagCompound();
        camo.func_74768_a("COLOR", c.getRGB());
        camo.func_74778_a("TEX", res);
        NBTTagList list = stack.func_77978_p().func_150295_c("Camos", 10);
        list.func_74742_a((NBTBase)camo);
        stack.func_77978_p().func_74782_a("Camos", (NBTBase)list);
    }

    public static enum PartType {
        SIGHTRAIL,
        SUPPRESSOR,
        UNDERRAIL;

    }

    public static enum FireMode {
        SAFETY,
        SEMI,
        BURST,
        AUTO;

    }
}

