/*
 * Decompiled with CFR 0.152.
 */
package craftingdead.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import craftingdead.core.CraftingDead;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import org.apache.logging.log4j.Level;

public class NBTConverter {
    private static JsonElement NBTtoJSON_Base(NBTBase tag) {
        if (tag == null) {
            return new JsonObject();
        }
        if (tag.func_74732_a() >= 1 && tag.func_74732_a() <= 6) {
            return new JsonPrimitive(NBTConverter.getNumber(tag));
        }
        if (tag instanceof NBTTagString) {
            return new JsonPrimitive(((NBTTagString)tag).func_150285_a_());
        }
        if (tag instanceof NBTTagCompound) {
            return NBTConverter.NBTtoJSON_Compound((NBTTagCompound)tag, new JsonObject());
        }
        if (tag instanceof NBTTagList) {
            JsonArray jAry = new JsonArray();
            ArrayList<NBTBase> tagList = NBTConverter.getTagList((NBTTagList)tag);
            for (int i = 0; i < tagList.size(); ++i) {
                jAry.add(NBTConverter.NBTtoJSON_Base(tagList.get(i)));
            }
            return jAry;
        }
        if (tag instanceof NBTTagByteArray) {
            JsonArray jAry = new JsonArray();
            for (byte b : ((NBTTagByteArray)tag).func_150292_c()) {
                jAry.add((JsonElement)new JsonPrimitive((Number)b));
            }
            return jAry;
        }
        if (tag instanceof NBTTagIntArray) {
            JsonArray jAry = new JsonArray();
            for (int i : ((NBTTagIntArray)tag).func_150302_c()) {
                jAry.add((JsonElement)new JsonPrimitive((Number)i));
            }
            return jAry;
        }
        return new JsonObject();
    }

    public static JsonObject NBTtoJSON_Compound(NBTTagCompound parent, JsonObject jObj) {
        if (parent == null) {
            return jObj;
        }
        for (String key : parent.func_150296_c()) {
            NBTBase tag = parent.func_74781_a(key);
            if (tag == null) continue;
            jObj.add(key, NBTConverter.NBTtoJSON_Base(tag));
        }
        return jObj;
    }

    public static NBTTagCompound JSONtoNBT_Object(JsonObject jObj, NBTTagCompound tags) {
        if (jObj == null) {
            return tags;
        }
        for (Map.Entry entry : jObj.entrySet()) {
            try {
                tags.func_74782_a((String)entry.getKey(), NBTConverter.JSONtoNBT_Element((JsonElement)entry.getValue()));
            }
            catch (Exception e) {}
        }
        return tags;
    }

    private static NBTBase JSONtoNBT_Element(JsonElement jObj) {
        if (jObj == null) {
            return new NBTTagString();
        }
        int tagID = 0;
        if (jObj.isJsonPrimitive()) {
            JsonPrimitive prim = jObj.getAsJsonPrimitive();
            tagID = prim.isNumber() ? (prim.getAsString().contains(".") ? 6 : 4) : 8;
        } else if (jObj.isJsonArray()) {
            JsonArray array = jObj.getAsJsonArray();
            for (JsonElement entry : array) {
                if (entry.isJsonPrimitive() && tagID == 0) {
                    try {
                        array.get(0).getAsByte();
                        tagID = 7;
                    }
                    catch (Exception e) {
                        tagID = 11;
                    }
                    continue;
                }
                if (entry.isJsonPrimitive()) continue;
                tagID = 9;
                break;
            }
        } else {
            tagID = 10;
        }
        try {
            JsonArray jAry;
            if (tagID >= 1 && tagID <= 6) {
                return NBTConverter.instanceNumber(jObj.getAsNumber(), (byte)tagID);
            }
            if (tagID == 8) {
                return new NBTTagString(jObj.getAsString());
            }
            if (tagID == 10) {
                return NBTConverter.JSONtoNBT_Object(jObj.getAsJsonObject(), new NBTTagCompound());
            }
            if (tagID == 7) {
                jAry = jObj.getAsJsonArray();
                byte[] bAry = new byte[jAry.size()];
                for (int i = 0; i < jAry.size(); ++i) {
                    bAry[i] = jAry.get(i).getAsByte();
                }
                return new NBTTagByteArray(bAry);
            }
            if (tagID == 11) {
                jAry = jObj.getAsJsonArray();
                int[] iAry = new int[jAry.size()];
                for (int i = 0; i < jAry.size(); ++i) {
                    iAry[i] = jAry.get(i).getAsInt();
                }
                return new NBTTagIntArray(iAry);
            }
            if (tagID == 9) {
                jAry = jObj.getAsJsonArray();
                NBTTagList tList = new NBTTagList();
                for (int i = 0; i < jAry.size(); ++i) {
                    JsonElement jElm = jAry.get(i);
                    tList.func_74742_a(NBTConverter.JSONtoNBT_Element(jElm));
                }
                return tList;
            }
        }
        catch (Exception e) {
            CraftingDead.logger.log(Level.ERROR, "An error occured while parsing JsonElement to NBTBase (" + tagID + "):", (Throwable)e);
        }
        return new NBTTagString();
    }

    public static ArrayList<NBTBase> getTagList(NBTTagList tag) {
        return (ArrayList)ObfuscationReflectionHelper.getPrivateValue(NBTTagList.class, (Object)tag, (String[])new String[]{"tagList", "field_74747_a"});
    }

    public static Number getNumber(NBTBase tag) {
        if (tag instanceof NBTTagByte) {
            return ((NBTTagByte)tag).func_150290_f();
        }
        if (tag instanceof NBTTagShort) {
            return ((NBTTagShort)tag).func_150289_e();
        }
        if (tag instanceof NBTTagInt) {
            return ((NBTTagInt)tag).func_150287_d();
        }
        if (tag instanceof NBTTagFloat) {
            return Float.valueOf(((NBTTagFloat)tag).func_150288_h());
        }
        if (tag instanceof NBTTagDouble) {
            return ((NBTTagDouble)tag).func_150286_g();
        }
        if (tag instanceof NBTTagLong) {
            return ((NBTTagLong)tag).func_150291_c();
        }
        return 0;
    }

    public static NBTBase instanceNumber(Number num, byte type) {
        switch (type) {
            case 1: {
                return new NBTTagByte(num.byteValue());
            }
            case 2: {
                return new NBTTagShort(num.shortValue());
            }
            case 3: {
                return new NBTTagInt((int)num.shortValue());
            }
            case 4: {
                return new NBTTagLong(num.longValue());
            }
            case 5: {
                return new NBTTagFloat(num.floatValue());
            }
            case 6: {
                return new NBTTagDouble(num.doubleValue());
            }
        }
        return new NBTTagByte(num.byteValue());
    }
}

