/*
 * Decompiled with CFR 0.152.
 */
package craftingdead.world;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import craftingdead.blocks.tileentity.TileEntityLootPile;
import craftingdead.utils.NBTConverter;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class CityBuilding {
    Block[] blocks;
    int[] metadata;
    NBTTagCompound[] tiles;
    int sizeX;
    int sizeY;
    int sizeZ;
    int repStart = 0;
    int repEnd = 0;
    int repMax = 1;

    public static CityBuilding CreateFromJson(JsonObject json) {
        JsonArray blockMap = json.get("Blocks").getAsJsonArray();
        JsonArray metaMap = json.get("Metadata").getAsJsonArray();
        JsonArray tileMap = json.get("Tiles").getAsJsonArray();
        JsonArray repeat = json.get("Repeat").getAsJsonArray();
        int r0 = repeat.get(0).getAsInt();
        int r1 = repeat.get(1).getAsInt();
        int r2 = repeat.get(2).getAsInt();
        int sx = json.get("SizeX").getAsInt();
        int sy = json.get("SizeY").getAsInt();
        int sz = json.get("SizeZ").getAsInt();
        int l = sx * sy * sz;
        Block[] blocks = new Block[l];
        int[] metadata = new int[l];
        NBTTagCompound[] tiles = new NBTTagCompound[l];
        for (int i = 0; i < l; ++i) {
            blocks[i] = (Block)Block.field_149771_c.func_82594_a(blockMap.get(i).getAsString());
            metadata[i] = metaMap.get(i).getAsInt();
            tiles[i] = NBTConverter.JSONtoNBT_Object(tileMap.get(i).getAsJsonObject(), new NBTTagCompound());
        }
        CityBuilding building = new CityBuilding(sx, sy, sz, blocks, metadata, tiles);
        building.SetRepeat(r0, r1, r2);
        return building;
    }

    public CityBuilding(int sizeX, int sizeY, int sizeZ, Block[] blocks, int[] metadata, NBTTagCompound[] tiles) {
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
        this.blocks = blocks;
        this.metadata = metadata;
        this.tiles = tiles;
    }

    public void SetRepeat(int start, int end, int max) {
        this.repStart = start;
        this.repEnd = end;
        this.repMax = Math.max(1, max);
        if (this.repStart > this.repEnd) {
            int tmp = this.repStart;
            this.repStart = this.repEnd;
            this.repEnd = tmp;
        }
    }

    public void Build(World world, int x, int y, int z, Random rand) {
        int rRange = this.repEnd - this.repStart + 1;
        int reps = this.repMax > 0 ? rand.nextInt(this.repMax) + 1 : 1;
        for (int i = 0; i < this.blocks.length; ++i) {
            int ii = i / (this.sizeZ * this.sizeY) + x;
            int jj = i % (this.sizeZ * this.sizeY) / this.sizeZ + y;
            int kk = i % this.sizeZ + z;
            Block block = this.blocks[i];
            int meta = this.metadata[i];
            int n = 1;
            if (jj - y >= this.repStart && jj - y <= this.repEnd) {
                n = reps;
            } else if (jj - y > this.repEnd) {
                jj += (reps - 1) * rRange;
            }
            for (int l = 0; l < n; ++l) {
                world.func_147465_d(ii, jj, kk, block, meta, 3);
                TileEntity tile = world.func_147438_o(ii, jj, kk);
                if (tile != null) {
                    tile.func_145839_a(this.tiles[i]);
                    tile.field_145851_c = ii;
                    tile.field_145848_d = jj;
                    tile.field_145849_e = kk;
                    tile.func_145834_a(world);
                    if (tile instanceof TileEntityLootPile) {
                        TileEntityLootPile loot = (TileEntityLootPile)tile;
                        loot.lastSpawn = 0L;
                        tile.func_70296_d();
                    }
                }
                jj += rRange;
            }
        }
    }
}

