/*
 * Decompiled with CFR 0.152.
 */
package craftingdead.world;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import craftingdead.core.CraftingDead;
import craftingdead.world.CityBuilding;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import org.apache.logging.log4j.Level;

public class CityGenerator {
    public static HashMap<String, int[]> cities = new HashMap();
    static ArrayList<CityBuilding> largeBuild = new ArrayList();
    static ArrayList<CityBuilding> smallBuild = new ArrayList();
    static int citySize = 512;

    public static void LoadBuildings() {
        File[] files;
        smallBuild.clear();
        largeBuild.clear();
        File directory = new File("cd_buildings/");
        if (!directory.exists()) {
            CraftingDead.logger.log(Level.WARN, "City structure directory missing! No buildings will generate!");
            directory.mkdir();
            return;
        }
        for (File f : files = directory.listFiles()) {
            if (!f.getName().toLowerCase().endsWith(".json")) continue;
            try {
                FileReader fr = new FileReader(f);
                CityBuilding building = CityBuilding.CreateFromJson((JsonObject)new Gson().fromJson((Reader)fr, JsonObject.class));
                fr.close();
                int cx = MathHelper.func_76123_f((float)((float)building.sizeX / 16.0f));
                int cz = MathHelper.func_76123_f((float)((float)building.sizeZ / 16.0f));
                int cMax = Math.max(cx, cz);
                if (cMax == 1) {
                    smallBuild.add(building);
                    continue;
                }
                if (cMax == 2) {
                    largeBuild.add(building);
                    continue;
                }
                CraftingDead.logger.log(Level.WARN, "City structures larger than 2 chunks are currently not supported.");
                CraftingDead.logger.log(Level.WARN, "Structure '" + f.getName() + "' will not be generated.");
            }
            catch (Exception e) {
                CraftingDead.logger.log(Level.ERROR, "Unable to load city building file '" + f.getName() + "'", (Throwable)e);
            }
        }
        CraftingDead.logger.log(Level.INFO, "Loaded " + (largeBuild.size() + smallBuild.size()) + " city structures");
    }

    public static void generate(World world, int chunkX, int chunkZ) {
        int cityX = MathHelper.func_76141_d((float)((float)chunkX / (float)citySize));
        int cityZ = MathHelper.func_76141_d((float)((float)chunkZ / (float)citySize));
        String key = cityX + ":" + cityZ;
        Random rand = new Random((long)(cityX ^ cityZ) ^ world.func_72905_C());
        if (rand.nextInt(5) != 0) {
            // empty if block
        }
        int[] cityMap = new int[0x100000];
        if (cities.containsKey(key)) {
            cityMap = cities.get(key);
        } else {
            System.out.println("Generating at city (" + key + ")");
            cityMap = CityGenerator.GenNew(new Random((long)(cityX ^ cityZ) ^ world.func_72905_C()));
            cities.put(key, cityMap);
        }
        int px = (chunkX % citySize + citySize) % citySize;
        int pz = (chunkZ % citySize + citySize) % citySize;
        int index = pz * citySize + px;
        if (cityMap[index] < 0) {
            return;
        }
        CityGenerator.WriteToChunk(world.func_72964_e(chunkX, chunkZ), cityMap, px, pz);
    }

    public static void WriteToChunk(Chunk chunk, int[] cityMap, int x, int z) {
        int gLvl = chunk.func_76611_b(8, 8);
        BiomeGenBase biome = BiomeGenBase.func_150568_d((int)chunk.func_76605_m()[136]);
        if (gLvl > 76 && gLvl < 52) {
            return;
        }
        if (biome.field_76749_E >= 0.5f || Math.abs(biome.field_76748_D) >= 0.5f) {
            return;
        }
        Random rand = chunk.func_76617_a(chunk.field_76637_e.func_72905_C());
        int type = cityMap[z * citySize + x];
        if (type < 0) {
            return;
        }
        if (type >= 16 && type < 32 && x < citySize - 1 && z < citySize - 1 && x % 3 == 1 && z % 3 == 1 && largeBuild.size() > 0) {
            boolean t2;
            int b0 = (z + 1) * citySize + x;
            int b1 = z * citySize + x + 1;
            int b2 = (z + 1) * citySize + x + 1;
            boolean t0 = cityMap[b0] >= 16 && cityMap[b0] < 32;
            boolean t1 = cityMap[b1] >= 16 && cityMap[b1] < 32;
            boolean bl = t2 = cityMap[b2] >= 16 && cityMap[b2] < 32;
            if (t0 && t1 && t2) {
                cityMap[z * CityGenerator.citySize + x] = 18;
                cityMap[b0] = -1;
                cityMap[b1] = -1;
                cityMap[b2] = -1;
                largeBuild.get(rand.nextInt(largeBuild.size())).Build(chunk.field_76637_e, chunk.field_76635_g * 16, 64, chunk.field_76647_h * 16, rand);
                chunk.func_76603_b();
                return;
            }
        } else if (type >= 16 && type < 32 && smallBuild.size() > 0) {
            smallBuild.get(rand.nextInt(smallBuild.size())).Build(chunk.field_76637_e, chunk.field_76635_g * 16, 64, chunk.field_76647_h * 16, rand);
            chunk.func_76603_b();
            return;
        }
        for (int j = 64; j < 128; ++j) {
            ExtendedBlockStorage ebs = chunk.func_76587_i()[j >> 4];
            if (ebs == null) {
                chunk.func_76587_i()[j >> 4] = ebs = new ExtendedBlockStorage(j, !chunk.field_76637_e.field_73011_w.field_76576_e);
            }
            for (int i = 0; i < 16; ++i) {
                for (int k = 0; k < 16; ++k) {
                    if (type >= 0 && type < 16) {
                        if (j == 64) {
                            if (i > 1 && i < 14) {
                                if (k > 1 && k < 14 || k <= 1 && (type & 1) == 1 || k >= 14 && (type & 4) == 4) {
                                    ebs.func_150818_a(i, j & 0xF, k, Blocks.field_150406_ce);
                                    ebs.func_76654_b(i, j & 0xF, k, 9);
                                    continue;
                                }
                                ebs.func_150818_a(i, j & 0xF, k, (Block)Blocks.field_150334_T);
                                ebs.func_76654_b(i, j & 0xF, k, 0);
                                continue;
                            }
                            if (k > 1 && k < 14) {
                                if (i >= 14 && (type & 2) == 2 || i <= 1 && (type & 8) == 8) {
                                    ebs.func_150818_a(i, j & 0xF, k, Blocks.field_150406_ce);
                                    ebs.func_76654_b(i, j & 0xF, k, 9);
                                    continue;
                                }
                                ebs.func_150818_a(i, j & 0xF, k, (Block)Blocks.field_150334_T);
                                ebs.func_76654_b(i, j & 0xF, k, 0);
                                continue;
                            }
                            ebs.func_150818_a(i, j & 0xF, k, (Block)Blocks.field_150334_T);
                            ebs.func_76654_b(i, j & 0xF, k, 0);
                            continue;
                        }
                        ebs.func_150818_a(i, j & 0xF, k, Blocks.field_150350_a);
                        ebs.func_76654_b(i, j & 0xF, k, 0);
                        continue;
                    }
                    if (type == 16) {
                        if (j == 64) {
                            ebs.func_150818_a(i, j & 0xF, k, Blocks.field_150348_b);
                            ebs.func_76654_b(i, j & 0xF, k, 0);
                            continue;
                        }
                        ebs.func_150818_a(i, j & 0xF, k, Blocks.field_150350_a);
                        ebs.func_76654_b(i, j & 0xF, k, 0);
                        continue;
                    }
                    if (type == 18 || type < 32) continue;
                    if (j == 64) {
                        ebs.func_150818_a(i, j & 0xF, k, (Block)Blocks.field_150349_c);
                        ebs.func_76654_b(i, j & 0xF, k, 0);
                        continue;
                    }
                    ebs.func_150818_a(i, j & 0xF, k, Blocks.field_150350_a);
                    ebs.func_76654_b(i, j & 0xF, k, 0);
                }
            }
        }
        chunk.func_76603_b();
    }

    public static int[] GenNew(Random rand) {
        int i;
        int[] map = new int[citySize * citySize];
        Arrays.fill(map, -1);
        ArrayList<CityBlock> pending = new ArrayList<CityBlock>();
        for (i = 0; i < citySize / 3; ++i) {
            for (int k = 0; k < citySize / 3; ++k) {
                CityBlock block = new CityBlock(rand, i * 3, k * 3);
                pending.add(block);
            }
        }
        while (pending.size() > 0) {
            i = rand.nextInt(pending.size());
            ((CityBlock)pending.get(i)).WriteToMap(map);
            pending.remove(i);
        }
        return map;
    }

    public static void AttachRoads(int[] map, int x, int z) {
        int tmp;
        int index = z * citySize + x;
        int rot = 0;
        if (z - 1 >= 0 && (tmp = map[index - citySize]) >= 0 && tmp < 16) {
            ++rot;
            int n = index - citySize;
            map[n] = map[n] | 4;
        }
        if (x + 1 < citySize && (tmp = map[index + 1]) >= 0 && tmp < 16) {
            rot += 2;
            int n = index + 1;
            map[n] = map[n] | 8;
        }
        if (z + 1 < citySize && (tmp = map[index + citySize]) >= 0 && tmp < 16) {
            rot += 4;
            int n = index + citySize;
            map[n] = map[n] | 1;
        }
        if (x - 1 >= 0 && (tmp = map[index - 1]) >= 0 && tmp < 16) {
            rot += 8;
            int n = index - 1;
            map[n] = map[n] | 2;
        }
        map[index] = rot;
    }

    public static void SetAndRotateBuilding(int[] map, int x, int z) {
        int tmp;
        int index = z * citySize + x;
        int rot = 16;
        if (z - 1 >= 0 && (tmp = map[index - citySize]) >= 0 && tmp < 16) {
            ++rot;
        }
        if (x + 1 < citySize && (tmp = map[index + 1]) >= 0 && tmp < 16) {
            rot += 2;
        }
        if (z + 1 < citySize && (tmp = map[index + citySize]) >= 0 && tmp < 16) {
            rot += 4;
        }
        if (x - 1 >= 0 && (tmp = map[index - 1]) >= 0 && tmp < 16) {
            rot += 8;
        }
        map[index] = rot;
    }

    public static void DetachRoads(int[] map, int x, int z) {
        int tmp;
        int index = z * citySize + x;
        if (z - 1 >= 0 && (tmp = map[index - citySize]) >= 0 && tmp < 16) {
            int n = index - citySize;
            map[n] = map[n] & 0xFFFFFFFB;
        }
        if (x + 1 < citySize && (tmp = map[index + 1]) >= 0 && tmp < 16) {
            int n = index + 1;
            map[n] = map[n] & 0xFFFFFFF7;
        }
        if (z + 1 < citySize && (tmp = map[index + citySize]) >= 0 && tmp < 16) {
            int n = index + citySize;
            map[n] = map[n] & 0xFFFFFFFE;
        }
        if (x - 1 >= 0 && (tmp = map[index - 1]) >= 0 && tmp < 16) {
            int n = index - 1;
            map[n] = map[n] & 0xFFFFFFFD;
        }
    }

    public static class CityBlock {
        public int sizeX = 4;
        public int sizeZ = 4;
        public int x = 0;
        public int z = 0;

        public CityBlock(Random rand, int posX, int posZ) {
            this.x = posX;
            this.z = posZ;
            switch (rand.nextInt(5)) {
                case 1: 
                case 2: {
                    ++this.sizeX;
                    break;
                }
                case 3: 
                case 4: {
                    ++this.sizeZ;
                }
            }
        }

        public void WriteToMap(int[] map) {
            for (int k = 0; k < this.sizeZ; ++k) {
                for (int i = 0; i < this.sizeX; ++i) {
                    if (i + this.x < 0 || i + this.x >= citySize || k + this.z < 0 || k + this.z >= citySize) continue;
                    int mz = k + this.z;
                    int mx = i + this.x;
                    int index = mz * citySize + mx;
                    if (map[index] < 0 || map[index] >= 16) {
                        map[index] = 0;
                    }
                    if (i == 0 || i == this.sizeX - 1 || k == 0 || k == this.sizeZ - 1) {
                        map[index] = 0;
                        CityGenerator.AttachRoads(map, mx, mz);
                    } else if (i > 1 && i < this.sizeX - 2 && k > 1 && k < this.sizeZ - 2) {
                        map[index] = 0;
                    } else {
                        CityGenerator.SetAndRotateBuilding(map, mx, mz);
                    }
                    if (map[index] < 0 || map[index] >= 16) {
                        CityGenerator.DetachRoads(map, mx, mz);
                    }
                    if (map[index] < 0 || map[index] >= 16) continue;
                    if (mx <= 0) {
                        int n = index;
                        map[n] = map[n] & 0xFFFFFFF7;
                    } else if (mx >= 1023) {
                        int n = index;
                        map[n] = map[n] & 0xFFFFFFFD;
                    }
                    if (mz <= 0) {
                        int n = index;
                        map[n] = map[n] & 0xFFFFFFFE;
                        continue;
                    }
                    if (mz < 1023) continue;
                    int n = index;
                    map[n] = map[n] & 0xFFFFFFFB;
                }
            }
        }
    }
}

