/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.cauldron;

import com.google.gson.stream.JsonWriter;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.map.hash.TObjectLongHashMap;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.cauldron.TileEntityCache;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class CauldronHooks {
    public static boolean craftWorldLoading = false;
    public static int tickingDimension = 0;
    public static abp tickingChunk = null;
    public static Map<Class<? extends asp>, TileEntityCache> tileEntityCache = new HashMap<Class<? extends asp>, TileEntityCache>();
    private static TObjectLongHashMap<CollisionWarning> recentWarnings = new TObjectLongHashMap();

    public static void logInfo(String msg, Object ... args) {
        if (MinecraftServer.F().an() != null) {
            MinecraftServer.F().an().a(MessageFormat.format(msg, args));
        }
    }

    public static void logWarning(String msg, Object ... args) {
        if (MinecraftServer.F().an() != null) {
            MinecraftServer.F().an().b(MessageFormat.format(msg, args));
        }
    }

    public static void logSevere(String msg, Object ... args) {
        if (MinecraftServer.F().an() != null) {
            MinecraftServer.F().an().c(MessageFormat.format(msg, args));
        }
    }

    public static void logSevereException(Throwable throwable, String msg, Object ... args) {
        if (MinecraftServer.F().an() != null) {
            MinecraftServer.F().an().c(MessageFormat.format(msg, args), throwable);
        }
    }

    public static void logStack() {
        MinecraftServer.F();
        if (MinecraftServer.cauldronConfig.logWithStackTraces.getValue().booleanValue()) {
            Throwable ex = new Throwable();
            ex.fillInStackTrace();
            ex.printStackTrace();
        }
    }

    public static void logEntityDeath(nn entity) {
        MinecraftServer.F();
        if (MinecraftServer.cauldronConfig.entityDeathLogging.getValue().booleanValue()) {
            CauldronHooks.logInfo("Dim: {0} setDead(): {1}", entity.q.t.i, entity);
            CauldronHooks.logStack();
        }
    }

    public static void logEntityDespawn(nn entity, String reason) {
        MinecraftServer.F();
        if (MinecraftServer.cauldronConfig.entityDespawnLogging.getValue().booleanValue()) {
            CauldronHooks.logInfo("Dim: {0} Despawning ({1}): {2}", entity.q.t.i, reason, entity);
            CauldronHooks.logStack();
        }
    }

    public static void logEntitySpawn(abw world, nn entity, CreatureSpawnEvent.SpawnReason spawnReason) {
        MinecraftServer.F();
        if (MinecraftServer.cauldronConfig.entitySpawnLogging.getValue().booleanValue()) {
            CauldronHooks.logInfo("Dim: {0} Spawning ({1}): {2}", world.t.i, spawnReason, entity);
            CauldronHooks.logInfo("Dim: {0} Entities Last Tick: {1}", world.t.i, world.entitiesTicked);
            CauldronHooks.logInfo("Dim: {0} Tiles Last Tick: {1}", world.t.i, world.tilesTicked);
            CauldronHooks.logStack();
        }
    }

    public static void logChunkLoad(jr provider, int x, int z) {
        MinecraftServer.F();
        if (MinecraftServer.cauldronConfig.chunkLoadLogging.getValue().booleanValue()) {
            CauldronHooks.logInfo("Load Chunk At [{1}] ({2}, {3})", provider.h.t.i, x, z);
            long currentTick = MinecraftServer.F().aj();
            long lastAccessed = provider.lastAccessed(x, z);
            long diff = currentTick - lastAccessed;
            CauldronHooks.logInfo(" Last accessed: {0, number} Current Tick: {1, number} [{2, number}]", lastAccessed, currentTick, diff);
            CauldronHooks.logStack();
        }
    }

    public static void logChunkUnload(jr provider, int x, int z) {
        MinecraftServer.F();
        if (MinecraftServer.cauldronConfig.chunkUnloadLogging.getValue().booleanValue()) {
            CauldronHooks.logInfo("Unload Chunk At [{1}] ({2}, {3})", provider.h.t.i, x, z);
            long currentTick = MinecraftServer.F().aj();
            long lastAccessed = provider.lastAccessed(x, z);
            long diff = currentTick - lastAccessed;
            CauldronHooks.logInfo(" Last accessed: {0, number} Current Tick: {1, number} [{2, number}]", lastAccessed, currentTick, diff);
        }
    }

    public static boolean checkBoundingBoxSize(nn entity, asx aabb) {
        int logSize;
        block5: {
            block4: {
                MinecraftServer.F();
                logSize = MinecraftServer.cauldronConfig.largeBoundingBoxLogSize.getValue();
                if (logSize <= 0) break block4;
                MinecraftServer.F();
                if (MinecraftServer.cauldronConfig.checkEntityBoundingBoxes.getValue().booleanValue()) break block5;
            }
            return false;
        }
        int x = ls.c((double)aabb.a);
        int x1 = ls.c((double)(aabb.d + 1.0));
        int y = ls.c((double)aabb.b);
        int y1 = ls.c((double)(aabb.e + 1.0));
        int z = ls.c((double)aabb.c);
        int z1 = ls.c((double)(aabb.f + 1.0));
        int size = Math.abs(x1 - x) * Math.abs(y1 - y) * Math.abs(z1 - z);
        MinecraftServer.F();
        if (size > MinecraftServer.cauldronConfig.largeBoundingBoxLogSize.getValue()) {
            CauldronHooks.logWarning("Entity being removed for bounding box restrictions", new Object[0]);
            CauldronHooks.logWarning("BB Size: {0} > {1} avg edge: {2}", size, logSize, aabb.b());
            CauldronHooks.logWarning("Motion: ({0}, {1}, {2})", entity.x, entity.y, entity.z);
            CauldronHooks.logWarning("Calculated bounding box: {0}", aabb);
            CauldronHooks.logWarning("Entity bounding box: {0}", entity.E());
            CauldronHooks.logWarning("Entity: {0}", entity);
            by tag = new by();
            entity.e(tag);
            CauldronHooks.logWarning("Entity NBT: {0}", tag);
            CauldronHooks.logStack();
            entity.x();
            return true;
        }
        return false;
    }

    public static boolean checkEntitySpeed(nn entity, double x, double y, double z) {
        MinecraftServer.F();
        int maxSpeed = MinecraftServer.cauldronConfig.entityMaxSpeed.getValue();
        if (maxSpeed > 0) {
            double distance;
            MinecraftServer.F();
            if (MinecraftServer.cauldronConfig.checkEntityMaxSpeeds.getValue().booleanValue() && (distance = x * x + z * z) > (double)maxSpeed) {
                MinecraftServer.F();
                if (MinecraftServer.cauldronConfig.logEntitySpeedRemoval.getValue().booleanValue()) {
                    CauldronHooks.logInfo("Speed violation: {0} was over {1} - Removing Entity: {2}", distance, maxSpeed, entity);
                    if (entity instanceof of) {
                        of livingBase = (of)entity;
                        CauldronHooks.logInfo("Entity Motion: ({0}, {1}, {2}) Move Strafing: {3} Move Forward: {4}", entity.x, entity.y, entity.z, Float.valueOf(livingBase.be), Float.valueOf(livingBase.bf));
                    }
                    MinecraftServer.F();
                    if (MinecraftServer.cauldronConfig.logWithStackTraces.getValue().booleanValue()) {
                        CauldronHooks.logInfo("Move offset: ({0}, {1}, {2})", x, y, z);
                        CauldronHooks.logInfo("Motion: ({0}, {1}, {2})", entity.x, entity.y, entity.z);
                        CauldronHooks.logInfo("Entity: {0}", entity);
                        by tag = new by();
                        entity.e(tag);
                        CauldronHooks.logInfo("Entity NBT: {0}", tag);
                        CauldronHooks.logStack();
                    }
                }
                if (entity instanceof uf) {
                    entity.x = 0.0;
                    entity.y = 0.0;
                    entity.z = 0.0;
                    return false;
                }
                entity.M = true;
                return false;
            }
        }
        return true;
    }

    public static void logEntitySize(abw world, nn entity, List list) {
        MinecraftServer.F();
        if (!MinecraftServer.cauldronConfig.logEntityCollisionChecks.getValue().booleanValue()) {
            return;
        }
        MinecraftServer.F();
        long largeCountLogSize = MinecraftServer.cauldronConfig.largeCollisionLogSize.getValue().intValue();
        if (largeCountLogSize > 0L && (long)world.entitiesTicked > largeCountLogSize) {
            CauldronHooks.logWarning("Entity size > {0, number} at: {1}", largeCountLogSize, entity);
        }
        if (list == null) {
            return;
        }
        MinecraftServer.F();
        long largeCollisionLogSize = MinecraftServer.cauldronConfig.largeCollisionLogSize.getValue().intValue();
        if (largeCollisionLogSize > 0L && MinecraftServer.F().aj() % 10 == 0 && (long)list.size() >= largeCollisionLogSize) {
            CollisionWarning warning = new CollisionWarning(world, entity);
            if (recentWarnings.contains((Object)warning)) {
                long lastWarned = recentWarnings.get((Object)warning);
                if (MinecraftServer.aq() - lastWarned < 30000L) {
                    return;
                }
            }
            recentWarnings.put((Object)warning, System.currentTimeMillis());
            CauldronHooks.logWarning("Entity collision > {0, number} at: {1}", largeCollisionLogSize, entity);
        }
    }

    public static boolean canTileEntityTick(asp tileEntity, abw world) {
        if (tileEntity == null || world.tileentityConfig == null) {
            return false;
        }
        MinecraftServer.F();
        if (MinecraftServer.tileEntityConfig.skipTileEntityTicks.getValue().booleanValue()) {
            TileEntityCache teCache = tileEntityCache.get(tileEntity.getClass());
            if (teCache == null) {
                String teConfigPath = tileEntity.getClass().getName().replace(".", "-");
                teConfigPath = teConfigPath.replaceAll("[^A-Za-z0-9\\-]", "");
                teCache = new TileEntityCache(tileEntity.getClass(), world.N().k().toLowerCase(), teConfigPath, world.tileentityConfig.getBoolean(teConfigPath + ".tick-no-players", false), world.tileentityConfig.getInt(teConfigPath + ".tick-interval", 1));
                tileEntityCache.put(tileEntity.getClass(), teCache);
            }
            if (!teCache.tickNoPlayers && !world.isActiveBlockCoord(tileEntity.l, tileEntity.n)) {
                return false;
            }
            return teCache.tickInterval > 0 && world.N().f() % (long)teCache.tickInterval == 0L;
        }
        return true;
    }

    public static boolean canUpdate(asp tileEntity) {
        return tileEntity != null && tileEntity.canUpdate() && !MinecraftServer.bannedTileEntityUpdates.contains(tileEntity.getClass());
    }

    public static void writeChunks(File file, boolean logAll) {
        try {
            if (file.getParentFile() != null) {
                file.getParentFile().mkdirs();
            }
            FileWriter fileWriter = new FileWriter(file);
            JsonWriter writer = new JsonWriter((Writer)fileWriter);
            writer.setIndent("  ");
            writer.beginArray();
            for (js world : MinecraftServer.F().worlds) {
                writer.beginObject();
                writer.name("name").value(world.getWorld().getName());
                writer.name("dimensionId").value((long)world.t.i);
                writer.name("players").value((long)world.h.size());
                writer.name("loadedChunks").value((long)world.b.f.size());
                writer.name("activeChunks").value((long)world.G.size());
                writer.name("entities").value((long)world.e.size());
                writer.name("tiles").value((long)world.g.size());
                TObjectIntHashMap chunkEntityCounts = new TObjectIntHashMap();
                TObjectIntHashMap classEntityCounts = new TObjectIntHashMap();
                TObjectIntHashMap entityCollisionCounts = new TObjectIntHashMap();
                HashSet<t> collidingCoords = new HashSet<t>();
                for (int i = 0; i < world.e.size(); ++i) {
                    t coords;
                    nn entity = (nn)world.e.get(i);
                    abp chunkCoords = new abp((int)entity.u >> 4, (int)entity.w >> 4);
                    chunkEntityCounts.adjustOrPutValue((Object)chunkCoords, 1, 1);
                    classEntityCounts.adjustOrPutValue(entity.getClass(), 1, 1);
                    if (entity.E == null || !logAll || collidingCoords.contains(coords = new t((int)Math.floor(entity.u), (int)Math.floor(entity.v), (int)Math.floor(entity.w)))) continue;
                    collidingCoords.add(coords);
                    int size = entity.q.b(entity, entity.E.b(1.0, 1.0, 1.0)).size();
                    if (size < 5) continue;
                    entityCollisionCounts.put((Object)entity, size);
                }
                TObjectIntHashMap chunkTileCounts = new TObjectIntHashMap();
                TObjectIntHashMap classTileCounts = new TObjectIntHashMap();
                writer.name("tiles").beginArray();
                for (int i = 0; i < world.g.size(); ++i) {
                    asp tile = (asp)world.g.get(i);
                    if (logAll) {
                        writer.beginObject();
                        writer.name("type").value(tile.getClass().toString());
                        writer.name("x").value((long)tile.l);
                        writer.name("y").value((long)tile.m);
                        writer.name("z").value((long)tile.n);
                        writer.name("isInvalid").value(tile.r());
                        writer.name("canUpdate").value(tile.canUpdate());
                        writer.name("blockId").value("" + tile.q());
                        writer.endObject();
                    }
                    abp chunkCoords = new abp(tile.l >> 4, tile.n >> 4);
                    chunkTileCounts.adjustOrPutValue((Object)chunkCoords, 1, 1);
                    classTileCounts.adjustOrPutValue(tile.getClass(), 1, 1);
                }
                writer.endArray();
                if (logAll) {
                    CauldronHooks.writeChunkCounts(writer, "topEntityColliders", entityCollisionCounts, 20);
                }
                CauldronHooks.writeChunkCounts(writer, "entitiesByClass", classEntityCounts);
                CauldronHooks.writeChunkCounts(writer, "entitiesByChunk", chunkEntityCounts);
                CauldronHooks.writeChunkCounts(writer, "tilesByClass", classTileCounts);
                CauldronHooks.writeChunkCounts(writer, "tilesByChunk", chunkTileCounts);
                writer.endObject();
            }
            writer.endArray();
            writer.close();
            fileWriter.close();
        }
        catch (Throwable throwable) {
            MinecraftServer.F().an().c("Could not save chunk info report to " + file, throwable);
        }
    }

    private static <T> void writeChunkCounts(JsonWriter writer, String name, TObjectIntHashMap<T> map) throws IOException {
        CauldronHooks.writeChunkCounts(writer, name, map, 0);
    }

    private static <T> void writeChunkCounts(JsonWriter writer, String name, final TObjectIntHashMap<T> map, int max) throws IOException {
        ArrayList sortedCoords = new ArrayList(map.keySet());
        Collections.sort(sortedCoords, new Comparator<T>(){

            @Override
            public int compare(T s1, T s2) {
                return map.get(s2) - map.get(s1);
            }
        });
        int i = 0;
        writer.name(name).beginArray();
        for (Object key : sortedCoords) {
            if (max > 0 && i++ > max) break;
            if (map.get(key) < 5) continue;
            writer.beginObject();
            writer.name("key").value(key.toString());
            writer.name("count").value((long)map.get(key));
            writer.endObject();
        }
        writer.endArray();
    }

    public static void dumpHeap(File file, boolean live) {
        try {
            if (file.getParentFile() != null) {
                file.getParentFile().mkdirs();
            }
            Class<?> clazz = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            Object hotspotMBean = ManagementFactory.newPlatformMXBeanProxy(server, "com.sun.management:type=HotSpotDiagnostic", clazz);
            Method m2 = clazz.getMethod("dumpHeap", String.class, Boolean.TYPE);
            m2.invoke(hotspotMBean, file.getPath(), live);
        }
        catch (Throwable t2) {
            CauldronHooks.logSevereException(t2, "Could not write heap to {0}", file);
        }
    }

    public static void enableThreadContentionMonitoring() {
        MinecraftServer.F();
        if (!MinecraftServer.cauldronConfig.enableThreadContentionMonitoring.getValue().booleanValue()) {
            return;
        }
        ThreadMXBean mbean = ManagementFactory.getThreadMXBean();
        mbean.setThreadContentionMonitoringEnabled(true);
    }

    private static class CollisionWarning {
        public t chunkCoords;
        public int dimensionId;

        public CollisionWarning(abw world, nn entity) {
            this.dimensionId = world.t.i;
            this.chunkCoords = new t(entity.aj, entity.ak, entity.al);
        }

        public boolean equals(Object otherObj) {
            if (!(otherObj instanceof CollisionWarning) || otherObj == null) {
                return false;
            }
            CollisionWarning other = (CollisionWarning)otherObj;
            return other.dimensionId == this.dimensionId && other.chunkCoords.equals((Object)this.chunkCoords);
        }

        public int hashCode() {
            return this.chunkCoords.hashCode() + this.dimensionId;
        }
    }
}

