/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.cauldron.configuration;

import java.io.File;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.cauldron.command.CauldronCommand;
import net.minecraftforge.cauldron.configuration.BoolSetting;
import net.minecraftforge.cauldron.configuration.ConfigBase;
import net.minecraftforge.cauldron.configuration.IntSetting;
import net.minecraftforge.cauldron.configuration.Setting;
import org.bukkit.configuration.file.YamlConfiguration;

public class CauldronConfig
extends ConfigBase {
    private final String HEADER = "This is the main configuration file for Cauldron.\n\nIf you need help with the configuration or have any questions related to Cauldron,\njoin us at the IRC or drop by our forums and leave a post.\n\nIRC: #cauldron @ irc.esper.net ( http://webchat.esper.net/?channel=cauldron )\nForums: http://cauldron.minecraftforge.net/\n";
    public final BoolSetting dumpMaterials = new BoolSetting(this, "settings.dump-materials", false, "Dumps all materials with their corresponding id's");
    public final BoolSetting disableWarnings = new BoolSetting(this, "logging.disabled-warnings", false, "Disable warning messages to server admins");
    public final BoolSetting worldLeakDebug = new BoolSetting(this, "logging.world-leak-debug", false, "Log worlds that appear to be leaking (buggy)");
    public final BoolSetting connectionLogging = new BoolSetting(this, "logging.connection", false, "Log connections");
    public final BoolSetting tickIntervalLogging = new BoolSetting(this, "logging.tick-intervals", false, "Log when skip interval handlers are ticked");
    public final BoolSetting chunkLoadLogging = new BoolSetting(this, "logging.chunk-load", false, "Log when chunks are loaded (dev)");
    public final BoolSetting chunkUnloadLogging = new BoolSetting(this, "logging.chunk-unload", false, "Log when chunks are unloaded (dev)");
    public final BoolSetting entitySpawnLogging = new BoolSetting(this, "logging.entity-spawn", false, "Log when living entities are spawned (dev)");
    public final BoolSetting entityDespawnLogging = new BoolSetting(this, "logging.entity-despawn", false, "Log when living entities are despawned (dev)");
    public final BoolSetting entityDeathLogging = new BoolSetting(this, "logging.entity-death", false, "Log when an entity is destroyed (dev)");
    public final BoolSetting logWithStackTraces = new BoolSetting(this, "logging.detailed-logging", false, "Add stack traces to dev logging");
    public final BoolSetting dumpChunksOnDeadlock = new BoolSetting(this, "logging.dump-chunks-on-deadlock", false, "Dump chunks in the event of a deadlock (helps to debug the deadlock)");
    public final BoolSetting dumpHeapOnDeadlock = new BoolSetting(this, "logging.dump-heap-on-deadlock", false, "Dump the heap in the event of a deadlock (helps to debug the deadlock)");
    public final BoolSetting dumpThreadsOnWarn = new BoolSetting(this, "logging.dump-threads-on-warn", false, "Dump the the server thread on deadlock warning (delps to debug the deadlock)");
    public final BoolSetting logEntityCollisionChecks = new BoolSetting(this, "logging.entity-collision-checks", false, "Whether to log entity collision/count checks");
    public final BoolSetting logEntitySpeedRemoval = new BoolSetting(this, "logging.entity-speed-removal", false, "Whether to log entity removals due to speed");
    public final IntSetting largeCollisionLogSize = new IntSetting(this, "logging.collision-warn-size", 200, "Number of colliding entities in one spot before logging a warning. Set to 0 to disable");
    public final IntSetting largeEntityCountLogSize = new IntSetting(this, "logging.entity-count-warn-size", 0, "Number of entities in one dimension logging a warning. Set to 0 to disable");
    public final IntSetting printTileEntityUnloadTime = new IntSetting(this, "logging.print-tile-entity-unload-time", 100, "Print time used to unload tile entities if above this(Milliseconds). Set to 0 to disable");
    public final BoolSetting printQueuedChunkUnload = new BoolSetting(this, "logging.print-queued-chunk-unload", true, "Print a warning when chunks are queued due to hitting Tile Entity limit, including number of remaining chunks.");
    public final BoolSetting loadChunkOnRequest = new BoolSetting(this, "settings.load-chunk-on-request", true, "Forces Chunk Loading on 'Provide' requests (speedup for mods that don't check if a chunk is loaded");
    public final BoolSetting loadChunkOnForgeTick = new BoolSetting(this, "settings.load-chunk-on-forge-tick", false, "Forces Chunk Loading during Forge Server Tick events");
    public final BoolSetting checkEntityBoundingBoxes = new BoolSetting(this, "settings.check-entity-bounding-boxes", false, "Removes an entity that exceeds the max bounding box size.");
    public final BoolSetting checkEntityMaxSpeeds = new BoolSetting(this, "settings.check-entity-max-speeds", false, "Removes any entity that exceeds max speed.");
    public final IntSetting largeBoundingBoxLogSize = new IntSetting(this, "settings.entity-bounding-box-max-size", 1000, "Max size of an entity's bounding box before removing it (either being too large or bugged and 'moving' too fast)");
    public final IntSetting entityMaxSpeed = new IntSetting(this, "settings.entity-max-speed", 100, "Square of the max speed of an entity before removing it");
    public final IntSetting maxTileEntityUnloadPerTick = new IntSetting(this, "settings.max-tileentity-unload-per-tick", 1000, "Limit time spent on unloading chunks per tick. Once TileEntity limit is hit, queue chunk unloading until next tick(Per world)");
    public final IntSetting maxQueuedChunkUnload = new IntSetting(this, "settings.max-queued-chunk-unload", 628, "Limit number of chunks that can be queued for unloading due to high TileEntity count(Per world)");
    public final BoolSetting enableThreadContentionMonitoring = new BoolSetting(this, "debug.thread-contention-monitoring", false, "Set true to enable Java's thread contention monitoring for thread dumps");
    public final BoolSetting infiniteWaterSource = new BoolSetting(this, "world-settings.default.infinite-water-source", true, "Vanilla water source behavior - is infinite");
    public final BoolSetting flowingLavaDecay = new BoolSetting(this, "world-settings.default.flowing-lava-decay", false, "Lava behaves like vanilla water when source block is removed");
    public final BoolSetting fakePlayerLogin = new BoolSetting(this, "fake-players.do-login", false, "Raise login events for fake players");
    public final BoolSetting remapPluginFile = new BoolSetting(this, "plugin-settings.default.remap-plugin-file", false, "Remap the plugin file (dev)");

    public CauldronConfig(String fileName, String commandName) {
        super(fileName, commandName);
        this.init();
    }

    public void init() {
        this.settings.put(this.dumpMaterials.path, this.dumpMaterials);
        this.settings.put(this.disableWarnings.path, this.disableWarnings);
        this.settings.put(this.worldLeakDebug.path, this.worldLeakDebug);
        this.settings.put(this.connectionLogging.path, this.connectionLogging);
        this.settings.put(this.tickIntervalLogging.path, this.tickIntervalLogging);
        this.settings.put(this.chunkLoadLogging.path, this.chunkLoadLogging);
        this.settings.put(this.chunkUnloadLogging.path, this.chunkUnloadLogging);
        this.settings.put(this.entitySpawnLogging.path, this.entitySpawnLogging);
        this.settings.put(this.entityDespawnLogging.path, this.entityDespawnLogging);
        this.settings.put(this.entityDeathLogging.path, this.entityDeathLogging);
        this.settings.put(this.logWithStackTraces.path, this.logWithStackTraces);
        this.settings.put(this.dumpChunksOnDeadlock.path, this.dumpChunksOnDeadlock);
        this.settings.put(this.dumpHeapOnDeadlock.path, this.dumpHeapOnDeadlock);
        this.settings.put(this.dumpThreadsOnWarn.path, this.dumpThreadsOnWarn);
        this.settings.put(this.logEntityCollisionChecks.path, this.logEntityCollisionChecks);
        this.settings.put(this.logEntitySpeedRemoval.path, this.logEntitySpeedRemoval);
        this.settings.put(this.largeCollisionLogSize.path, this.largeCollisionLogSize);
        this.settings.put(this.largeEntityCountLogSize.path, this.largeEntityCountLogSize);
        this.settings.put(this.loadChunkOnRequest.path, this.loadChunkOnRequest);
        this.settings.put(this.loadChunkOnForgeTick.path, this.loadChunkOnForgeTick);
        this.settings.put(this.checkEntityBoundingBoxes.path, this.checkEntityBoundingBoxes);
        this.settings.put(this.checkEntityMaxSpeeds.path, this.checkEntityMaxSpeeds);
        this.settings.put(this.largeBoundingBoxLogSize.path, this.largeBoundingBoxLogSize);
        this.settings.put(this.enableThreadContentionMonitoring.path, this.enableThreadContentionMonitoring);
        this.settings.put(this.infiniteWaterSource.path, this.infiniteWaterSource);
        this.settings.put(this.flowingLavaDecay.path, this.flowingLavaDecay);
        this.settings.put(this.fakePlayerLogin.path, this.fakePlayerLogin);
        this.settings.put(this.remapPluginFile.path, this.remapPluginFile);
        this.settings.put(this.printTileEntityUnloadTime.path, this.printTileEntityUnloadTime);
        this.settings.put(this.printQueuedChunkUnload.path, this.printQueuedChunkUnload);
        this.settings.put(this.maxTileEntityUnloadPerTick.path, this.maxTileEntityUnloadPerTick);
        this.settings.put(this.maxQueuedChunkUnload.path, this.maxQueuedChunkUnload);
        this.load();
    }

    @Override
    public void addCommands() {
        this.commands.put(this.commandName, new CauldronCommand());
    }

    @Override
    public void load() {
        try {
            this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
            String header = "This is the main configuration file for Cauldron.\n\nIf you need help with the configuration or have any questions related to Cauldron,\njoin us at the IRC or drop by our forums and leave a post.\n\nIRC: #cauldron @ irc.esper.net ( http://webchat.esper.net/?channel=cauldron )\nForums: http://cauldron.minecraftforge.net/\n\n";
            for (Setting toggle : this.settings.values()) {
                if (!toggle.description.equals("")) {
                    header = header + "Setting: " + toggle.path + " Default: " + toggle.def + "   # " + toggle.description + "\n";
                }
                this.config.addDefault(toggle.path, toggle.def);
                ((Setting)this.settings.get(toggle.path)).setValue(this.config.getString(toggle.path));
            }
            this.config.options().header(header);
            this.config.options().copyDefaults(true);
            this.version = this.getInt("config-version", 1);
            this.set("config-version", 1);
            this.saveWorldConfigs();
            this.save();
        }
        catch (Exception ex) {
            MinecraftServer.F().h("Could not load " + this.configFile);
            ex.printStackTrace();
        }
    }
}

