/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraftforge.common.FakePlayer;
import net.minecraftforge.common.ForgeDummyContainer;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.PlayerOpenContainerEvent;
import net.minecraftforge.event.world.BlockEvent;

public class ForgeHooks {
    static final List<GrassEntry> grassList = new ArrayList<GrassEntry>();
    static final List<SeedEntry> seedList = new ArrayList<SeedEntry>();
    private static boolean toolInit = false;
    static HashMap<yc, List> toolClasses = new HashMap();
    static HashMap<List, Integer> toolHarvestLevels = new HashMap();
    static HashSet<List> toolEffectiveness = new HashSet();

    public static void plantGrass(abw world, int x2, int y, int z2) {
        GrassEntry grass = (GrassEntry)mi.a((Random)world.s, grassList);
        if (grass == null || grass.block == null || !grass.block.f(world, x2, y, z2)) {
            return;
        }
        world.f(x2, y, z2, grass.block.cF, grass.metadata, 3);
    }

    public static ye getGrassSeed(abw world) {
        SeedEntry entry = (SeedEntry)mi.a((Random)world.s, seedList);
        if (entry == null || entry.seed == null) {
            return null;
        }
        return entry.seed.m();
    }

    public static boolean canHarvestBlock(aqz block, uf player, int metadata) {
        if (block.cU.l()) {
            return true;
        }
        ye stack = player.bn.h();
        if (stack == null) {
            return player.a(block);
        }
        List info = toolClasses.get(stack.b());
        if (info == null) {
            return player.a(block);
        }
        Object[] tmp = info.toArray();
        String toolClass = (String)tmp[0];
        int harvestLevel = (Integer)tmp[1];
        Integer blockHarvestLevel = toolHarvestLevels.get(Arrays.asList(block, metadata, toolClass));
        if (blockHarvestLevel == null) {
            return player.a(block);
        }
        return blockHarvestLevel <= harvestLevel;
    }

    public static boolean canToolHarvestBlock(aqz block, int metadata, ye stack) {
        if (stack == null) {
            return false;
        }
        List info = toolClasses.get(stack.b());
        if (info == null) {
            return false;
        }
        Object[] tmp = info.toArray();
        String toolClass = (String)tmp[0];
        int harvestLevel = (Integer)tmp[1];
        Integer blockHarvestLevel = toolHarvestLevels.get(Arrays.asList(block, metadata, toolClass));
        return blockHarvestLevel != null && blockHarvestLevel <= harvestLevel;
    }

    public static float blockStrength(aqz block, uf player, abw world, int x2, int y, int z2) {
        int metadata = world.h(x2, y, z2);
        float hardness = block.l(world, x2, y, z2);
        if (hardness < 0.0f) {
            return 0.0f;
        }
        if (!ForgeHooks.canHarvestBlock(block, player, metadata)) {
            float speed = ForgeEventFactory.getBreakSpeed(player, block, metadata, 1.0f);
            return (speed < 0.0f ? 0.0f : speed) / hardness / 100.0f;
        }
        return player.getCurrentPlayerStrVsBlock(block, false, metadata) / hardness / 30.0f;
    }

    public static boolean isToolEffective(ye stack, aqz block, int metadata) {
        List toolClass = toolClasses.get(stack.b());
        return toolClass != null && toolEffectiveness.contains(Arrays.asList(block, metadata, toolClass.get(0)));
    }

    static void initTools() {
        if (toolInit) {
            return;
        }
        toolInit = true;
        MinecraftForge.setToolClass(yc.v, "pickaxe", 0);
        MinecraftForge.setToolClass(yc.z, "pickaxe", 1);
        MinecraftForge.setToolClass(yc.i, "pickaxe", 2);
        MinecraftForge.setToolClass(yc.K, "pickaxe", 0);
        MinecraftForge.setToolClass(yc.D, "pickaxe", 3);
        MinecraftForge.setToolClass(yc.w, "axe", 0);
        MinecraftForge.setToolClass(yc.A, "axe", 1);
        MinecraftForge.setToolClass(yc.j, "axe", 2);
        MinecraftForge.setToolClass(yc.L, "axe", 0);
        MinecraftForge.setToolClass(yc.E, "axe", 3);
        MinecraftForge.setToolClass(yc.u, "shovel", 0);
        MinecraftForge.setToolClass(yc.y, "shovel", 1);
        MinecraftForge.setToolClass(yc.h, "shovel", 2);
        MinecraftForge.setToolClass(yc.J, "shovel", 0);
        MinecraftForge.setToolClass(yc.C, "shovel", 3);
        for (aqz block : yn.c) {
            MinecraftForge.setBlockHarvestLevel(block, "pickaxe", 0);
        }
        for (aqz block : yy.c) {
            MinecraftForge.setBlockHarvestLevel(block, "shovel", 0);
        }
        for (aqz block : ya.c) {
            MinecraftForge.setBlockHarvestLevel(block, "axe", 0);
        }
        MinecraftForge.setBlockHarvestLevel(aqz.au, "pickaxe", 3);
        MinecraftForge.setBlockHarvestLevel(aqz.bW, "pickaxe", 2);
        MinecraftForge.setBlockHarvestLevel(aqz.aB, "pickaxe", 2);
        MinecraftForge.setBlockHarvestLevel(aqz.aC, "pickaxe", 2);
        MinecraftForge.setBlockHarvestLevel(aqz.L, "pickaxe", 2);
        MinecraftForge.setBlockHarvestLevel(aqz.am, "pickaxe", 2);
        MinecraftForge.setBlockHarvestLevel(aqz.M, "pickaxe", 1);
        MinecraftForge.setBlockHarvestLevel(aqz.an, "pickaxe", 1);
        MinecraftForge.setBlockHarvestLevel(aqz.S, "pickaxe", 1);
        MinecraftForge.setBlockHarvestLevel(aqz.T, "pickaxe", 1);
        MinecraftForge.setBlockHarvestLevel(aqz.aS, "pickaxe", 2);
        MinecraftForge.setBlockHarvestLevel(aqz.aT, "pickaxe", 2);
        MinecraftForge.removeBlockEffectiveness(aqz.aS, "pickaxe");
        MinecraftForge.removeBlockEffectiveness(aqz.au, "pickaxe");
        MinecraftForge.removeBlockEffectiveness(aqz.aT, "pickaxe");
    }

    public static int getTotalArmorValue(uf player) {
        int ret = 0;
        for (int x2 = 0; x2 < player.bn.b.length; ++x2) {
            ye stack = player.bn.b[x2];
            if (stack != null && stack.b() instanceof ISpecialArmor) {
                ret += ((ISpecialArmor)stack.b()).getArmorDisplay(player, stack, x2);
                continue;
            }
            if (stack == null || !(stack.b() instanceof wh)) continue;
            ret += ((wh)stack.b()).c;
        }
        return ret;
    }

    public static boolean onPickBlock(ata target, uf player, abw world) {
        int x2;
        ye result = null;
        boolean isCreative = player.bG.d;
        if (target.a == atb.a) {
            x2 = target.b;
            int y = target.c;
            int z2 = target.d;
            aqz var8 = aqz.s[world.a(x2, y, z2)];
            if (var8 == null) {
                return false;
            }
            result = var8.getPickBlock(target, world, x2, y, z2);
        } else {
            if (target.a != atb.b || target.g == null || !isCreative) {
                return false;
            }
            result = target.g.getPickedResult(target);
        }
        if (result == null) {
            return false;
        }
        for (x2 = 0; x2 < 9; ++x2) {
            ye stack = player.bn.a(x2);
            if (stack == null || !stack.a(result) || !ye.a((ye)stack, (ye)result)) continue;
            player.bn.c = x2;
            return true;
        }
        if (!isCreative) {
            return false;
        }
        int slot = player.bn.j();
        if (slot < 0 || slot >= 9) {
            slot = player.bn.c;
        }
        player.bn.a(slot, result);
        player.bn.c = slot;
        return true;
    }

    public static void onLivingSetAttackTarget(of entity, of target) {
        MinecraftForge.EVENT_BUS.post(new LivingSetAttackTargetEvent(entity, target));
    }

    public static boolean onLivingUpdate(of entity) {
        return MinecraftForge.EVENT_BUS.post(new LivingEvent.LivingUpdateEvent(entity));
    }

    public static boolean onLivingAttack(of entity, nb src, float amount) {
        return MinecraftForge.EVENT_BUS.post(new LivingAttackEvent(entity, src, amount));
    }

    public static float onLivingHurt(of entity, nb src, float amount) {
        LivingHurtEvent event = new LivingHurtEvent(entity, src, amount);
        return MinecraftForge.EVENT_BUS.post(event) ? 0.0f : event.ammount;
    }

    public static boolean onLivingDeath(of entity, nb src) {
        return MinecraftForge.EVENT_BUS.post(new LivingDeathEvent(entity, src));
    }

    public static boolean onLivingDrops(of entity, nb source, ArrayList<ss> drops, int lootingLevel, boolean recentlyHit, int specialDropValue) {
        return MinecraftForge.EVENT_BUS.post(new LivingDropsEvent(entity, source, drops, lootingLevel, recentlyHit, specialDropValue));
    }

    public static float onLivingFall(of entity, float distance) {
        LivingFallEvent event = new LivingFallEvent(entity, distance);
        return MinecraftForge.EVENT_BUS.post(event) ? 0.0f : event.distance;
    }

    public static boolean isLivingOnLadder(aqz block, abw world, int x2, int y, int z2, of entity) {
        if (!ForgeDummyContainer.fullBoundingBoxLadders) {
            return block != null && block.isLadder(world, x2, y, z2, entity);
        }
        asx bb = entity.E;
        int mX = ls.c((double)bb.a);
        int mY = ls.c((double)bb.b);
        int mZ = ls.c((double)bb.c);
        int y2 = mY;
        while ((double)y2 < bb.e) {
            int x22 = mX;
            while ((double)x22 < bb.d) {
                int z22 = mZ;
                while ((double)z22 < bb.f) {
                    block = aqz.s[world.a(x22, y2, z22)];
                    if (block != null && block.isLadder(world, x22, y2, z22, entity)) {
                        return true;
                    }
                    ++z22;
                }
                ++x22;
            }
            ++y2;
        }
        return false;
    }

    public static void onLivingJump(of entity) {
        MinecraftForge.EVENT_BUS.post(new LivingEvent.LivingJumpEvent(entity));
    }

    public static ss onPlayerTossEvent(uf player, ye item) {
        player.captureDrops = true;
        ss ret = player.a(item, false);
        if (ret == null) {
            return null;
        }
        player.capturedDrops.clear();
        player.captureDrops = false;
        if (ret == null) {
            return null;
        }
        ItemTossEvent event = new ItemTossEvent(ret, player);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return null;
        }
        player.a(event.entityItem);
        return event.entityItem;
    }

    public static float getEnchantPower(abw world, int x2, int y, int z2) {
        if (world.c(x2, y, z2)) {
            return 0.0f;
        }
        aqz block = aqz.s[world.a(x2, y, z2)];
        return block == null ? 0.0f : block.getEnchantPowerBonus(world, x2, y, z2);
    }

    public static cv onServerChatEvent(ka net, String raw, cv comp) {
        ServerChatEvent event = new ServerChatEvent(net.c, raw, comp);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return null;
        }
        return event.component;
    }

    public static boolean canInteractWith(uf player, uy openContainer) {
        PlayerOpenContainerEvent event = new PlayerOpenContainerEvent(player, openContainer);
        MinecraftForge.EVENT_BUS.post(event);
        return event.getResult() == Event.Result.DEFAULT ? event.canInteractWith : event.getResult() == Event.Result.ALLOW;
    }

    public static BlockEvent.BreakEvent onBlockBreakEvent(abw world, ace gameType, jv entityPlayer, int x2, int y, int z2) {
        if (world.r(x2, y, z2) == null && !(entityPlayer instanceof FakePlayer)) {
            gg packet = new gg(x2, y, z2, world);
            packet.d = 0;
            packet.e = 0;
            entityPlayer.a.b((ey)packet);
        }
        aqz block = aqz.s[world.a(x2, y, z2)];
        int blockMetadata = world.h(x2, y, z2);
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(x2, y, z2, world, block, blockMetadata, (uf)entityPlayer);
        MinecraftForge.EVENT_BUS.post(event);
        if (event.isCanceled() && !(entityPlayer instanceof FakePlayer)) {
            entityPlayer.a.b((ey)new gg(x2, y, z2, world));
            asp tileentity = world.r(x2, y, z2);
            if (tileentity != null) {
                entityPlayer.a.b(tileentity.m());
            }
        }
        return event;
    }

    static {
        grassList.add(new GrassEntry((aqz)aqz.ai, 0, 20));
        grassList.add(new GrassEntry((aqz)aqz.aj, 0, 10));
        seedList.add(new SeedEntry(new ye(yc.U), 10));
        ForgeHooks.initTools();
    }

    static class SeedEntry
    extends mj {
        public final ye seed;

        public SeedEntry(ye seed, int weight) {
            super(weight);
            this.seed = seed;
        }
    }

    static class GrassEntry
    extends mj {
        public final aqz block;
        public final int metadata;

        public GrassEntry(aqz block, int meta, int weight) {
            super(weight);
            this.block = block;
            this.metadata = meta;
        }
    }
}

